/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.dcn.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.sap.cloud.security.ams.dcl.client.dcn.TestInput;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.DcnBase;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.DcnGsonTools;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.DcnSerializerHelper;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class TestInputSerializer
extends DcnBase<TestInput> {
    public TestInputSerializer(DcnSerializerHelper helper) {
        super(helper);
    }

    @Override
    public TestInput deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject testCaseObject = jsonElement.getAsJsonObject();
        TestInput testInput = new TestInput();
        testInput.content((Map)context.deserialize(testCaseObject.get("input"), DcnGsonTools.TT_JSON_OBJECT));
        testInput.ignores((List)context.deserialize(testCaseObject.get("ignores"), DcnGsonTools.TT_LIST_ATTRIBUTE_NAME));
        testInput.unknowns((List)context.deserialize(testCaseObject.get("unknowns"), DcnGsonTools.TT_LIST_ATTRIBUTE_NAME));
        return testInput;
    }

    @Override
    public JsonElement serialize(TestInput testInput, Type type, JsonSerializationContext context) {
        JsonObject testInputObject = new JsonObject();
        testInputObject.add("input", context.serialize(testInput.content() != null ? testInput.content() : Collections.emptyMap()));
        this.helper.addIfContent(testInputObject, "ignores", context, testInput.ignores());
        this.helper.addIfContent(testInputObject, "unknowns", context, testInput.unknowns());
        return testInputObject;
    }
}

