/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.dcn.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.sap.cloud.security.ams.dcl.client.dcn.Use;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.DcnBase;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.DcnSerializerHelper;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

class UseSerializer
extends DcnBase<Use> {
    public UseSerializer(DcnSerializerHelper helper) {
        super(helper);
    }

    @Override
    public Use deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject useObject = json.getAsJsonObject();
        Use use = new Use();
        use.qualifiedPolicyName(this.helper.deserializeReferenceAsQualifiedName(useObject.get("use")));
        List<Object> restrictions = this.helper.deserializeExpression(useObject.getAsJsonArray("restrictions"), context);
        use.restrictions(restrictions);
        use.annotations((Map)context.deserialize(useObject.get("annotations"), (Type)((Object)Map.class)));
        return use;
    }

    @Override
    public JsonElement serialize(Use use, Type type, JsonSerializationContext context) {
        JsonObject useObject = new JsonObject();
        useObject.add("use", this.helper.serializeAsReference(use.qualifiedPolicyName()));
        useObject.add("restrictions", context.serialize(use.restrictions()));
        useObject.add("annotations", context.serialize(use.annotations()));
        return useObject;
    }
}

