/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.el;

import com.sap.cloud.security.ams.dcl.client.el.ELInternalTools;
import com.sap.cloud.security.ams.dcl.client.el.IQualifiedName;
import com.sap.cloud.security.ams.dcl.client.el.StringArrayIterator;
import com.sap.cloud.security.ams.dcl.client.language.DataControlLanguageTools;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public abstract class AbstractQualifiedName<T extends AbstractQualifiedName<T>>
implements IQualifiedName<T> {
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    final String[] segments;
    private final int hash;
    private volatile List<String> segmentsList;
    private final String stringVal;
    private static final AtomicReferenceFieldUpdater<AbstractQualifiedName, List> SEGMENTS_LIST_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AbstractQualifiedName.class, List.class, "segmentsList");

    AbstractQualifiedName() {
        this.segments = EMPTY_STRING_ARRAY;
        this.segmentsList = Collections.emptyList();
        this.stringVal = "";
        this.hash = this.computeHashCode();
    }

    AbstractQualifiedName(String[] segments) {
        this.segments = segments;
        this.stringVal = DataControlLanguageTools.encodeQualifiedName(segments);
        this.hash = this.computeHashCode();
    }

    AbstractQualifiedName(String[] segments, String stringVal) {
        this.segments = segments;
        this.stringVal = Objects.requireNonNull(stringVal);
        this.hash = this.computeHashCode();
    }

    AbstractQualifiedName(AbstractQualifiedName<T> other) {
        this.segments = other.segments;
        this.hash = other.hash;
        this.segmentsList = other.segmentsList;
        this.stringVal = other.stringVal;
    }

    @Override
    public final List<String> getSegments() {
        List<String> res = this.segmentsList;
        if (res != null) {
            return res;
        }
        res = ELInternalTools.createListWithOwnership(this.segments);
        return SEGMENTS_LIST_UPDATER.compareAndSet(this, null, res) ? res : this.segmentsList;
    }

    @Override
    public final int size() {
        return this.segments.length;
    }

    @Override
    public final String getSegment(int index) {
        return this.segments[index];
    }

    @Override
    public final String getFirstSegment() {
        return this.segments[0];
    }

    @Override
    public final String getLastSegment() {
        return this.segments[this.segments.length - 1];
    }

    @Override
    public final boolean startsWith(T other) {
        if (this == other) {
            return true;
        }
        String[] a1 = this.segments;
        String[] a2 = ((AbstractQualifiedName)other).segments;
        int size = a2.length;
        if (a1.length < size) {
            return false;
        }
        if (size == 0) {
            return true;
        }
        if (size == 1) {
            return Objects.equals(a1[0], a2[0]);
        }
        while (--size >= 0) {
            if (Objects.equals(a1[size], a2[size])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final T setLastSegment(String segment) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot change last segment of empty name.");
        }
        AbstractQualifiedName.requireContent(segment);
        if (this.getLastSegment().equals(segment)) {
            return this.self();
        }
        String[] newSegments = (String[])this.segments.clone();
        newSegments[newSegments.length - 1] = segment;
        return this.newInstance(newSegments);
    }

    public final String toEncodedString() {
        return this.stringVal;
    }

    public final String toString() {
        return this.stringVal;
    }

    @Override
    public final boolean isEmpty() {
        return this.segments.length == 0;
    }

    @Override
    public final T append(String part) {
        String[] newSegments;
        AbstractQualifiedName.requireContent(part);
        int size = this.segments.length;
        if (size == 0) {
            newSegments = new String[]{part};
        } else {
            newSegments = (String[])Arrays.copyOf(this.segments, size + 1, String[].class);
            newSegments[size] = part;
        }
        return this.newInstance(newSegments);
    }

    @Override
    public final T append(String ... parts) {
        Objects.requireNonNull(parts);
        if (parts.length == 0) {
            return this.self();
        }
        int idx = this.segments.length;
        if (idx == 0) {
            return this.newInstance(AbstractQualifiedName.copyArguments(parts));
        }
        String[] newSegments = (String[])Arrays.copyOf(this.segments, idx + parts.length, String[].class);
        for (String s : parts) {
            newSegments[idx++] = AbstractQualifiedName.requireContent(s);
        }
        return this.newInstance(newSegments);
    }

    @Override
    public final T append(List<String> parts) {
        Objects.requireNonNull(parts);
        if (parts.isEmpty()) {
            return this.self();
        }
        int idx = this.segments.length;
        if (idx == 0) {
            return this.newInstance(AbstractQualifiedName.copyArguments(parts));
        }
        String[] newSegments = (String[])Arrays.copyOf(this.segments, idx + parts.size(), String[].class);
        for (String s : parts) {
            newSegments[idx++] = AbstractQualifiedName.requireContent(s);
        }
        return this.newInstance(newSegments);
    }

    @Override
    public final T subName(int begin, int end) {
        if (begin == 0 && end == this.segments.length) {
            return this.self();
        }
        if (begin < 0 || begin > end || end > this.segments.length) {
            throw new IndexOutOfBoundsException("begin " + begin + ", end " + end + ", length " + this.segments.length);
        }
        return this.newInstance((String[])Arrays.copyOfRange(this.segments, begin, end, String[].class));
    }

    public final int hashCode() {
        return this.hash;
    }

    protected int computeHashCode() {
        int h;
        switch (this.segments.length) {
            case 0: {
                h = 1;
                break;
            }
            case 1: {
                h = 31 + this.segments[0].hashCode();
                break;
            }
            case 2: {
                h = 31 + this.segments[0].hashCode();
                h = 31 * h + this.segments[1].hashCode();
                break;
            }
            default: {
                h = Arrays.hashCode(this.segments);
            }
        }
        return h;
    }

    protected final boolean isEqual(AbstractQualifiedName<?> obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.hashCode() != obj.hashCode()) {
            return false;
        }
        String[] a1 = this.segments;
        String[] a2 = obj.segments;
        if (a1 == a2) {
            return true;
        }
        int i = a1.length;
        if (a2.length != i) {
            return false;
        }
        while (--i >= 0) {
            if (a1[i].equals(a2[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final Iterator<String> iterator() {
        return new StringArrayIterator(this.segments);
    }

    @Override
    public final int compareTo(T other) {
        String[] a1 = this.segments;
        int max = a1.length;
        String[] a2 = ((AbstractQualifiedName)other).segments;
        int c = a2.length;
        if (max == c) {
            c = 0;
        } else if (max < c) {
            c = -1;
        } else {
            max = c;
            c = 1;
        }
        for (int idx = 0; idx < max; ++idx) {
            int comp = a1[idx].compareTo(a2[idx]);
            if (comp == 0) continue;
            return comp;
        }
        return c;
    }

    private final T self() {
        return (T)this;
    }

    public abstract boolean equals(Object var1);

    protected abstract T newInstance(String[] var1);

    private static String[] copyArguments(String[] args) {
        return args == null || args.length == 0 ? EMPTY_STRING_ARRAY : (String[])args.clone();
    }

    private static String[] copyArguments(Collection<String> args) {
        return args == null || args.isEmpty() ? EMPTY_STRING_ARRAY : args.toArray(EMPTY_STRING_ARRAY);
    }

    static String requireContent(String data) {
        Objects.requireNonNull(data);
        if (data.isEmpty()) {
            throw new IllegalArgumentException("Empty parts are not allowed");
        }
        return data;
    }

    static String[] requireContent(String[] array) {
        Objects.requireNonNull(array);
        int end = array.length;
        for (int i = 0; i < end; ++i) {
            AbstractQualifiedName.requireContent(array[i]);
        }
        return array;
    }

    static <T extends Collection<String>> T requireContent(T list) {
        Objects.requireNonNull(list);
        if (list.isEmpty()) {
            return list;
        }
        for (String l : list) {
            AbstractQualifiedName.requireContent(l);
        }
        return list;
    }
}

