/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.el;

import com.sap.cloud.security.ams.dcl.client.el.ELInternalTools;
import com.sap.cloud.security.ams.dcl.client.el.ELTools;
import com.sap.cloud.security.ams.dcl.client.el.Expression;
import com.sap.cloud.security.ams.dcl.client.el.ObjectArrayIterator;
import com.sap.cloud.security.ams.dcl.client.el.QualifiedName;
import com.sap.cloud.security.ams.dcl.client.el.QualifiedNamesBuilder;
import com.sap.cloud.security.ams.dcl.client.el.Transformer;
import com.sap.cloud.security.ams.dcl.client.el.Visitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;

public class Call
implements Expression,
Iterable<Object> {
    private final QualifiedName qualifiedName;
    private final Object[] args;
    private transient int hash;
    private volatile transient List<Object> argsList;
    private static final AtomicReferenceFieldUpdater<Call, List> ARGS_LIST_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Call.class, List.class, "argsList");

    private Call(Object[] args, QualifiedName qualifiedName) {
        this.qualifiedName = Objects.requireNonNull(qualifiedName);
        this.args = args;
    }

    private Call(QualifiedName qualifiedName) {
        this(ELInternalTools.EMPTY_OBJECT_ARRAY, qualifiedName);
    }

    private Call(QualifiedName qualifiedName, Object argument) {
        this(new Object[]{argument}, qualifiedName);
    }

    private Call(QualifiedName qualifiedName, Object arg0, Object arg1) {
        this(new Object[]{arg0, arg1}, qualifiedName);
    }

    private Call(QualifiedName qualifiedName, Object arg0, Object arg1, Object arg2) {
        this(new Object[]{arg0, arg1, arg2}, qualifiedName);
    }

    protected Call(QualifiedName qualifiedName, Object[] args) {
        this(ELInternalTools.copyArguments(args), qualifiedName);
    }

    protected Call(Call other) {
        this.qualifiedName = other.qualifiedName;
        this.args = other.args;
        this.hash = other.hash;
        this.argsList = other.argsList;
    }

    public final int hashCode() {
        int h = this.hash;
        if (h == 0) {
            int prime = 31;
            h = 1;
            h = 31 * h + Arrays.hashCode(this.args);
            this.hash = h = 31 * h + this.qualifiedName.hashCode();
        }
        return h;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Call) {
            Call other = (Call)obj;
            return this.hashCode() == other.hashCode() && this.qualifiedName.equals(other.qualifiedName) && Arrays.equals(this.args, other.args);
        }
        return false;
    }

    @Override
    public final void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public final Object accept(Transformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public final Iterator<Object> iterator() {
        return this.args.length == 0 ? Collections.emptyIterator() : new ObjectArrayIterator(this.args);
    }

    public final String getName() {
        return this.qualifiedName.toEncodedString();
    }

    public final QualifiedName getQualifiedName() {
        return this.qualifiedName;
    }

    public final List<Object> getArguments() {
        List<Object> res = this.argsList;
        if (res != null) {
            return res;
        }
        res = ELInternalTools.createListWithOwnership(this.args);
        return ARGS_LIST_UPDATER.compareAndSet(this, null, res) ? res : this.argsList;
    }

    public final Object getArgument(int index) {
        return this.args[index];
    }

    public final int getArgumentCount() {
        return this.args.length;
    }

    public final String toString() {
        return ELTools.toString(this);
    }

    public final Call setName(String name) {
        return this.getName().equals(name) ? this : new Call(this.args, QualifiedNamesBuilder.globalParseQualifiedName(name));
    }

    public final Call setQualifiedName(QualifiedName qualifiedName) {
        return this.qualifiedName.equals(qualifiedName) ? this : new Call(this.args, qualifiedName);
    }

    @Override
    public final void forEach(Consumer<? super Object> action) {
        Objects.requireNonNull(action);
        Object[] a = this.args;
        int end = this.args.length;
        for (int i = 0; i < end; ++i) {
            action.accept(a[i]);
        }
    }

    public static Call create(String name) {
        return new Call(QualifiedNamesBuilder.globalParseQualifiedName(name));
    }

    public static Call create(String name, Object arg0) {
        return new Call(QualifiedNamesBuilder.globalParseQualifiedName(name), arg0);
    }

    public static Call create(String name, Object arg0, Object arg1) {
        return new Call(QualifiedNamesBuilder.globalParseQualifiedName(name), arg0, arg1);
    }

    public static Call create(String name, Object arg0, Object arg1, Object arg2) {
        return new Call(QualifiedNamesBuilder.globalParseQualifiedName(name), arg0, arg1, arg2);
    }

    public static Call create(String name, Object ... args) {
        return new Call(QualifiedNamesBuilder.globalParseQualifiedName(name), args);
    }

    public static Call createFrom(String name, Collection<?> args) {
        return new Call(ELInternalTools.copyArguments(args), QualifiedNamesBuilder.globalParseQualifiedName(name));
    }

    public static Call createFrom(String name, Object[] args, int start, int end) {
        return new Call(ELInternalTools.copyArguments(args, start, end), QualifiedNamesBuilder.globalParseQualifiedName(name));
    }

    public static Call create(QualifiedName qualifiedName) {
        return new Call(qualifiedName);
    }

    public static Call create(QualifiedName qualifiedName, Object arg0) {
        return new Call(qualifiedName, arg0);
    }

    public static Call create(QualifiedName qualifiedName, Object arg0, Object arg1) {
        return new Call(qualifiedName, arg0, arg1);
    }

    public static Call create(QualifiedName qualifiedName, Object arg0, Object arg1, Object arg2) {
        return new Call(qualifiedName, arg0, arg1, arg2);
    }

    public static Call create(QualifiedName qualifiedName, Object ... args) {
        return new Call(qualifiedName, args);
    }

    public static Call createFrom(QualifiedName qualifiedName, Collection<?> args) {
        return new Call(ELInternalTools.copyArguments(args), qualifiedName);
    }

    public static Call createFrom(QualifiedName qualifiedName, Object[] args, int start, int end) {
        return new Call(ELInternalTools.copyArguments(args, start, end), qualifiedName);
    }

    public static interface QualifiedNames {
        public static final QualifiedName AND = QualifiedName.create("and");
        public static final QualifiedName OR = QualifiedName.create("or");
        public static final QualifiedName IS_NULL = QualifiedName.create("is_null");
        public static final QualifiedName IS_NOT_NULL = QualifiedName.create("is_not_null");
        public static final QualifiedName LIKE = QualifiedName.create("like");
        public static final QualifiedName NOT_LIKE = QualifiedName.create("not_like");
        public static final QualifiedName IN = QualifiedName.create("in");
        public static final QualifiedName NOT_IN = QualifiedName.create("not_in");
        public static final QualifiedName LT = QualifiedName.create("lt");
        public static final QualifiedName LE = QualifiedName.create("le");
        public static final QualifiedName EQ = QualifiedName.create("eq");
        public static final QualifiedName NE = QualifiedName.create("ne");
        public static final QualifiedName GE = QualifiedName.create("ge");
        public static final QualifiedName GT = QualifiedName.create("gt");
        public static final QualifiedName BETWEEN = QualifiedName.create("between");
        public static final QualifiedName NOT_BETWEEN = QualifiedName.create("not_between");
        public static final QualifiedName RESTRICTED = QualifiedName.create("restricted");
        public static final QualifiedName NOT_RESTRICTED = QualifiedName.create("not_restricted");
    }

    public static interface Names {
        public static final String AND = "and";
        public static final String OR = "or";
        public static final String IS_NULL = "is_null";
        public static final String IS_NOT_NULL = "is_not_null";
        public static final String LIKE = "like";
        public static final String NOT_LIKE = "not_like";
        public static final String IN = "in";
        public static final String NOT_IN = "not_in";
        public static final String LT = "lt";
        public static final String LE = "le";
        public static final String EQ = "eq";
        public static final String NE = "ne";
        public static final String GE = "ge";
        public static final String GT = "gt";
        public static final String BETWEEN = "between";
        public static final String NOT_BETWEEN = "not_between";
        public static final String RESTRICTED = "restricted";
        public static final String NOT_RESTRICTED = "not_restricted";
    }
}

