/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.el;

import com.sap.cloud.security.ams.dcl.client.el.UnmodifiableArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

final class ELInternalTools {
    static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    private ELInternalTools() {
    }

    static Object[] copyArguments(Object[] args) {
        return args == null || args.length == 0 ? EMPTY_OBJECT_ARRAY : (Object[])args.clone();
    }

    static Object[] copyArguments(Collection<?> args) {
        return args == null || args.isEmpty() ? EMPTY_OBJECT_ARRAY : args.toArray();
    }

    static Object[] copyArguments(Object[] args, int start, int end) {
        int size = end - start;
        switch (size) {
            case 0: {
                return EMPTY_OBJECT_ARRAY;
            }
            case 1: {
                return new Object[]{args[start]};
            }
        }
        return Arrays.copyOfRange(args, start, end, Object[].class);
    }

    static <U> List<U> createListWithOwnership(U[] list) {
        if (list == null) {
            return Collections.emptyList();
        }
        switch (list.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list[0]);
            }
        }
        return new UnmodifiableArrayList<U>(list);
    }

    static <U> List<U> createFrom(U[] array, Collection<U> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list instanceof List ? ((List)list).get(0) : list.iterator().next());
            }
        }
        return new UnmodifiableArrayList<U>(list.toArray(array));
    }
}

