/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.el;

import com.sap.cloud.security.ams.dcl.client.el.AttributeName;
import com.sap.cloud.security.ams.dcl.client.el.ELInternalTools;
import com.sap.cloud.security.ams.dcl.client.el.ELTools;
import com.sap.cloud.security.ams.dcl.client.el.Expression;
import com.sap.cloud.security.ams.dcl.client.el.Transformer;
import com.sap.cloud.security.ams.dcl.client.el.Visitor;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class FilterClause
implements Expression {
    private final Object condition;
    private final List<AttributeName> unknowns;
    private final List<AttributeName> ignores;
    private transient int hash;
    private static final AttributeName[] NAME_ARRAY = new AttributeName[0];

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object accept(Transformer transformer) {
        return transformer.transform(this);
    }

    private FilterClause(Object condition, Collection<AttributeName> unknowns, Collection<AttributeName> ignores) {
        this.condition = Objects.requireNonNull(condition);
        this.unknowns = ELInternalTools.createFrom(NAME_ARRAY, unknowns);
        this.ignores = ELInternalTools.createFrom(NAME_ARRAY, ignores);
    }

    private FilterClause(FilterClause root, Object condition) {
        this.condition = Objects.requireNonNull(condition);
        this.unknowns = root.unknowns;
        this.ignores = root.ignores;
    }

    public FilterClause(Object condition) {
        this(condition, null, null);
    }

    public List<AttributeName> getUnknowns() {
        return this.unknowns;
    }

    public List<AttributeName> getIgnores() {
        return this.ignores;
    }

    public Object getCondition() {
        return this.condition;
    }

    public String toString() {
        return ELTools.toString(this);
    }

    public FilterClause setCondition(Object condition) {
        return this.condition == condition ? this : new FilterClause(this, condition);
    }

    public boolean isGranted() {
        return Boolean.TRUE.equals(this.condition);
    }

    public boolean isDenied() {
        return Boolean.FALSE.equals(this.condition);
    }

    public int hashCode() {
        int h = this.hash;
        if (h != 0) {
            return h;
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + this.condition.hashCode();
        result = 31 * result + this.unknowns.hashCode();
        this.hash = result = 31 * result + this.ignores.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilterClause other = (FilterClause)obj;
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        if (!this.condition.equals(other.condition)) {
            return false;
        }
        if (!this.unknowns.equals(other.unknowns)) {
            return false;
        }
        return this.ignores.equals(other.ignores);
    }

    public static FilterClause create(Object condition, Collection<AttributeName> unknowns, Collection<AttributeName> ignores) {
        return new FilterClause(condition, unknowns, ignores);
    }
}

