/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.el;

import com.sap.cloud.security.ams.dcl.client.el.AbstractQualifiedName;
import com.sap.cloud.security.ams.dcl.client.el.AttributeName;
import com.sap.cloud.security.ams.dcl.client.el.Call;
import com.sap.cloud.security.ams.dcl.client.el.QualifiedName;
import com.sap.cloud.security.ams.dcl.client.language.DataControlLanguageNames;
import com.sap.cloud.security.ams.dcl.client.language.DataControlLanguageTools;
import com.sap.cloud.security.ams.dcl.client.language.TokenFormat;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public final class QualifiedNamesBuilder {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    static final Map<String, QualifiedName> DEFAULT_QUALIFIED_NAMES = new HashMap<String, QualifiedName>();
    static final Map<String, AttributeName> DEFAULT_ATTRIBUTE_NAMES = new HashMap<String, AttributeName>();
    private static final Locale LOCALE = Locale.ENGLISH;
    private static final String ERR_EMPTY_SEGMENT = "Invalid qualifiedString '%s'. Empty segment.";
    private static final String ERR_STRING_TERMINATION = "Invalid qualifiedString '%s'. String terminated with \\.";
    private static final String ERR_INCORRECT_ESCAPE = "Invalid qualifiedString '%s'. Invalid escape sequence character '%c'.";
    private static final String ERR_MISSING_SEPARATOR = "Invalid qualifiedString '%s'. Separator '.' expected.";
    private static final String ERR_STRING_NOT_TERMINATED = "Invalid qualifiedString '%s'. String not terminated.";
    private static final String ERR_WRONG_QUOTES = "Invalid qualifiedString '%s' Wrong quotes.";
    private List<String> segments;
    private StringBuilder buffer;
    private static final int GL_QNB_COUNT = 7;
    private static final QualifiedNamesBuilder[] GLOBAL_QNBs = new QualifiedNamesBuilder[7];

    public AttributeName parseAttributeName(String qualifiedString) {
        AttributeName an = DEFAULT_ATTRIBUTE_NAMES.get(qualifiedString);
        if (an != null) {
            return an;
        }
        this.parseList(qualifiedString, true);
        if (this.segments.isEmpty()) {
            return AttributeName.EMPTY;
        }
        an = this.createAttributeName(this.segments, false);
        return an;
    }

    public AttributeName createAttributeName(List<String> segments) {
        return this.createAttributeName(segments, true);
    }

    public QualifiedName parseQualifiedName(String qualifiedString) {
        QualifiedName qn = DEFAULT_QUALIFIED_NAMES.get(qualifiedString);
        if (qn != null) {
            return qn;
        }
        this.parseList(qualifiedString, false);
        qn = this.createQualifiedName(this.segments, false);
        return qn;
    }

    public QualifiedName createQualifiedName(List<String> segments) {
        return this.createQualifiedName(segments, true);
    }

    private StringBuilder grantStringBuilder() {
        StringBuilder res = this.buffer;
        if (res == null) {
            this.buffer = res = new StringBuilder(256);
        }
        return res;
    }

    private QualifiedName createQualifiedName(List<String> segments, boolean externalData) {
        if (segments == null || segments.isEmpty()) {
            return QualifiedName.EMPTY;
        }
        if (externalData) {
            QualifiedName qn;
            AbstractQualifiedName.requireContent(segments);
            if (segments.size() == 1 && (qn = DEFAULT_QUALIFIED_NAMES.get(segments.get(0))) != null) {
                return qn;
            }
        }
        String content = DataControlLanguageTools.encodeQualifiedName(segments, this.grantStringBuilder());
        return new QualifiedName(QualifiedNamesBuilder.getSegmentsAsArray(segments), content);
    }

    private AttributeName createAttributeName(List<String> segments, boolean externalData) {
        if (segments == null || segments.isEmpty()) {
            return AttributeName.EMPTY;
        }
        if (externalData) {
            AttributeName an;
            AbstractQualifiedName.requireContent(segments);
            if (segments.size() == 1 && (an = DEFAULT_ATTRIBUTE_NAMES.get(segments.get(0))) != null) {
                return an;
            }
        }
        String content = DataControlLanguageTools.encodeQualifiedName(segments, this.grantStringBuilder());
        return new AttributeName(QualifiedNamesBuilder.getSegmentsAsArray(segments), content);
    }

    private static String[] getSegmentsAsArray(List<String> segments) {
        String[] stringArray;
        if (segments.size() == 1) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = segments.get(0);
        } else {
            stringArray = segments.toArray(EMPTY_STRING_ARRAY);
        }
        return stringArray;
    }

    private List<String> parseList(String qualifiedString, boolean prefix) {
        String first;
        Objects.requireNonNull(qualifiedString);
        if (this.segments == null) {
            this.segments = new ArrayList<String>();
        } else {
            this.segments.clear();
        }
        int length = qualifiedString.length();
        if (length == 0) {
            return this.segments;
        }
        int previous = 0;
        while (true) {
            int idx;
            if ((idx = TokenFormat.PLAIN.consume(qualifiedString, previous, length)) == length) {
                if (idx == previous) {
                    throw new IllegalArgumentException(String.format(LOCALE, ERR_EMPTY_SEGMENT, qualifiedString));
                }
                this.segments.add(qualifiedString.substring(previous, idx));
                break;
            }
            char ch = qualifiedString.charAt(idx);
            if (ch == '\"') {
                if (idx != previous) {
                    throw new IllegalArgumentException(String.format(LOCALE, ERR_WRONG_QUOTES, qualifiedString));
                }
                idx = this.scanString(qualifiedString, idx, length);
            } else {
                if (idx == previous) {
                    throw new IllegalArgumentException(String.format(LOCALE, ERR_EMPTY_SEGMENT, qualifiedString));
                }
                this.segments.add(qualifiedString.substring(previous, idx));
            }
            if (idx == length) break;
            if (qualifiedString.charAt(idx++) != '.') {
                throw new IllegalArgumentException(String.format(LOCALE, ERR_MISSING_SEPARATOR, qualifiedString));
            }
            previous = idx;
        }
        if (prefix && !DataControlLanguageNames.ALL_SECTIONS.contains(first = this.segments.get(0))) {
            if (first.startsWith("$")) {
                this.segments.add(0, "$env");
            } else {
                this.segments.add(0, "$app");
            }
        }
        return this.segments;
    }

    private int scanString(String data, int idx, int length) {
        StringBuilder sb = this.grantStringBuilder();
        int previous = ++idx;
        sb.setLength(0);
        while (idx < length) {
            char ch;
            if ((ch = data.charAt(idx++)) == '\"') {
                int end = idx - 1;
                if (end != previous) {
                    if (sb.length() == 0) {
                        this.segments.add(data.substring(previous, end));
                    } else {
                        sb.append(data, previous, end);
                        this.segments.add(sb.toString());
                    }
                } else {
                    if (sb.length() == 0) {
                        throw new IllegalArgumentException(String.format(LOCALE, ERR_EMPTY_SEGMENT, data));
                    }
                    this.segments.add(sb.toString());
                }
                return idx;
            }
            if (ch != '\\') continue;
            if (idx == length) {
                throw new IllegalArgumentException(String.format(LOCALE, ERR_STRING_TERMINATION, data));
            }
            ch = data.charAt(idx);
            if (ch != '\\' && ch != '\"') {
                throw new IllegalArgumentException(String.format(LOCALE, ERR_INCORRECT_ESCAPE, data, Character.valueOf(ch)));
            }
            sb.append(data, previous, idx - 1);
            sb.append(ch);
            previous = ++idx;
        }
        throw new IllegalArgumentException(String.format(LOCALE, ERR_STRING_NOT_TERMINATED, data));
    }

    private static <T extends AbstractQualifiedName<T>> void populate(Class<T> clazz, Map<String, T> map, Class<?> source) throws IllegalArgumentException, IllegalAccessException {
        for (Field f : source.getDeclaredFields()) {
            if (!clazz.isAssignableFrom(f.getType())) continue;
            AbstractQualifiedName qn = (AbstractQualifiedName)clazz.cast(f.get(null));
            map.put(qn.toEncodedString(), qn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QualifiedName globalParseQualifiedName(String name) {
        QualifiedName qn = DEFAULT_QUALIFIED_NAMES.get(name);
        if (qn != null) {
            return qn;
        }
        if (TokenFormat.PLAIN.isToken(name)) {
            qn = QualifiedName.create(name);
        } else {
            QualifiedNamesBuilder qnb;
            QualifiedNamesBuilder qualifiedNamesBuilder = qnb = GLOBAL_QNBs[(int)(Thread.currentThread().getId() % 7L)];
            synchronized (qualifiedNamesBuilder) {
                qn = qnb.parseQualifiedName(name);
            }
        }
        return qn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AttributeName globalParseAttributeName(String name) {
        QualifiedNamesBuilder qnb;
        AttributeName an = DEFAULT_ATTRIBUTE_NAMES.get(name);
        if (an != null) {
            return an;
        }
        QualifiedNamesBuilder qualifiedNamesBuilder = qnb = GLOBAL_QNBs[(int)(Thread.currentThread().getId() % 7L)];
        synchronized (qualifiedNamesBuilder) {
            an = qnb.parseAttributeName(name);
        }
        return an;
    }

    public static AttributeName toCachedIfAvailable(AttributeName attributeName) {
        AttributeName an = DEFAULT_ATTRIBUTE_NAMES.get(attributeName.toEncodedString());
        return an != null ? an : attributeName;
    }

    public static QualifiedNamesBuilder create() {
        return new QualifiedNamesBuilder();
    }

    static {
        for (int i = 0; i < GLOBAL_QNBs.length; ++i) {
            QualifiedNamesBuilder.GLOBAL_QNBs[i] = QualifiedNamesBuilder.create();
        }
        try {
            QualifiedNamesBuilder.populate(QualifiedName.class, DEFAULT_QUALIFIED_NAMES, Call.Names.class);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new ExceptionInInitializerError(e);
        }
        QualifiedNamesBuilder qnb = QualifiedNamesBuilder.create();
        for (String name : DataControlLanguageNames.ALL_NAMES) {
            DEFAULT_ATTRIBUTE_NAMES.put(name, qnb.parseAttributeName(name));
        }
    }
}

