/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.el;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

class UnmodifiableArrayList<T>
extends AbstractList<T>
implements RandomAccess,
Serializable {
    private static final long serialVersionUID = -6039432128491719214L;
    private final T[] a;

    public UnmodifiableArrayList(T[] array) {
        this.a = Objects.requireNonNull(array);
    }

    @Override
    public int size() {
        return this.a.length;
    }

    @Override
    public Object[] toArray() {
        Object[] res = new Object[this.a.length];
        System.arraycopy(this.a, 0, res, 0, this.a.length);
        return res;
    }

    @Override
    public <U> U[] toArray(U[] a) {
        int size = this.size();
        if (a.length < size) {
            return Arrays.copyOf(this.a, size, a.getClass());
        }
        System.arraycopy(this.a, 0, a, 0, size);
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public T get(int index) {
        return this.a[index];
    }

    @Override
    public int indexOf(Object o) {
        T[] a = this.a;
        if (o == null) {
            for (int i = 0; i < a.length; ++i) {
                if (a[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < a.length; ++i) {
                if (!o.equals(a[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        T[] a = this.a;
        int idx = a.length;
        if (o == null) {
            while (idx-- > 0) {
                if (a[idx] != null) continue;
                return idx;
            }
        } else {
            while (idx-- > 0) {
                if (!o.equals(a[idx])) continue;
                return idx;
            }
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public Iterator<T> iterator() {
        return new ArrayItr<T>(this.a);
    }

    @Override
    public ListIterator<T> listIterator() {
        return new ArrayListItr<T>(this.a);
    }

    @Override
    public Spliterator<T> spliterator() {
        return Spliterators.spliterator(this.a, 16);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        for (T e : this.a) {
            action.accept(e);
        }
    }

    @Override
    public void replaceAll(UnaryOperator<T> operator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sort(Comparator<? super T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.a);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return super.equals(obj);
        }
        UnmodifiableArrayList other = (UnmodifiableArrayList)obj;
        return Arrays.equals(this.a, other.a);
    }

    private static class ArrayItr<E>
    implements Iterator<E> {
        protected final E[] data;
        protected int idx;

        public ArrayItr(E[] data) {
            this.data = data;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.data.length;
        }

        @Override
        public E next() {
            if (this.idx == this.data.length) {
                throw new NoSuchElementException();
            }
            return this.data[this.idx++];
        }
    }

    private static class ArrayListItr<E>
    extends ArrayItr<E>
    implements ListIterator<E> {
        public ArrayListItr(E[] data) {
            super(data);
        }

        @Override
        public boolean hasPrevious() {
            return this.idx > 0;
        }

        @Override
        public E previous() {
            if (this.idx == 0) {
                throw new NoSuchElementException();
            }
            return (E)this.data[--this.idx];
        }

        @Override
        public int nextIndex() {
            return this.idx;
        }

        @Override
        public int previousIndex() {
            return this.idx - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }
}

