/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.el;

import com.sap.cloud.security.ams.dcl.client.el.AbstractQualifiedName;
import com.sap.cloud.security.ams.dcl.client.el.AttributeName;
import com.sap.cloud.security.ams.dcl.client.el.Call;
import com.sap.cloud.security.ams.dcl.client.el.FilterClause;
import com.sap.cloud.security.ams.dcl.client.el.Visitor;
import java.util.Arrays;
import java.util.Collection;

class VisitorToString
extends Visitor {
    private static final int MAX_NESTING_LEVEL = 3;
    private static final int MAX_ARRAY_LENGTH_CR = 3;
    private static final String[] INDENTS = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         ", "          ", "           ", "            ", "             ", "              ", "               ", "                ", "                 ", "                  ", "                   "};
    private static final String MAX_INDENT = INDENTS[INDENTS.length - 1];
    private static final int MAX_INDENT_LEN = MAX_INDENT.length();
    private final StringBuilder sb = new StringBuilder();
    private int indent;
    private int crPos = -1;
    private boolean useCR = true;

    protected static void appendQuoted(StringBuilder sb, char it) {
        sb.append('\'');
        switch (it) {
            case '\u0000': {
                sb.append("\\0");
                break;
            }
            case '\\': {
                sb.append("\\\\");
                break;
            }
            case '\n': {
                sb.append("\\n");
                break;
            }
            case '\r': {
                sb.append("\\r");
                break;
            }
            default: {
                sb.append(it);
            }
        }
        sb.append('\'');
    }

    protected static void appendQuoted(StringBuilder sb, String data) {
        if (data == null) {
            sb.append("null");
            return;
        }
        if (data.isEmpty()) {
            sb.append("\"\"");
            return;
        }
        sb.append('\"');
        VisitorToString.addQuotedString(sb, data);
        sb.append('\"');
    }

    private static void addQuotedString(StringBuilder sb, String data) {
        int start = 0;
        int pos = 0;
        int len = data.length();
        do {
            char ch;
            if ((ch = data.charAt(pos)) == '\n') {
                ch = 'n';
            } else if (ch == '\r') {
                ch = 'r';
            } else if (ch != '\\' && ch != '\"') {
                ++pos;
                continue;
            }
            sb.append(data, start, pos);
            sb.append('\\');
            sb.append(ch);
            start = ++pos;
        } while (pos != len);
        if (start != len) {
            sb.append(data, start, len);
        }
    }

    static void addSpaces(StringBuilder sb, int count) {
        if (count <= 0) {
            return;
        }
        while (count >= MAX_INDENT_LEN) {
            sb.append(MAX_INDENT);
            count -= MAX_INDENT_LEN;
        }
        sb.append(INDENTS[count]);
    }

    private VisitorToString() {
    }

    protected void indent() {
        this.indent(this.indent);
    }

    protected void indent(int i) {
        VisitorToString.addSpaces(this.sb, i * 2);
    }

    protected void open() {
        ++this.indent;
    }

    protected void open(String section) {
        this.append(section);
        ++this.indent;
    }

    private int close() {
        return --this.indent;
    }

    protected void append(Object section) {
        this.indent();
        this.sb.append(section);
    }

    private void indentOpt() {
        if (this.useCR) {
            this.indent();
        }
    }

    private void crOpt() {
        if (this.useCR) {
            this.sb.append('\n');
            this.crPos = this.sb.length();
        }
    }

    protected void appendAQN(Collection<? extends AbstractQualifiedName<?>> coll) {
        this.append(Character.valueOf('['));
        boolean first = true;
        for (AbstractQualifiedName<?> e : coll) {
            if (first) {
                first = false;
            } else {
                this.sb.append(", ");
            }
            this.sb.append(e.toEncodedString());
        }
        this.sb.append(']');
    }

    protected void append(Collection<?> coll, boolean useAccept) {
        boolean first = true;
        for (Object e : coll) {
            if (first) {
                first = false;
            } else {
                this.sb.append(", ");
            }
            if (useAccept) {
                this.accept(e);
                continue;
            }
            this.sb.append(e);
        }
    }

    protected boolean isNested(Object e, int count) {
        if (e instanceof Collection) {
            Collection col = (Collection)e;
            if (col.size() > 3 || --count <= 0) {
                return true;
            }
            for (Object obj : col) {
                if (!this.isNested(obj, count)) continue;
                return true;
            }
        } else if (e instanceof Object[]) {
            Object[] array = (Object[])e;
            if (array.length > 3 || --count <= 0) {
                return true;
            }
            for (Object obj : array) {
                if (!this.isNested(obj, count)) continue;
                return true;
            }
        } else if (e instanceof Call) {
            Call call = (Call)e;
            switch (call.getArgumentCount()) {
                case 0: {
                    return false;
                }
                case 1: {
                    return --count <= 0 || this.isNested(call.getArgument(0), count);
                }
            }
            return true;
        }
        return false;
    }

    private void doVisitCollection(String name, boolean isArray, Collection<?> arguments) {
        if (this.useCR) {
            this.append(name);
        } else {
            this.sb.append(name);
        }
        if (arguments.isEmpty()) {
            this.sb.append(isArray ? "[]" : "()");
        } else {
            boolean prevCR = this.useCR;
            this.useCR = this.isNested(arguments, 4);
            if (this.useCR) {
                this.sb.append(isArray ? "[\n" : "(\n");
                this.open();
                this.accept(arguments);
                this.close();
                this.append(isArray ? "]" : Character.valueOf(')'));
            } else {
                this.sb.append(isArray ? "[" : Character.valueOf('('));
                this.open();
                this.append(arguments, true);
                this.close();
                this.sb.append(isArray ? "]" : Character.valueOf(')'));
            }
            this.useCR = prevCR;
        }
        this.crOpt();
    }

    @Override
    public void visit(Object it) {
        if (it instanceof Collection) {
            this.doVisitCollection("", true, (Collection)it);
            return;
        }
        if (it instanceof Object[]) {
            this.doVisitCollection("", true, Arrays.asList((Object[])it));
            return;
        }
        this.indentOpt();
        if (it instanceof String) {
            VisitorToString.appendQuoted(this.sb, (String)it);
        } else if (it instanceof Character) {
            VisitorToString.appendQuoted(this.sb, ((Character)it).charValue());
        } else {
            this.sb.append(String.valueOf(it));
        }
        this.crOpt();
    }

    @Override
    public void visit(Call it) {
        this.doVisitCollection(it.getName(), false, it.getArguments());
    }

    @Override
    public void visit(AttributeName it) {
        this.indentOpt();
        this.sb.append(it.toEncodedString());
        this.crOpt();
    }

    @Override
    public void visit(FilterClause partial) {
        this.open("FilterClause:\n");
        this.open("Unknowns:\n");
        this.appendAQN(partial.getUnknowns());
        this.sb.append('\n');
        this.close();
        this.open("Ignores:\n");
        this.appendAQN(partial.getIgnores());
        this.sb.append('\n');
        this.close();
        this.open("Condition:\n");
        this.accept(partial.getCondition());
        this.close();
        this.close();
    }

    public String toString() {
        if (this.crPos == this.sb.length()) {
            this.sb.setLength(this.crPos - 1);
        }
        return this.sb.toString();
    }

    public static String toString(Object expression) {
        VisitorToString visitor = new VisitorToString();
        Visitor.accept(visitor, expression);
        return visitor.toString();
    }
}

