/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.factory;

import com.sap.cloud.security.ams.dcl.client.commons.Parameter;
import com.sap.cloud.security.ams.dcl.client.factory.DclFactoryCreationException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DclFactoryBase<C> {
    public static final String DEFAULT_KIND = "default";

    protected abstract C tryCreate(String var1, Object[] var2) throws Exception;

    protected abstract int getPriority();

    public static <F extends DclFactoryBase<C>, C> C create(Class<F> factoryType, String kind) {
        return DclFactoryBase.create(factoryType, kind, null);
    }

    public static <F extends DclFactoryBase<C>, C> C create(Class<F> factoryType, String kind, Object[] arguments) {
        return new Loader(factoryType).create(kind, arguments);
    }

    public static final class Loader<F extends DclFactoryBase<C>, C> {
        private final Class<F> factoryType;
        private final List<F> factories;
        private static final Object[] NULL_OBJECT_ARRAY = new Object[0];

        public Loader(Class<F> factoryType) {
            this.factoryType = Objects.requireNonNull(factoryType, "factoryType must not be null");
            this.factories = StreamSupport.stream(ServiceLoader.load(factoryType).spliterator(), false).sorted(Loader::order).collect(Collectors.toList());
            this.checkConsistency();
        }

        private void checkConsistency() {
            Logger logger = null;
            if (this.factories.size() >= 2) {
                Iterator<F> it = this.factories.iterator();
                DclFactoryBase previous = (DclFactoryBase)it.next();
                while (it.hasNext()) {
                    DclFactoryBase current = (DclFactoryBase)it.next();
                    if (previous.getPriority() != current.getPriority()) continue;
                    if (logger == null) {
                        logger = LoggerFactory.getLogger(this.factoryType);
                    }
                    logger.info("Factoryies {} and {} registered with the same priority. {} will be used first in context {}.", previous.getClass().getName(), current.getClass().getName(), previous.getClass().getName(), this.factoryType.getSimpleName());
                }
            }
        }

        public C create(String kind, Object[] arguments) {
            if (kind == null || kind.isEmpty()) {
                throw new IllegalArgumentException("kind must not be null or empty (" + kind + ")");
            }
            if (arguments == null || arguments.length == 0) {
                arguments = NULL_OBJECT_ARRAY;
            } else {
                Loader.validateArguments(arguments);
            }
            for (DclFactoryBase factory : this.factories) {
                try {
                    Object result = factory.tryCreate(kind, arguments);
                    if (result == null) continue;
                    return result;
                }
                catch (Exception e) {
                    throw new DclFactoryCreationException("Failed to create " + this.factoryType.getName() + " with exception.", e);
                }
            }
            throw new IllegalStateException("No " + this.factoryType.getName() + " implementation could provide an instance for kind: " + kind);
        }

        private static void validateArguments(Object[] arguments) {
            if (arguments.length % 2 == 1) {
                throw new IllegalArgumentException("Odd number of arguments (" + arguments.length + ")");
            }
            for (int idx = 0; idx < arguments.length; idx += 2) {
                Object key = arguments[idx];
                if (!(key instanceof String) && !(key instanceof Parameter)) {
                    throw new IllegalArgumentException("Argument [" + idx + "] not of type String or Parameter. Content=" + key);
                }
                Object val = arguments[idx + 1];
                if (val == null || !val.getClass().isArray() || !val.getClass().getComponentType().isPrimitive()) continue;
                throw new IllegalArgumentException("Argument [" + idx + "] is a java " + val.getClass().getComponentType().getName() + "[]. Arrays of primitive types are not supported.");
            }
        }

        private static <F extends DclFactoryBase<?>> int order(F o1, F o2) {
            int order = Integer.compare(o1.getPriority(), o2.getPriority());
            return order != 0 ? order : o1.getClass().getName().compareTo(o2.getClass().getName());
        }
    }
}

