/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.language;

import com.sap.cloud.security.ams.dcl.client.language.DataControlLanguageScannerImpl;
import com.sap.cloud.security.ams.dcl.client.language.TokenFormat;
import java.util.List;
import java.util.Objects;

public interface DataControlLanguageScanner {
    public void input(String var1);

    public boolean isOk();

    public String getMessage();

    public void throwOnErrror() throws IllegalArgumentException;

    public char getNextChar();

    public char getCurrentChar();

    public int getCurrentPosition();

    public int getRemainingCount();

    public String getRemainingInput();

    public boolean hasMore();

    public void skip();

    public void skip(int var1);

    public void skipWhitespace();

    public boolean consume(char var1);

    public boolean consume(String var1);

    public String scanIdentifier();

    public String scanIdentifierOrAny();

    public String scanString();

    public List<String> scanQualifiedName(boolean var1);

    public Object scanJsonValue();

    public String scanJsonString();

    public Number scanJsonNumber();

    public boolean isJsonQuotedIdentifier();

    public void setJsonQuotedIdentifier(boolean var1);

    public static DataControlLanguageScanner create() {
        return new DataControlLanguageScannerImpl(TokenFormat.DCL_IDENTIFIER);
    }

    public static DataControlLanguageScanner create(TokenFormat tokenFormat) {
        return new DataControlLanguageScannerImpl(Objects.requireNonNull(tokenFormat, "tokenFormat must not be null."));
    }
}

