/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.language;

import com.sap.cloud.security.ams.dcl.client.language.DataControlLanguageNames;
import com.sap.cloud.security.ams.dcl.client.language.DataControlLanguageScanner;
import com.sap.cloud.security.ams.dcl.client.language.TokenFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

final class DataControlLanguageScannerImpl
implements DataControlLanguageScanner {
    private final List<String> segments = new ArrayList<String>();
    protected String input = "";
    protected int length = 0;
    protected int pos = 0;
    protected char[] buffer = null;
    protected String message = null;
    private TokenFormat tokenFormat;
    private boolean jsonQuotedIdentifier = false;
    private static final boolean BIG_DECIMAL = false;
    protected static final String MSG_OK = null;
    protected static final String MSG_INPUT_MISSING = "No input";
    protected static final String MSG_INPUT_MALFORMED = "Input data cannot be parsed";
    private static final long NO_LONG_VALUE = 1L;

    public DataControlLanguageScannerImpl(TokenFormat tokenFormat) {
        this.tokenFormat = tokenFormat;
    }

    protected static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    protected static boolean isJsonSeparator(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': 
            case ',': 
            case ':': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    protected static boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n';
    }

    protected static int decodeHex(char ch) {
        if (ch >= '0') {
            if (ch <= '9') {
                return ch - 48;
            }
            if ((ch = (char)(ch | 0x20)) >= 'a' && ch <= 'f') {
                return ch - 97 + 10;
            }
        }
        return -1;
    }

    private void resizeBuffer(int needed) {
        if (this.buffer == null) {
            this.buffer = new char[Math.max(128, needed + 64)];
        } else if (this.buffer.length <= needed) {
            this.buffer = Arrays.copyOf(this.buffer, Math.max(needed + 64, this.buffer.length * 2));
        }
    }

    @Override
    public void input(String input) {
        this.input = Objects.requireNonNull(input, "input must not be null");
        this.length = input.length();
        this.pos = 0;
        this.message = MSG_OK;
    }

    @Override
    public final boolean isOk() {
        return this.message == MSG_OK;
    }

    @Override
    public final String getMessage() {
        return this.message;
    }

    @Override
    public void throwOnErrror() throws IllegalArgumentException {
        if (this.message != null) {
            throw new IllegalArgumentException(this.message);
        }
    }

    @Override
    public final char getCurrentChar() {
        return this.input.charAt(this.pos);
    }

    @Override
    public final int getCurrentPosition() {
        return this.pos;
    }

    @Override
    public final int getRemainingCount() {
        return Math.max(0, this.length - this.pos);
    }

    @Override
    public final String getRemainingInput() {
        return this.hasMore() ? this.input.substring(this.pos) : "";
    }

    @Override
    public final boolean hasMore() {
        return this.pos < this.length;
    }

    @Override
    public final char getNextChar() {
        char res = this.input.charAt(this.pos);
        ++this.pos;
        return res;
    }

    @Override
    public final void skip() {
        this.skip(1);
    }

    @Override
    public final void skip(int count) {
        if (count > 0) {
            this.pos = Math.min(this.pos + count, this.length);
        }
    }

    @Override
    public final boolean consume(char c) {
        if (this.hasMore() && this.getCurrentChar() == c) {
            ++this.pos;
            return true;
        }
        return false;
    }

    @Override
    public final boolean consume(String s) {
        if (s.isEmpty()) {
            return true;
        }
        if (s.length() + this.pos <= this.length) {
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) == this.input.charAt(this.pos + i)) continue;
                return false;
            }
            this.pos += s.length();
            return true;
        }
        return false;
    }

    private String scanIdOrNameFragment() {
        if (!this.hasMore()) {
            this.message = MSG_INPUT_MISSING;
            return null;
        }
        this.message = MSG_OK;
        char ch = this.getCurrentChar();
        if (ch == '\"') {
            String str = this.scanString(this.jsonQuotedIdentifier);
            if (str != null && str.isEmpty()) {
                this.message = "Empty \"\" not allowed as ID.";
                return null;
            }
            return str;
        }
        int p = this.tokenFormat.consume(this.input, this.pos, this.length);
        if (p != this.pos) {
            int start = this.pos;
            this.pos = p;
            return this.input.substring(start, this.pos);
        }
        this.message = "Not supported character '" + ch + "' in ID.";
        return null;
    }

    @Override
    public void skipWhitespace() {
        while (this.pos < this.length && DataControlLanguageScannerImpl.isWhitespace(this.getCurrentChar())) {
            ++this.pos;
        }
    }

    @Override
    public String scanIdentifierOrAny() {
        this.message = MSG_OK;
        if (this.consume('*')) {
            return "*";
        }
        return this.scanIdentifier();
    }

    @Override
    public String scanString() {
        return this.scanString(false);
    }

    @Override
    public String scanJsonString() {
        return this.scanString(true);
    }

    private String scanString(boolean withJson) {
        if (!this.consume('\"')) {
            this.message = MSG_INPUT_MISSING;
            return null;
        }
        int bix = 0;
        int p = this.pos;
        int l = this.length;
        String inp = this.input;
        int start = p;
        boolean quote = false;
        while (p < l) {
            char ch;
            block23: {
                int pEscapeStart;
                block25: {
                    block24: {
                        if ((ch = inp.charAt(p++)) == '\"') {
                            this.pos = p;
                            this.message = MSG_OK;
                            if (bix == 0) {
                                return "";
                            }
                            if (quote) {
                                return new String(this.buffer, 0, bix);
                            }
                            return inp.substring(start, start + bix);
                        }
                        if (ch != '\\') break block23;
                        if (p == l) {
                            this.pos = p;
                            this.message = "String terminated in escape sequence";
                            return null;
                        }
                        ch = inp.charAt(p);
                        pEscapeStart = p - 1;
                        if (!withJson) break block24;
                        switch (ch) {
                            case '\"': {
                                break block25;
                            }
                            case '\\': {
                                break block25;
                            }
                            case 'b': {
                                ch = '\b';
                                break block25;
                            }
                            case 't': {
                                ch = '\t';
                                break block25;
                            }
                            case 'f': {
                                ch = '\f';
                                break block25;
                            }
                            case 'n': {
                                ch = '\n';
                                break block25;
                            }
                            case 'r': {
                                ch = '\r';
                                break block25;
                            }
                            case '/': {
                                ch = '/';
                                break block25;
                            }
                            case 'u': {
                                if (l - p <= 4) {
                                    this.pos = p;
                                    this.message = "String terminated in unicode escape sequence";
                                    return null;
                                }
                                int codePoint = 0;
                                for (int i = 1; i <= 4; ++i) {
                                    int val = DataControlLanguageScannerImpl.decodeHex(inp.charAt(p + i));
                                    if (val == -1) {
                                        this.pos = p;
                                        this.message = "Unicode escape sequece invalid. Non hex character encounterd.";
                                        return null;
                                    }
                                    codePoint = (codePoint << 4) + val;
                                }
                                p += 4;
                                ch = (char)codePoint;
                                break block25;
                            }
                            default: {
                                this.pos = p;
                                this.message = "Invalid escape sequence character '" + ch + "'";
                                return null;
                            }
                        }
                    }
                    if (ch != '\\' && ch != '\"') {
                        this.pos = p;
                        this.message = "Invalid escape sequence character '" + ch + "'";
                        return null;
                    }
                }
                if (!quote) {
                    quote = true;
                    this.resizeBuffer(bix);
                    inp.getChars(start, pEscapeStart, this.buffer, 0);
                }
                ++p;
            }
            if (quote) {
                this.resizeBuffer(bix);
                this.buffer[bix] = ch;
            }
            ++bix;
        }
        this.pos = p;
        this.message = "String not terminated by \"";
        return null;
    }

    @Override
    public String scanIdentifier() {
        return this.scanIdOrNameFragment();
    }

    private void scanNameInternal(boolean addScope) {
        this.segments.clear();
        if (!this.hasMore()) {
            this.message = MSG_INPUT_MISSING;
        } else {
            this.message = MSG_OK;
            do {
                String fragment;
                char ch = this.getCurrentChar();
                boolean isFirst = this.segments.isEmpty();
                if (!isFirst) {
                    if (ch != '.') break;
                    ++this.pos;
                    if (!this.hasMore()) {
                        this.message = "No characters after '.'";
                        break;
                    }
                }
                if ((fragment = this.scanIdOrNameFragment()) == null) break;
                if (isFirst && addScope && !DataControlLanguageNames.ALL_SECTIONS.contains(fragment)) {
                    if (fragment.startsWith("$")) {
                        this.segments.add("$env");
                    } else {
                        this.segments.add("$app");
                    }
                }
                this.segments.add(fragment);
            } while (this.hasMore());
        }
    }

    @Override
    public List<String> scanQualifiedName(boolean addScope) {
        this.scanNameInternal(addScope);
        return this.isOk() ? this.segments : null;
    }

    @Override
    public Object scanJsonValue() {
        ArrayList<Object> res = null;
        this.skipWhitespace();
        this.message = MSG_OK;
        int start = this.pos;
        if (this.hasMore()) {
            char ch = this.getCurrentChar();
            if (ch == '\"') {
                res = this.scanString(true);
            } else if (ch == 't' && this.consume("true")) {
                if (!this.hasMore() || DataControlLanguageScannerImpl.isJsonSeparator(this.getCurrentChar())) {
                    res = Boolean.TRUE;
                } else {
                    this.pos = start;
                    this.message = MSG_INPUT_MALFORMED;
                }
            } else if (ch == 'f' && this.consume("false")) {
                if (!this.hasMore() || DataControlLanguageScannerImpl.isJsonSeparator(this.getCurrentChar())) {
                    res = Boolean.FALSE;
                } else {
                    this.pos = start;
                    this.message = MSG_INPUT_MALFORMED;
                }
            } else if (ch == 'n' && this.consume("null")) {
                if (!this.hasMore() || DataControlLanguageScannerImpl.isJsonSeparator(this.getCurrentChar())) {
                    res = null;
                } else {
                    this.pos = start;
                    this.message = MSG_INPUT_MALFORMED;
                }
            } else if (ch == '-' || DataControlLanguageScannerImpl.isDigit(ch)) {
                res = this.scanJsonNumber();
            } else if (ch == '[') {
                ArrayList<Object> resList;
                ++this.pos;
                res = resList = new ArrayList<Object>();
                this.skipWhitespace();
                if (!this.consume(']')) {
                    while (true) {
                        resList.add(this.scanJsonValue());
                        if (this.message != null) {
                            this.pos = start;
                            res = null;
                            break;
                        }
                        this.skipWhitespace();
                        if (this.consume(']')) break;
                        if (!this.consume(',')) {
                            this.pos = start;
                            this.message = MSG_INPUT_MALFORMED;
                            res = null;
                            break;
                        }
                        this.skipWhitespace();
                    }
                }
            } else {
                this.message = MSG_INPUT_MALFORMED;
            }
        } else {
            this.message = MSG_INPUT_MISSING;
            res = null;
        }
        return res;
    }

    @Override
    public Number scanJsonNumber() {
        int start;
        String inp;
        int p;
        block22: {
            long lValue;
            block23: {
                if (!this.hasMore()) {
                    this.message = MSG_INPUT_MISSING;
                    return null;
                }
                p = this.pos;
                int l = this.length;
                inp = this.input;
                start = p++;
                boolean positive = true;
                char ch = this.getCurrentChar();
                if (ch == '-') {
                    positive = false;
                    if (p == l) {
                        this.message = MSG_INPUT_MALFORMED;
                        return null;
                    }
                }
                if ((ch = inp.charAt(p)) == '0') {
                    ++p;
                    lValue = 0L;
                } else if (ch >= '1' && ch <= '9') {
                    lValue = -(ch - 48);
                    ++p;
                    while (p < l && DataControlLanguageScannerImpl.isDigit(ch = inp.charAt(p))) {
                        ++p;
                        if (lValue >= 0L) continue;
                        lValue = 10L * lValue - (long)(ch - 48);
                    }
                    if (lValue >= 0L) {
                        lValue = 1L;
                    }
                } else {
                    this.message = MSG_INPUT_MALFORMED;
                    return null;
                }
                if (p < l) {
                    ch = inp.charAt(p);
                    if (ch == '.') {
                        lValue = 1L;
                        if (++p == l || !DataControlLanguageScannerImpl.isDigit(inp.charAt(p))) {
                            this.message = MSG_INPUT_MALFORMED;
                            return null;
                        }
                        ++p;
                        while (p < l && DataControlLanguageScannerImpl.isDigit(inp.charAt(p))) {
                            ++p;
                        }
                    }
                    if (p < l && ((ch = inp.charAt(p)) == 'e' || ch == 'E')) {
                        lValue = 1L;
                        if (++p < l && ((ch = inp.charAt(p)) == '+' || ch == '-')) {
                            ++p;
                        }
                        if (p == l || !DataControlLanguageScannerImpl.isDigit(inp.charAt(p))) {
                            this.message = MSG_INPUT_MALFORMED;
                            return null;
                        }
                        ++p;
                        while (p < l && DataControlLanguageScannerImpl.isDigit(inp.charAt(p))) {
                            ++p;
                        }
                    }
                }
                this.message = MSG_OK;
                this.pos = p;
                if (lValue >= 1L) break block22;
                if (!positive) break block23;
                if (lValue == Long.MIN_VALUE) break block22;
                lValue = -lValue;
            }
            if (lValue > Integer.MIN_VALUE && lValue < Integer.MAX_VALUE) {
                return (int)lValue;
            }
            return lValue;
        }
        String number = inp.substring(start, p);
        double res = Double.parseDouble(number);
        return res;
    }

    @Override
    public boolean isJsonQuotedIdentifier() {
        return this.jsonQuotedIdentifier;
    }

    @Override
    public void setJsonQuotedIdentifier(boolean allowJsonEncoding) {
        this.jsonQuotedIdentifier = allowJsonEncoding;
    }
}

