/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.language;

import com.sap.cloud.security.ams.dcl.client.language.TokenFormat;
import java.util.List;
import java.util.regex.Pattern;

public class DataControlLanguageTools {
    public static final char SEPARATOR_CHAR = '.';
    public static final Pattern SEPARATOR_PATTERN = Pattern.compile("\\.");
    public static final char BSLASH_CHAR = '\\';
    public static final char DQUOTE_CHAR = '\"';

    private DataControlLanguageTools() {
    }

    public static final void requireNonNullOrEmpty(String data, String errNull, String errEmpty) {
        if (data == null) {
            throw new NullPointerException(errNull);
        }
        if (data.isEmpty()) {
            throw new IllegalArgumentException(errEmpty);
        }
    }

    public static void appendQuotedString(StringBuilder sb, String value) {
        DataControlLanguageTools.appendQuotedString(sb, value, false);
    }

    public static void appendQuotedString(StringBuilder sb, String value, boolean optionalQuotes) {
        if (value == null || value.isEmpty()) {
            sb.append("\"\"");
            return;
        }
        boolean added = false;
        if (!optionalQuotes) {
            sb.append('\"');
            added = true;
        }
        int start = 0;
        int pos = 0;
        int len = value.length();
        do {
            char ch;
            if ((ch = value.charAt(pos)) != '\\' && ch != '\"') {
                ++pos;
                continue;
            }
            if (!added) {
                sb.append('\"');
                added = true;
            }
            sb.append(value, start, pos);
            start = ++pos;
            sb.append('\\');
            sb.append(ch);
        } while (pos != len);
        if (start != len) {
            sb.append(value, start, len);
        }
        if (added) {
            sb.append('\"');
        }
    }

    public static String createQualifiedPolicy(String dclPackage, String policy) {
        DataControlLanguageTools.requireNonNullOrEmpty(policy, "Policy must not be null.", "Policy must not be an empty string.");
        DataControlLanguageTools.requireNonNullOrEmpty(dclPackage, "DCL package must not be null.", "DCL package must not be an empty string.");
        if (dclPackage.charAt(dclPackage.length() - 1) == '.') {
            throw new IllegalArgumentException("DCL package must not end with '.'");
        }
        if (!TokenFormat.ALPHA_NUMERIC_EXT.isQualifiedToken(dclPackage)) {
            throw new IllegalArgumentException("The DCL package is not valid: " + dclPackage);
        }
        StringBuilder sb = new StringBuilder(dclPackage.length() + 10 + policy.length());
        DataControlLanguageTools.appendQuotedString(sb, dclPackage, true);
        sb.append('.');
        DataControlLanguageTools.appendQuotedString(sb, policy, policy.indexOf(46) == -1);
        return sb.toString();
    }

    public static String normalizeQualifiedPolicy(String operation) {
        DataControlLanguageTools.requireNonNullOrEmpty(operation, "Qualified policy must not be null.", "Qualified policy name must not be an empty string.");
        int length = operation.length();
        int pos = DataControlLanguageTools.indexOfQualifiedSeparator(operation);
        if (pos <= -2) {
            if (TokenFormat.ALPHA_NUMERIC_EXT.isQualifiedToken(operation, 0, (pos = -pos) - 1)) {
                int escape = DataControlLanguageTools.checkEscapedString(operation, pos, length);
                if (escape == 0) {
                    return operation.substring(0, pos) + operation.substring(pos + 1, length - 1);
                }
                if (escape >= 0) {
                    return operation;
                }
            }
        } else if (pos > 0 && TokenFormat.ALPHA_NUMERIC_EXT.isQualifiedToken(operation, 0, pos) && pos + 1 < length) {
            return operation;
        }
        throw new IllegalArgumentException("Qualified policy format violation of: " + operation);
    }

    static int checkEscapedString(String value, int start, int end) {
        int result = 0;
        if (end - start <= 2 || value.charAt(start) != '\"' || value.charAt(end - 1) != '\"') {
            return -1;
        }
        ++start;
        --end;
        while (start < end) {
            char ch;
            if ((ch = value.charAt(start++)) == '\\') {
                if (start == end) {
                    return -1;
                }
                if ((ch = value.charAt(start++)) != '\\' && ch != '\"') {
                    return -1;
                }
                result = 1;
                continue;
            }
            if (ch == '\"') {
                return -1;
            }
            if (ch != '.') continue;
            result = 1;
        }
        return result;
    }

    private static int indexOfQualifiedSeparator(String operation) {
        int posSep = 0;
        int length = operation.length();
        for (int idx = 0; idx < length; ++idx) {
            char ch = operation.charAt(idx);
            if (ch == '\"') {
                if (idx < 2 || posSep + 1 != idx) {
                    return 0;
                }
                return -idx;
            }
            if (ch != '.') continue;
            if (idx == 0) {
                return 0;
            }
            posSep = idx;
        }
        return posSep;
    }

    public static String encodeQualifiedName(List<String> segments, StringBuilder buffer) {
        int size;
        if (buffer == null) {
            return DataControlLanguageTools.encodeQualifiedName(segments);
        }
        int n = size = segments == null ? 0 : segments.size();
        if (size == 0) {
            return "";
        }
        String s = segments.get(0);
        if (size == 1 && TokenFormat.PLAIN.isToken(s)) {
            return s;
        }
        buffer.setLength(0);
        return DataControlLanguageTools.encodeQualifiedName(segments, size, s, buffer);
    }

    public static String encodeQualifiedName(List<String> segments) {
        int size;
        int n = size = segments == null ? 0 : segments.size();
        if (size == 0) {
            return "";
        }
        String s = segments.get(0);
        if (size == 1 && TokenFormat.PLAIN.isToken(s)) {
            return s;
        }
        StringBuilder buffer = new StringBuilder(64);
        return DataControlLanguageTools.encodeQualifiedName(segments, size, s, buffer);
    }

    public static String encodeQualifiedName(String[] segments, StringBuilder buffer) {
        int size;
        if (buffer == null) {
            return DataControlLanguageTools.encodeQualifiedName(segments);
        }
        int n = size = segments == null ? 0 : segments.length;
        if (size == 0) {
            return "";
        }
        String s = segments[0];
        if (size == 1 && TokenFormat.PLAIN.isToken(s)) {
            return s;
        }
        buffer.setLength(0);
        return DataControlLanguageTools.encodeQualifiedName(segments, size, s, buffer);
    }

    public static String encodeQualifiedName(String[] segments) {
        int size;
        int n = size = segments == null ? 0 : segments.length;
        if (size == 0) {
            return "";
        }
        String s = segments[0];
        if (size == 1 && TokenFormat.PLAIN.isToken(s)) {
            return s;
        }
        return DataControlLanguageTools.encodeQualifiedName(segments, size, s, new StringBuilder(64));
    }

    private static String encodeQualifiedName(String[] segments, int size, String s, StringBuilder buffer) {
        if (size == 1) {
            DataControlLanguageTools.appendQuotedString(buffer, s, false);
        } else {
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    buffer.append('.');
                }
                DataControlLanguageTools.appendOptionallQuoted(buffer, segments[i]);
            }
        }
        return buffer.toString();
    }

    private static String encodeQualifiedName(List<String> segments, int size, String s, StringBuilder buffer) {
        if (size == 1) {
            DataControlLanguageTools.appendQuotedString(buffer, s, false);
        } else {
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    buffer.append('.');
                }
                DataControlLanguageTools.appendOptionallQuoted(buffer, segments.get(i));
            }
        }
        return buffer.toString();
    }

    private static void appendOptionallQuoted(StringBuilder sb, String value) {
        if (TokenFormat.PLAIN.isToken(value)) {
            sb.append(value);
        } else {
            DataControlLanguageTools.appendQuotedString(sb, value, false);
        }
    }
}

