/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.language;

import java.io.ByteArrayOutputStream;
import java.util.Base64;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TokenFormat {
    ALPHA_NUMERIC_EXT{

        @Override
        public boolean isStart(char ch) {
            if (ch == '_') {
                return true;
            }
            return (ch = (char)(ch | 0x20)) >= 'a' && ch <= 'z';
        }

        @Override
        public boolean isPart(char ch) {
            if (ch == '_') {
                return true;
            }
            if (ch >= '0') {
                if (ch <= '9') {
                    return true;
                }
                if ((ch = (char)(ch | 0x20)) >= 'a' && ch <= 'z') {
                    return true;
                }
            }
            return false;
        }
    }
    ,
    DCL_IDENTIFIER{

        @Override
        public boolean isStart(char ch) {
            return (ID_MASK_START[ch >>> 3] & 1 << (ch & 7)) != 0;
        }

        @Override
        public boolean isPart(char ch) {
            return (ID_MASK_PART[ch >>> 3] & 1 << (ch & 7)) != 0;
        }
    }
    ,
    PLAIN{

        @Override
        public boolean isStart(char ch) {
            return ch != '.' && ch != '\"';
        }

        @Override
        public boolean isPart(char ch) {
            return ch != '.' && ch != '\"';
        }
    };

    private static final String ID_ENC_START = "P4MLEAAAAP7//4f+//8Hgwo8BCAE//9/////f/aXBs84QNf///vIAL/QAQP80gcA/v///38A/sMAgIcJ////Bwc/AAAIAADDBv4HAAAAwP7KDy8AAMAAnAAA/f///wAAAODJDj8AAgAA/P///wcAAP//P4QD////AYcB/R+JAPDFPz8jAAAB/wMA/P7gn/n///3FIwBAALADAA8I4If5///9bQMAAABeAAAcAOC/+////e0jAAABAAMAAgDgn/n///3tPxMjAAAAsAMAAgDoxz3WGMf/AwAAAYMjAuDf/f///e8jAAAAAwMAAADg3/3///3vIwAAAEADAAYA4N/9wxEnAEA/AAADAAD84P9//P//+y9/hgD+xAINgD+GC5Yl8P6u7A0gHwAA8IMAAYYJ//7///8fAAAAH43EDgcAgAAAPzxiwD/h/wNAAADDAb8gxADn6AI9fz3EAD3DBD1/Pf9/xgA9xwAHgwP//wAAyQIfAP7/ywaf///+//8HyBLHAQD/3wMAP///AwD//wMA/98BAMUAD4MAGIfDAPfFAADEAAXHBT8A////H4UF////Px8AxAMPAAD+hgP//38AxQAflADgxAM/DwDgD4UH+P///wHAAPzDAz8AAADDAA+DBeAA/P///40C3mMAxAAPhgb4//7///8Hi+EBPz/DBz8//6r///8/xScJ31/cH88P/x/cH4YDgAEAEIgD////B4cLhPwvPlC9//PgQwAAxAABRL8/jcQAf8QEf////8/LAx94DADDAb8gxgYAAAD//38AR3+/gwjAAAAA/gMAF/7IAn+A/skBh+DDAT/+yQZ/AAD//wb/B4UB//+/ywP1AD+I5z/4AB+FAv//3///zQAfh8QAAOAGD///AAwAAMQGfwAA////AMmFAPzIB/7//3gPAP8HiAj8u/f//wcAAAHFAg8AP/zEAA+GEvwIAPz//z8A//9/AAAA////H/DEAAeIxAoBAAD3DwAA//9+BMUPYj4FAAAY/wcEAH5+fgB/f5HDAwcCAAAA1ArzBQ8A//9/+MQAD0+/P5/sAD/MAAODCH8A+KD//X9f28wEAwAAAPjrAj8AAMcA/MWEAf8fhQgYAADgAAAAAt/PDx8QAAAA/v//h/7//wcRwP/+www/////f/z8/BxjAAAA";
    private static final String ID_ENC_PART = "P4MLEAD/A/7//4f+//8Hgwo8BCAE//9/////f/aJzQbPOEDX///7yAC/0AH7/NIHAP7///9/AP7DAYD+wwy/tgA/////BwcAAAj/B8MA/sMAw8sH75+f/f+fAADGAOfLAQMAxQ0PAP////vvPgAA////D4cB/R+FA/D//3/LP8///D/+7p/5///9xfOfeYCwz/8PCO6H+f///W3ThzkCXsD/PwDuv/v///3t8787AQDP/wIA7p/5///97fOfOcCwNs//PwIA7Mc91hjH/8PHPYEAwP8AAu7f/f///e/j3z1gA8//AADs3/3///3v8989YEDP/wYA7N/9wxnn332AAM//APw/7P9//P//+y9/hF//AAAMAP7FBIe/f/8DgwuWJfD+ruz/Ox8///ODGAEAAAP/A6DC//7///8f/v/f///+////Hz9AhsgAA8gAP8MBvyDEAOfoAj1/PcQAPcMEPX89/3/GAD3HAOeDA///AADJAh8A/v/LBp////7//wfIEscBAP/fPx8A//8fAP//DwD/3w0AyQkPOP8DAAAAOP8DwwD3xQAAxAAHxwo/AP///x//D/8PwMMCPx8AxAYP////A/8DgwM/////D8YIf////5//A/8Di8gGD/8DAPgPAM0BDwDGAgD/48SKBff///9/AMQAD4YG+P/+////B4PDA38AAPDhATo/P8MHPz//qv///z/FCd9f3B/PD/8f3B+GA4ABABCIF////wcAAP8f4v8BAIT8Lz5Qvf/z4EMAAMQAAUS/P43EAH/EBH/////PywMf+A8AwwG/IMYGAACA//9/AEd/w78IwAAAAP7/ABf+yAJ/hv7JAYfgwwE//skGfwAA//8G/weFAf//v8sD9QA/iOc/+AAfhQL//9///80AH4fEAADgBg////8PAADFBfA/////gMkAA4QA/MgH/v//eA8A/weIAPzEAgAAAcUBDwDHBzsfAP8D////CMQAP8MFDwD///8fxwMBAP8Dg8UJfwD/P/8D//9+DMcNBwAAGP//ZAB+fn4Af3+RxAI3/wPUCvMFDwD//3/4xAAPT78/n+wAP8wAA4MIfwD44P/9f1/bzAQDAAAA+OsCPwAAxwD8xYQQ/x///wAAfwAYAADgAAAAAt/PDx8QAP8D/v//hxX+//8HwP/+www/////f/z8/BxjAAAA";
    private static final byte[] ID_MASK_START;
    private static final byte[] ID_MASK_PART;

    public abstract boolean isStart(char var1);

    public abstract boolean isPart(char var1);

    public boolean isToken(String value) {
        return value != null && this.isToken(value, 0, value.length());
    }

    public boolean isToken(String value, int start) {
        return value != null && this.isToken(value, start, value.length());
    }

    public boolean isToken(String value, int start, int end) {
        return TokenFormat.isValidRange(value, start, end) && this.consume(value, start, end) == end;
    }

    public boolean isQualifiedToken(String value) {
        return value != null && this.isQualifiedToken(value, 0, value.length(), '.');
    }

    public boolean isQualifiedToken(String value, int start) {
        return value != null && this.isQualifiedToken(value, start, value.length(), '.');
    }

    public boolean isQualifiedToken(String value, int start, int end) {
        return this.isQualifiedToken(value, start, end, '.');
    }

    public boolean isQualifiedToken(String value, int start, int end, char separator) {
        return TokenFormat.isValidRange(value, start, end) && this.consumeQualified(value, start, end, separator) == end;
    }

    public int consume(String value, int start, int end) {
        if (start < end && this.isStart(value.charAt(start))) {
            while (++start != end && this.isPart(value.charAt(start))) {
            }
        }
        return start;
    }

    public int consumeQualified(String value, int start, int end) {
        return this.consumeQualified(value, start, end, '.');
    }

    public int consumeQualified(String value, int start, int end, char separator) {
        int lastPos = start;
        char ch = '\u0000';
        while (start < end && this.isStart(value.charAt(start))) {
            while (++start != end && this.isPart(ch = value.charAt(start))) {
            }
            lastPos = start;
            if (start == end || ch != separator) break;
            ++start;
        }
        return lastPos;
    }

    private static boolean isValidRange(String value, int start, int end) {
        return value != null && start >= 0 && start < end && end <= value.length();
    }

    private static byte[] rleDecode(byte[] bytes) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int idx = 0;
        block6: while (idx < bytes.length) {
            int val;
            byte cmd = bytes[idx++];
            int cnt = (cmd & 0x3F) + 1;
            switch (cmd & 0xC0) {
                case 192: {
                    val = -1;
                    break;
                }
                case 128: {
                    val = 0;
                    break;
                }
                case 64: {
                    val = bytes[idx++];
                    break;
                }
                case 0: {
                    bos.write(bytes, idx, cnt);
                    idx += cnt;
                    continue block6;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            for (int i = 0; i < cnt; ++i) {
                bos.write(val);
            }
        }
        return bos.toByteArray();
    }

    static {
        ID_MASK_START = TokenFormat.rleDecode(TokenFormat.rleDecode(Base64.getDecoder().decode(ID_ENC_START)));
        ID_MASK_PART = TokenFormat.rleDecode(TokenFormat.rleDecode(Base64.getDecoder().decode(ID_ENC_PART)));
    }
}

