/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.pdp;

import com.sap.cloud.security.ams.dcl.client.el.AttributeName;
import com.sap.cloud.security.ams.dcl.client.el.QualifiedNamesBuilder;
import com.sap.cloud.security.ams.dcl.client.language.DataControlLanguageTools;
import com.sap.cloud.security.ams.dcl.client.pdp.Attributes;
import com.sap.cloud.security.ams.dcl.client.pdp.AttributesTools;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;

final class AttributesImpl
implements Attributes {
    private static final String NULL_NAME_NOT_ALLOWED = "null name not allowed";
    private transient Set<AttributeName> ignores;
    private transient Set<AttributeName> unknowns;
    private final transient Map<String, Object> map;
    private final transient StructureImpl curser;
    private QualifiedNamesBuilder nameBuilder;
    private transient Map<String, Object> dcl;

    public AttributesImpl() {
        this(AttributesTools.createMap());
    }

    public AttributesImpl(Map<String, Object> attributes) {
        this(attributes, false);
    }

    public AttributesImpl(Map<String, Object> attributes, boolean copyMapDeep) {
        this(copyMapDeep ? AttributesTools.deepCopy(attributes) : attributes, null, null);
    }

    private AttributesImpl(Map<String, Object> attributes, Set<AttributeName> ignores, Set<AttributeName> unknowns) {
        this.map = Objects.requireNonNull(attributes, "Map must not be null.");
        this.ignores = ignores;
        this.unknowns = unknowns;
        this.curser = new StructureImpl(attributes);
    }

    public AttributesImpl(AttributesImpl other) {
        this(AttributesTools.deepCopy(other.getBackingMap()), AttributesTools.copyNN(other.ignores), AttributesTools.copyNN(other.unknowns));
    }

    private Map<String, Object> dcl() {
        if (this.dcl == null) {
            this.dcl = AttributesTools.scope(this.map, "$dcl", null);
        }
        return this.dcl;
    }

    private QualifiedNamesBuilder qualifiedNamesBuilder() {
        if (this.nameBuilder == null) {
            this.nameBuilder = QualifiedNamesBuilder.create();
        }
        return this.nameBuilder;
    }

    @Override
    public Attributes setAction(String action) {
        this.dcl().put("action", AttributesTools.checkValue(action));
        return this;
    }

    @Override
    public Attributes setResource(String resource) {
        this.dcl().put("resource", AttributesTools.checkValue(resource));
        return this;
    }

    @Override
    public Attributes setTenant(String tenant) {
        this.dcl().put("tenant", AttributesTools.checkValue(tenant));
        return this;
    }

    @Override
    public Attributes setPrincipalToPolicies(String ... keys) {
        Map<String, Object> dcl = this.dcl();
        if (keys == null) {
            dcl.remove("principal2policies");
        } else {
            AttributesTools.checkKeys(keys);
            ArrayList content = new ArrayList();
            Collections.addAll(content, keys);
            dcl.put("principal2policies", content);
        }
        dcl.remove("policies");
        return this;
    }

    @Override
    public Attributes setPrincipalToPolicies(List<String> keys) {
        Map<String, Object> dcl = this.dcl();
        if (keys == null) {
            dcl.remove("principal2policies");
        } else {
            AttributesTools.checkKeys(keys);
            ArrayList<String> content = new ArrayList<String>(keys);
            dcl.put("principal2policies", content);
        }
        dcl.remove("policies");
        return this;
    }

    @Override
    public Attributes setPolicies(Collection<String> policies) {
        this.setDclPolicies("policies", policies).remove("principal2policies");
        return this;
    }

    @Override
    public Attributes setPolicies(String ... policies) {
        this.setDclPolicies("policies", policies).remove("principal2policies");
        return this;
    }

    @Override
    public Attributes addPolicy(String qualifiedPolicy) {
        qualifiedPolicy = DataControlLanguageTools.normalizeQualifiedPolicy(qualifiedPolicy);
        Map<String, Object> dcl = this.dcl();
        HashSet<String> content = (HashSet<String>)dcl.get("policies");
        if (content == null) {
            content = new HashSet<String>();
            dcl.put("policies", content);
        }
        content.add(qualifiedPolicy);
        dcl.remove("principal2policies");
        return this;
    }

    @Override
    public Attributes setScopeFilterPolicies(Collection<String> policies) {
        this.setDclPolicies("scopeFilter", policies);
        return this;
    }

    @Override
    public Attributes setScopeFilterPolicies(String ... policies) {
        this.setDclPolicies("scopeFilter", policies);
        return this;
    }

    private Map<String, Object> setDclPolicies(String key, Collection<String> policies) {
        Map<String, Object> dcl = this.dcl();
        if (policies == null) {
            dcl.remove(key);
        } else {
            Set content = AttributesTools.createSet();
            for (String policy : policies) {
                content.add(DataControlLanguageTools.normalizeQualifiedPolicy(policy));
            }
            dcl.put(key, content);
        }
        return dcl;
    }

    private Map<String, Object> setDclPolicies(String key, String[] policies) {
        Map<String, Object> dcl = this.dcl();
        if (policies == null) {
            dcl.remove(key);
        } else {
            Set content = AttributesTools.createSet();
            for (String policy : policies) {
                content.add(DataControlLanguageTools.normalizeQualifiedPolicy(policy));
            }
            dcl.put(key, content);
        }
        return dcl;
    }

    @Override
    public Attributes.Structure app() {
        return this.curser.reset().structure("$app");
    }

    @Override
    public Attributes.Structure env() {
        return this.curser.reset().structure("$env");
    }

    @Override
    public Attributes setValue(AttributeName path, Object value) {
        if (value instanceof Attributes.SpecialValue) {
            this.addSpecialValue(path, (Attributes.SpecialValue)((Object)value));
        } else {
            AttributesTools.doSet(this.map, value, path);
        }
        return this;
    }

    @Override
    public Object getValue(AttributeName path) {
        Objects.nonNull(path);
        if (path.isEmpty()) {
            return this.map;
        }
        if (AttributesTools.startsWith(path, this.ignores)) {
            return Attributes.SpecialValue.IGNORE;
        }
        if (AttributesTools.startsWith(path, this.unknowns)) {
            return Attributes.SpecialValue.UNKNOWN;
        }
        return AttributesTools.doGet(this.map, path);
    }

    @Override
    public Attributes copy() {
        return new AttributesImpl(this);
    }

    public String toString() {
        return "Attributes [map=" + this.map + ", ignores=" + this.getIgnores() + ", unknowns=" + this.getUnknowns() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ignores == null ? 0 : this.ignores.hashCode());
        result = 31 * result + (this.unknowns == null ? 0 : this.unknowns.hashCode());
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributesImpl other = (AttributesImpl)obj;
        if (this.ignores == null ? other.ignores != null : !this.ignores.equals(other.ignores)) {
            return false;
        }
        if (this.unknowns == null ? other.unknowns != null : !this.unknowns.equals(other.unknowns)) {
            return false;
        }
        return this.map.equals(other.map);
    }

    void addSpecialValue(AttributeName name, Attributes.SpecialValue specialValue) {
        Objects.requireNonNull(name, NULL_NAME_NOT_ALLOWED);
        if (specialValue == Attributes.SpecialValue.IGNORE) {
            AttributesTools.checkIgnoreName(name);
            this.grantIgnores(false).add(name);
        } else if (specialValue == Attributes.SpecialValue.UNKNOWN) {
            this.grantUnknowns(false).add(name);
        } else {
            throw new IllegalArgumentException("Cannot set SpecialValue '" + specialValue + "'");
        }
    }

    @Override
    public Attributes setUnknowns(Collection<AttributeName> unknowns) {
        if (unknowns == null || unknowns.isEmpty()) {
            return this.setUnknowns();
        }
        for (AttributeName name : unknowns) {
            Objects.requireNonNull(name, NULL_NAME_NOT_ALLOWED);
        }
        this.grantUnknowns(true).addAll(unknowns);
        return this;
    }

    @Override
    public Attributes setUnknowns(AttributeName ... unknowns) {
        if (unknowns == null || unknowns.length == 0) {
            return this.setUnknowns();
        }
        for (AttributeName name : unknowns) {
            Objects.requireNonNull(name, NULL_NAME_NOT_ALLOWED);
        }
        Collections.addAll(this.grantUnknowns(true), unknowns);
        return this;
    }

    @Override
    public Attributes setUnknowns(String ... unknowns) {
        if (unknowns == null || unknowns.length == 0) {
            return this.setUnknowns();
        }
        Set res = AttributesTools.createSet();
        QualifiedNamesBuilder nb = this.qualifiedNamesBuilder();
        for (String unknown : unknowns) {
            AttributeName name = nb.parseAttributeName(unknown);
            res.add(name);
        }
        this.unknowns = res;
        return this;
    }

    @Override
    public Attributes setUnknowns() {
        this.unknowns = null;
        return this;
    }

    @Override
    public Attributes setIgnores(Collection<AttributeName> ignores) {
        if (ignores == null || ignores.isEmpty()) {
            return this.setIgnores();
        }
        for (AttributeName name : ignores) {
            AttributesTools.checkIgnoreName(name);
        }
        this.grantIgnores(true).addAll(ignores);
        return this;
    }

    @Override
    public Attributes setIgnores(AttributeName ... ignores) {
        if (ignores == null || ignores.length == 0) {
            return this.setIgnores();
        }
        for (AttributeName name : ignores) {
            AttributesTools.checkIgnoreName(name);
        }
        Collections.addAll(this.grantIgnores(true), ignores);
        return this;
    }

    @Override
    public Attributes setIgnores(String ... ignores) {
        if (ignores == null || ignores.length == 0) {
            return this.setIgnores();
        }
        Set ig = AttributesTools.createSet();
        QualifiedNamesBuilder nb = this.qualifiedNamesBuilder();
        for (String ignore : ignores) {
            AttributeName name = nb.parseAttributeName(ignore);
            AttributesTools.checkIgnoreName(name);
            ig.add(name);
        }
        this.ignores = ig;
        return this;
    }

    @Override
    public Attributes setIgnores() {
        this.ignores = null;
        return this;
    }

    private Set<AttributeName> grantIgnores(boolean clear) {
        if (this.ignores == null) {
            this.ignores = AttributesTools.createSet();
        } else if (clear) {
            this.ignores.clear();
        }
        return this.ignores;
    }

    @Override
    public Set<AttributeName> getIgnores() {
        return this.ignores == null ? Collections.emptySet() : this.ignores;
    }

    private Set<AttributeName> grantUnknowns(boolean clear) {
        if (this.unknowns == null) {
            this.unknowns = AttributesTools.createSet();
        } else if (clear) {
            this.unknowns.clear();
        }
        return this.unknowns;
    }

    @Override
    public Set<AttributeName> getUnknowns() {
        return this.unknowns == null ? Collections.emptySet() : this.unknowns;
    }

    @Override
    public Map<String, Object> getBackingMap() {
        return this.map;
    }

    @Override
    public void iteratePath(BiConsumer<List<String>, Object> consumer) {
        AttributesTools.iterate(new ArrayList<String>(), this.map, consumer);
    }

    private final class StructureImpl
    implements Attributes.Structure {
        private final Deque<Map<String, Object>> curserStack = new ArrayDeque<Map<String, Object>>();
        private final List<String> curserNamesStack = new ArrayList<String>();
        private final Map<String, Object> root;
        private Map<String, Object> current;

        public StructureImpl(Map<String, Object> root) {
            this.root = root;
            this.current = root;
        }

        public Attributes.Structure reset() {
            this.curserStack.clear();
            this.curserNamesStack.clear();
            this.current = this.root;
            return this;
        }

        @Override
        public Attributes.Structure value(String key, Object value) {
            if (value instanceof Attributes.SpecialValue) {
                ArrayList<String> segments = new ArrayList<String>(this.curserNamesStack);
                segments.add(key);
                AttributesImpl.this.addSpecialValue(AttributesImpl.this.qualifiedNamesBuilder().createAttributeName(segments), (Attributes.SpecialValue)((Object)value));
            } else {
                this.current.put(key, AttributesTools.checkValue(value));
            }
            return this;
        }

        @Override
        public Attributes.Structure structure(String key) {
            this.current = AttributesTools.scope(this.current, key, this.curserStack);
            this.curserNamesStack.add(key);
            return this;
        }

        @Override
        public Attributes.Structure end() {
            this.current = this.curserStack.removeLast();
            this.curserNamesStack.remove(this.curserNamesStack.size() - 1);
            return this;
        }

        @Override
        public Attributes attributes() {
            return AttributesImpl.this;
        }
    }
}

