/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.pdp;

import com.sap.cloud.security.ams.dcl.client.commons.Parameter;
import com.sap.cloud.security.ams.dcl.client.el.AttributeName;
import com.sap.cloud.security.ams.dcl.client.el.QualifiedNamesBuilder;
import com.sap.cloud.security.ams.dcl.client.pdp.Attributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;

class AttributesTools {
    private static final boolean OWN_HASH_SET = Parameter.EMPTY_PROPERTY_SCOPE.create("attributesHashMapSet", true).getValue();
    private static final Set<Class<?>> ALLOWED_TYPES = new HashSet<Class>(Arrays.asList(String.class, Boolean.class, Short.class, Byte.class, Integer.class, Long.class, Float.class, Double.class, ArrayList.class, HashMap.class));

    private AttributesTools() {
    }

    static AttributeName register(AttributeName attributeName) {
        return QualifiedNamesBuilder.toCachedIfAvailable(attributeName);
    }

    static Object deepCopy(Object value) {
        if (value instanceof Map) {
            HashMap res = new HashMap((Map)value);
            for (Map.Entry entry : res.entrySet()) {
                entry.setValue(AttributesTools.deepCopy(entry.getValue()));
            }
            return res;
        }
        if (value instanceof List) {
            List src = (List)value;
            ArrayList<Object> res = new ArrayList<Object>(src.size());
            for (Object o : src) {
                res.add(AttributesTools.deepCopy(o));
            }
            return res;
        }
        return value;
    }

    static <K, V> Map<K, V> deepCopy(Map<K, V> map) {
        return (Map)AttributesTools.deepCopy(map);
    }

    static void iterate(List<String> path, Object current, BiConsumer<List<String>, Object> consumer) {
        if (current instanceof Map) {
            Map map = (Map)current;
            for (Map.Entry e : map.entrySet()) {
                path.add((String)e.getKey());
                AttributesTools.iterate(path, e.getValue(), consumer);
                path.remove(path.size() - 1);
            }
        } else {
            consumer.accept(path, current);
        }
    }

    static <T> T checkValue(T value) {
        if (value == null || ALLOWED_TYPES.contains(value.getClass())) {
            return value;
        }
        if (value instanceof Object[]) {
            Object[] objects = (Object[])value;
            if (objects.length > 0) {
                for (Object o : objects) {
                    AttributesTools.checkValue(o);
                }
            }
            return value;
        }
        if (value instanceof List) {
            List list = (List)value;
            if (!list.isEmpty()) {
                for (Object o : list) {
                    AttributesTools.checkValue(o);
                }
            }
            return value;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            if (!map.isEmpty()) {
                for (Map.Entry o : map.entrySet()) {
                    Object key = o.getKey();
                    if (!(key instanceof String)) {
                        throw new IllegalArgumentException("Map key must be of type String. Value: " + key);
                    }
                    AttributesTools.checkValue(o.getValue());
                }
            }
            return value;
        }
        throw new IllegalArgumentException("Not supported Type: " + value.getClass().getName());
    }

    static Map<String, Object> scope(Map<String, Object> scope, String key, Deque<Map<String, Object>> stack) {
        Object inner;
        AttributesTools.checkKey(key);
        if (stack != null) {
            stack.add(scope);
        }
        if ((inner = scope.get(key)) instanceof Map) {
            return (Map)inner;
        }
        Map<String, Object> nested = AttributesTools.createMap();
        scope.put(key, nested);
        scope = nested;
        return scope;
    }

    static Map<String, Object> createMap() {
        return new HashMap<String, Object>();
    }

    static void checkKeys(String ... content) {
        for (String s : content) {
            AttributesTools.checkKey(s);
        }
    }

    static void checkKeys(Collection<String> content) {
        for (String s : content) {
            AttributesTools.checkKey(s);
        }
    }

    static void checkKey(String key) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Key must not be null or empty");
        }
    }

    private static void checkName(AttributeName name) {
        if (name == null) {
            throw new IllegalArgumentException("SchemaElementName must not be null");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("SchemaElementName must not be empty");
        }
    }

    static void doSet(Map<String, Object> map, Object value, AttributeName name) {
        AttributesTools.checkName(name);
        AttributesTools.checkValue(value);
        if (name.size() == 1) {
            throw new IllegalArgumentException("Illegal to set value on root level");
        }
        if (name.startsWith(Attributes.Names.DCL)) {
            throw new IllegalArgumentException("Illegal to set $dcl attributes");
        }
        int last = name.size() - 1;
        int idx = 0;
        Map<String, Object> scope = map;
        for (String id : name) {
            if (idx == last) {
                scope.put(id, value);
                break;
            }
            ++idx;
            scope = AttributesTools.scope(scope, id, null);
        }
    }

    static <T> Set<T> copyNN(Set<T> data) {
        if (data == null) {
            return null;
        }
        if (OWN_HASH_SET) {
            Set<T> res = AttributesTools.createSet();
            res.addAll(data);
            return res;
        }
        return new HashSet<T>(data);
    }

    static void checkIgnoreName(AttributeName name) {
        Objects.requireNonNull(name, "null name not allowed");
        if (name.equals(AttributeName.EMPTY)) {
            throw new IllegalArgumentException("All elements must not be ignored (which is implicitly done by an empty AttributeName).");
        }
        if (name.startsWith(Attributes.Names.DCL) && !Attributes.Names.DCL_ACTION.equals(name) && !Attributes.Names.DCL_RESOURCE.equals(name)) {
            throw new IllegalArgumentException("Element " + name.toEncodedString() + " must not be ignored.");
        }
    }

    static Object doGet(Map<String, Object> map, AttributeName path) {
        int end = path.size();
        int pos = 0;
        while (true) {
            String key = path.getSegment(pos++);
            Object value = map.get(key);
            if (pos == end) {
                return value != null || map.containsKey(key) ? value : Attributes.SpecialValue.UNSET;
            }
            if (!(value instanceof Map)) {
                return Attributes.SpecialValue.UNSET;
            }
            map = (Map)value;
        }
    }

    static boolean startsWith(AttributeName name, Collection<AttributeName> names) {
        if (names != null && !names.isEmpty()) {
            for (AttributeName n : names) {
                if (!name.startsWith(n)) continue;
                return true;
            }
        }
        return false;
    }

    static <T> Set<T> createSet() {
        return OWN_HASH_SET ? Collections.newSetFromMap(new HashMap()) : new HashSet();
    }
}

