/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.pdp;

import com.sap.cloud.security.ams.dcl.client.annotation.Beta;
import com.sap.cloud.security.ams.dcl.client.commons.Parameter;
import com.sap.cloud.security.ams.dcl.client.el.FilterClause;
import com.sap.cloud.security.ams.dcl.client.pdp.Attributes;
import com.sap.cloud.security.ams.dcl.client.pdp.PolicyDecisionPointFactory;
import com.sap.cloud.security.ams.dcl.client.pdp.PolicyDecisionPointHealthStatus;
import com.sap.cloud.security.ams.dcl.client.pdp.PolicyEvaluationResult;
import java.io.Closeable;
import java.io.File;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public interface PolicyDecisionPoint
extends Closeable {
    public boolean allow(Attributes var1);

    public FilterClause allowFilterClause(Attributes var1);

    public void ping();

    public boolean isReachable();

    public <T> T evaluate(Class<T> var1, String var2, Attributes var3);

    public FilterClause evaluateFilterClause(String var1, Attributes var2);

    public String getVersion();

    public boolean isClosed();

    public void registerListener(Consumer<PolicyEvaluationResult> var1);

    public void deregisterListener(Consumer<PolicyEvaluationResult> var1);

    public PolicyDecisionPointHealthStatus getHealthStatus();

    public static PolicyDecisionPoint create(String kind, Object ... arguments) {
        return PolicyDecisionPointFactory.create(kind, arguments);
    }

    public static interface Parameters {
        public static final Parameter.PropertyScope SCOPE = Parameter.propertyScope("com.sap.dcl", "client");
        public static final Parameter<Long> CONNECT_TIMEOUT = SCOPE.create("connectTimeout", TimeUnit.SECONDS.toMillis(5L));
        public static final Parameter<Long> SOCKET_TIMEOUT = SCOPE.create("socketTimeout", TimeUnit.SECONDS.toMillis(5L));
        public static final Parameter<Long> CONNECTION_REQUEST_TIMEOUT = SCOPE.create("connectionRequestTimeout", TimeUnit.SECONDS.toMillis(5L));
        public static final Parameter<Long> STARTUP_HEALTH_CHECK_TIMEOUT = SCOPE.create("startupHealthCheckTimeout", TimeUnit.SECONDS.toSeconds(30L));
        @Beta
        public static final Parameter<Boolean> FAIL_ON_STARTUP_HEALTH_CHECK = SCOPE.create("failOnStartupHealthCheck", true);
        public static final Parameter<Long> PROCESS_STARTUP_TIMEOUT = SCOPE.create("processStartupTimeout", TimeUnit.SECONDS.toMillis(2L));
        @Deprecated
        public static final Parameter<Long> STARTUP_TIMEOUT = PROCESS_STARTUP_TIMEOUT;
        public static final Parameter<File> SOURCES = Parameter.create(File.class, "sources");
        public static final Parameter<URL> URL = Parameter.create(URL.class, "url");
    }
}

