/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.pdp;

import com.sap.cloud.security.ams.dcl.client.el.FilterClause;
import com.sap.cloud.security.ams.dcl.client.language.DataControlLanguageTools;
import com.sap.cloud.security.ams.dcl.client.pdp.Attributes;
import com.sap.cloud.security.ams.dcl.client.pdp.PolicyEvaluationResult;
import java.util.function.BiConsumer;

public class PolicyEvaluationResultSerializer {
    public static final String ACCESS = "access";
    public static final String ACCESS_RESULT = "accessResult";
    public static final String OPERATION = "operation";
    public static final String KIND = "kind";
    public static final String UNKNOWNS = "unknowns";
    public static final String IGNORES = "ignores";
    private static final PolicyEvaluationResultSerializer INSTANCE = new PolicyEvaluationResultSerializer();

    protected PolicyEvaluationResultSerializer() {
    }

    public void process(PolicyEvaluationResult result, BiConsumer<String, String> consumer) {
        this.processMetadata(result, consumer);
        this.processAttributes(result, consumer);
        this.processResult(result, consumer);
    }

    protected void processMetadata(PolicyEvaluationResult result, BiConsumer<String, String> consumer) {
        consumer.accept(OPERATION, result.getQualifiedOperation());
        consumer.accept(KIND, result.getKind().toString());
    }

    protected void processAttributes(PolicyEvaluationResult result, BiConsumer<String, String> consumer) {
        Attributes att = result.getAttributes();
        if (att != null) {
            consumer.accept(IGNORES, att.getIgnores().toString());
            consumer.accept(UNKNOWNS, att.getUnknowns().toString());
            StringBuilder buffer = new StringBuilder(64);
            att.iteratePath((p, v) -> consumer.accept(DataControlLanguageTools.encodeQualifiedName(p, buffer), String.valueOf(v)));
        }
    }

    protected void processResult(PolicyEvaluationResult result, BiConsumer<String, String> consumer) {
        consumer.accept(ACCESS, result.getResultType().getLowerCaseName());
        consumer.accept(ACCESS_RESULT, PolicyEvaluationResultSerializer.getAccessResult(result));
    }

    protected static String getAccessResult(PolicyEvaluationResult result) {
        Exception failureCause = result.getFailureCause();
        if (failureCause != null) {
            return failureCause.getMessage();
        }
        Object r = result.getResult();
        if (r instanceof FilterClause) {
            r = ((FilterClause)r).getCondition();
        }
        return String.valueOf(r);
    }

    public static PolicyEvaluationResultSerializer getInstance() {
        return INSTANCE;
    }
}

