/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.dataControlLanguage;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DataType implements Enumerator
{
    DT_STRING(0, "DT_STRING", "String"),
    DT_NUMBER(1, "DT_NUMBER", "Number"),
    DT_BOOLEAN(2, "DT_BOOLEAN", "Boolean");

    public static final int DT_STRING_VALUE = 0;
    public static final int DT_NUMBER_VALUE = 1;
    public static final int DT_BOOLEAN_VALUE = 2;
    private static final DataType[] VALUES_ARRAY;
    public static final List<DataType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DataType[]{DT_STRING, DT_NUMBER, DT_BOOLEAN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DataType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DataType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DataType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DataType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DataType get(int value) {
        switch (value) {
            case 0: {
                return DT_STRING;
            }
            case 1: {
                return DT_NUMBER;
            }
            case 2: {
                return DT_BOOLEAN;
            }
        }
        return null;
    }

    private DataType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

