/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.formatting2;

import com.sap.cloud.security.ams.dcl.dataControlLanguage.ActionList;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.Annotation;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.DataControlLanguagePackage;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.Expression;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.IDList;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.PolicyDefinition;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.PolicyDocument;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.PolicyUse;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ResourceList;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.Restriction;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.Rule;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class DataControlLanguageFormatter
extends AbstractFormatter2 {
    protected void _format(PolicyDocument policyDocument, @Extension IFormattableDocument document) {
        PolicyDefinition last = IterableExtensions.lastOrNull(policyDocument.getPolicies());
        EList<PolicyDefinition> _policies = policyDocument.getPolicies();
        for (PolicyDefinition policyDefinition : _policies) {
            document.format(policyDefinition);
            Procedures.Procedure1<IHiddenRegionFormatter> _function = it -> it.oneSpace();
            document.surround(this.textRegionExtensions.regionFor(policyDefinition).feature(DataControlLanguagePackage.Literals.NAMED_ELEMENT__NAME), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function);
            if (policyDefinition == last) {
                Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = it -> it.setNewLines(1);
                document.append(policyDefinition, _function_1);
                continue;
            }
            Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = it -> it.setNewLines(2);
            document.append(policyDefinition, _function_2);
        }
    }

    protected void _format(Restriction it, @Extension IFormattableDocument document) {
        ISemanticRegion restrict = this.textRegionExtensions.regionFor(it).keyword("RESTRICT");
        if (restrict != null) {
            Procedures.Procedure1<IHiddenRegionFormatter> _function = it_1 -> it_1.oneSpace();
            document.append(restrict, (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function);
        }
    }

    protected void _format(PolicyUse it, @Extension IFormattableDocument document) {
        Procedures.Procedure1<IHiddenRegionFormatter> _function = it_1 -> it_1.noSpace();
        document.surround(this.textRegionExtensions.regionFor(it).keyword(";"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function);
        ISemanticRegion reg = this.textRegionExtensions.regionFor(it).feature(DataControlLanguagePackage.Literals.POLICY_USE__POLICY);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = it_1 -> it_1.oneSpace();
        document.prepend(reg, (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_1);
        EList<Restriction> _restrictions = it.getRestrictions();
        for (Restriction restrict : _restrictions) {
            document.format(restrict);
        }
        Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = it_1 -> it_1.newLine();
        document.append(it, _function_2);
    }

    protected void _format(Annotation it, @Extension IFormattableDocument document) {
        Procedures.Procedure1<IHiddenRegionFormatter> _function = it_1 -> it_1.noSpace();
        document.surround(this.textRegionExtensions.regionFor(it).feature(DataControlLanguagePackage.Literals.ANNOTATION__ID), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = it_1 -> it_1.oneSpace();
        document.append(this.textRegionExtensions.regionFor(it).keyword(":"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_1);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = it_1 -> it_1.newLine();
        document.append(it, _function_2);
    }

    protected void _format(PolicyDefinition it, @Extension IFormattableDocument document) {
        EList<Annotation> _annotations = it.getAnnotations();
        for (Annotation ann : _annotations) {
            document.format(ann);
        }
        EList<Rule> _rules = it.getRules();
        for (Rule grant : _rules) {
            document.format(grant);
        }
        EList<PolicyUse> _uses = it.getUses();
        for (PolicyUse policyUse : _uses) {
            document.format(policyUse);
        }
        ISemanticRegion open = this.textRegionExtensions.regionFor(it).keyword("{");
        ISemanticRegion close = this.textRegionExtensions.regionFor(it).keyword("}");
        Procedures.Procedure1<IHiddenRegionFormatter> _function = it_1 -> it_1.newLine();
        document.append(open, (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = it_1 -> it_1.indent();
        document.interior(open, close, _function_1);
        ISemanticRegion polKW = this.textRegionExtensions.regionFor(it).keyword("POLICY");
        Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = it_1 -> it_1.noIndentation();
        document.prepend(polKW, (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_2);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_3 = it_1 -> it_1.oneSpace();
        document.append(polKW, (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_3);
    }

    protected void _format(Rule grant, @Extension IFormattableDocument document) {
        Expression _condition;
        boolean _tripleNotEquals_2;
        ResourceList _resources;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        Procedures.Procedure1<IHiddenRegionFormatter> _function = it -> it.noSpace();
        document.surround(this.textRegionExtensions.regionFor(grant).keyword(";"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = it -> it.oneSpace();
        document.append(this.textRegionExtensions.regionFor(grant).keyword("GRANT"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_1);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = it -> it.oneSpace();
        document.surround(this.textRegionExtensions.regionFor(grant).keyword("ON"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_2);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_3 = it -> it.oneSpace();
        document.surround(this.textRegionExtensions.regionFor(grant).keyword("WHERE"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_3);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_4 = it -> it.newLine();
        document.append(grant, _function_4);
        ActionList _actions = grant.getActions();
        boolean bl = _tripleNotEquals = _actions != null;
        if (_tripleNotEquals) {
            document.format(grant.getActions());
        }
        boolean bl2 = _tripleNotEquals_1 = (_resources = grant.getResources()) != null;
        if (_tripleNotEquals_1) {
            document.format(grant.getResources());
        }
        boolean bl3 = _tripleNotEquals_2 = (_condition = grant.getCondition()) != null;
        if (_tripleNotEquals_2) {
            document.format(grant.getCondition());
        }
    }

    protected void _format(Expression it, @Extension IFormattableDocument document) {
    }

    protected void _format(IDList nameList, @Extension IFormattableDocument document) {
        List<ISemanticRegion> _keywords = this.textRegionExtensions.regionFor(nameList).keywords(",");
        for (ISemanticRegion col : _keywords) {
            Procedures.Procedure1<IHiddenRegionFormatter> _function = it -> it.noSpace();
            Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = it -> it.oneSpace();
            document.append(document.prepend(col, (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_1);
        }
    }

    @Override
    @XbaseGenerated
    public void format(Object it, IFormattableDocument document) {
        if (it instanceof PolicyDefinition) {
            this._format((PolicyDefinition)it, document);
            return;
        }
        if (it instanceof PolicyUse) {
            this._format((PolicyUse)it, document);
            return;
        }
        if (it instanceof Rule) {
            this._format((Rule)it, document);
            return;
        }
        if (it instanceof XtextResource) {
            this._format((XtextResource)it, document);
            return;
        }
        if (it instanceof Annotation) {
            this._format((Annotation)it, document);
            return;
        }
        if (it instanceof Expression) {
            this._format((Expression)it, document);
            return;
        }
        if (it instanceof IDList) {
            this._format((IDList)it, document);
            return;
        }
        if (it instanceof PolicyDocument) {
            this._format((PolicyDocument)it, document);
            return;
        }
        if (it instanceof Restriction) {
            this._format((Restriction)it, document);
            return;
        }
        if (it instanceof EObject) {
            this._format((EObject)it, document);
            return;
        }
        if (it == null) {
            this._format((Void)null, document);
            return;
        }
        if (it != null) {
            this._format(it, document);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, document).toString());
    }
}

