/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.generator;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.sap.cloud.security.ams.dcl.DCLResourceHelper;
import com.sap.cloud.security.ams.dcl.DCLTools;
import com.sap.cloud.security.ams.dcl.client.dcn.DcnContainer;
import com.sap.cloud.security.ams.dcl.client.dcn.DcnTools;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.DataControlLanguagePackage;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerParameter;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerResult;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerResultAccessor;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerTools;
import com.sap.cloud.security.ams.dcl.generator.DCLFileSystemAccess2;
import com.sap.cloud.security.ams.dcl.generator.DCLPartialGenerationProcessor;
import com.sap.cloud.security.ams.dcl.generator.DCLPerCompileAllCaches;
import com.sap.cloud.security.ams.dcl.generator.DCLResourceSetProcessor;
import com.sap.cloud.security.ams.dcl.generator.ResAdapter;
import com.sap.cloud.security.ams.dcl.generator.ResourceLoader;
import com.sap.cloud.security.ams.dcl.generator.ResourceWriter;
import com.sap.cloud.security.ams.dcl.generator.ResourceWriterFileSystem;
import com.sap.cloud.security.ams.dcl.spi.dcn.tools.DcnToDclSerializer;
import com.sap.cloud.security.ams.dcl.support.validation.GenericValidationTools;
import com.sap.cloud.security.ams.dcl.support.validation.ValidationCache;
import com.sap.cloud.security.ams.dcl.validation.PartialCompileValidator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.service.OperationCanceledError;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class DCLCompiler {
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;
    @Inject
    private IResourceValidator validator;
    @Inject
    private DCLResourceHelper dclResourceHelper;
    @Inject
    private Injector injector;
    @Inject
    private DCLCompilerResultAccessor compilerResultAccessor;
    @Inject
    private IResourceDescription.Manager resourceDescriptionManager;
    @Inject
    private DCLFileSystemAccess2 fileSystemAccess;
    @Inject
    private DCLPerCompileAllCaches tenantSchemaCache;
    private static final Iterable<Object> EMPTY_ITERABLE = Collections::emptyIterator;

    public static <T> Iterable<T> emptyIterable() {
        return EMPTY_ITERABLE;
    }

    public void compile(DCLCompilerResult result) throws Exception {
        DCLCompilerParameter cp = result.getCompilerParameter();
        URI baseURI = DCLResourceHelper.normalizeSourceURI(cp.getSourceDirectory().getPath());
        this.dclResourceHelper.setCurrentSource(baseURI);
        ResourceWriter resWriter = cp.getResourceWriter();
        try {
            this.fileSystemAccess.setInMemory(!(resWriter instanceof ResourceWriterFileSystem));
            LoaderImpl loader = new LoaderImpl(this.resourceSetProvider.get(), this.resourceDescriptionManager, baseURI, result);
            cp.getResourceLoader().load(cp, loader);
            ResourceSet resourceSet = loader.getPreparedResourceSet();
            boolean removeCache = ValidationCache.grantValidationCache(resourceSet, this.injector);
            try {
                this.validate(result, resourceSet);
            }
            finally {
                if (removeCache) {
                    ValidationCache.removeValidationCache(resourceSet);
                }
            }
            this.process(result, resourceSet);
            this.fileSystemAccess.saveResources(resWriter);
        }
        finally {
            this.dclResourceHelper.removeCurrentSource();
        }
    }

    private void process(DCLCompilerResult result, ResourceSet resourceSet) throws Exception {
        if (result.isFailed()) {
            if (result.getCompilerParameter().isPartialGeneration()) {
                this.process(result, resourceSet, DCLResourceSetProcessor.State.ERROR);
                DCLPartialGenerationProcessor.ProcessingResult pr = new DCLPartialGenerationProcessor().process(resourceSet, result);
                if (pr == DCLPartialGenerationProcessor.ProcessingResult.ALL_ERRORS_MITIGATED) {
                    result.setErrorsMitigated(true);
                    this.process(result, resourceSet, DCLResourceSetProcessor.State.MITIGATED);
                }
            }
        } else {
            this.process(result, resourceSet, DCLResourceSetProcessor.State.OK);
        }
    }

    private void process(DCLCompilerResult result, ResourceSet resourceSet, DCLResourceSetProcessor.State state) throws Exception {
        for (DCLResourceSetProcessor processor : result.getCompilerParameter().getResourceSetProcessors()) {
            this.injector.injectMembers(processor);
            processor.process(resourceSet, result, state);
        }
    }

    private void validate(DCLCompilerResult result, ResourceSet resourceSet) throws IOException, OperationCanceledError {
        HashMap<String, List<Issue>> issueMap = new HashMap<String, List<Issue>>();
        ArrayList<Resource> resources = new ArrayList<Resource>(resourceSet.getResources());
        try {
            DCLCompiler.validate(result, resources, this.validator, issueMap);
            if (result.getCompilerParameter().isPartialGeneration()) {
                PartialCompileValidator pcv = this.injector.getInstance(PartialCompileValidator.class);
                pcv.setIssueMap(issueMap);
                IResourceValidator rvPartialCompile = GenericValidationTools.createResourceValidator(this.injector, DataControlLanguagePackage.eINSTANCE, pcv);
                DCLCompiler.validate(result, resources, rvPartialCompile, issueMap);
            }
            DCLCompiler.printValidationResult(result, resources, issueMap);
        }
        finally {
            result.setIssueMap(issueMap);
            this.fileSystemAccess.addResults(result);
        }
    }

    private static void validate(DCLCompilerResult result, List<Resource> resources, IResourceValidator validator, Map<String, List<Issue>> issueMap) throws IOException, OperationCanceledError {
        DCLCompilerParameter cp = result.getCompilerParameter();
        for (Resource resource : resources) {
            String relativePath = cp.toRelativeSourcePath(resource);
            List<Issue> issues = validator.validate(resource, CheckMode.ALL, CancelIndicator.NullImpl);
            List<Issue> existingIssues = issueMap.get(relativePath);
            if (existingIssues != null) {
                existingIssues.addAll(issues);
            } else {
                issueMap.put(relativePath, issues);
            }
            if (!DCLTools.hasContent(issues)) continue;
            Collections.sort(issues, DCLCompilerTools.ISSUE_COMPARATOR);
        }
    }

    private static void printValidationResult(DCLCompilerResult result, List<Resource> resources, Map<String, List<Issue>> issueMap) throws IOException {
        DCLCompilerParameter cp = result.getCompilerParameter();
        for (Resource resource : resources) {
            String relativePath = cp.toRelativeSourcePath(resource);
            cp.println("Validation: " + relativePath);
            List<Issue> issues = issueMap.get(relativePath);
            if (!DCLTools.hasContent(issues) || cp.getSeverityPrinter() == null) continue;
            List<String> lines = DCLTools.readFileAsList(cp.getSourceFile(relativePath));
            DCLCompilerTools.printIssues(relativePath, issues, lines, cp.getSeverityPrinter());
        }
    }

    public void clearResources() {
        this.resourceSetProvider.get().getResources().clear();
        this.compilerResultAccessor.clear();
        this.fileSystemAccess.clear();
        this.tenantSchemaCache.clear();
    }

    public void init(DCLCompilerResult result) {
        this.compilerResultAccessor.set(result);
    }

    private static class LoaderImpl
    implements ResourceLoader.LoadContext {
        private final ResourceSet resourceSet;
        private final IResourceDescription.Manager resourceDescriptionManager;
        private final ResourceDescriptionsData index = new ResourceDescriptionsData(DCLCompiler.emptyIterable());
        private final URI baseURI;
        private final int cutoffPrefix;
        private boolean completed;
        private final DcnToDclSerializer dcnSerializer = new DcnToDclSerializer();
        private final DCLCompilerResult result;

        public LoaderImpl(ResourceSet resourceSet, IResourceDescription.Manager resourceDescriptionManager, URI baseURI, DCLCompilerResult result) {
            this.resourceSet = resourceSet;
            this.resourceDescriptionManager = resourceDescriptionManager;
            this.baseURI = baseURI;
            this.cutoffPrefix = baseURI.toString().length();
            this.result = result;
        }

        @Override
        public void addResource(URI uri, InputStream is) throws IOException {
            if (this.completed) {
                throw new IllegalStateException();
            }
            if (this.result.getCompilerParameter().isSupportDCN() && uri.path().endsWith(".dcn")) {
                DcnContainer container = DcnTools.getInstance().deserialize(is);
                this.dcnSerializer.clear();
                this.dcnSerializer.serialize(container);
                String content = this.dcnSerializer.toString();
                is = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
            }
            Resource resource = this.resourceSet.createResource(uri, "");
            resource.load(is, this.resourceSet.getLoadOptions());
            String qualifiedName = uri.toString().substring(this.cutoffPrefix);
            qualifiedName = DCLTools.normalizeToFileSeparatorSlash(qualifiedName);
            ResAdapter.attach(resource, qualifiedName);
            IResourceDescription description = this.resourceDescriptionManager.getResourceDescription(resource);
            this.index.addDescription(uri, description);
        }

        public ResourceSet getPreparedResourceSet() {
            if (this.completed) {
                throw new IllegalStateException();
            }
            this.completed = true;
            ResourceDescriptionsData.ResourceSetAdapter.installResourceDescriptionsData(this.resourceSet, this.index);
            return this.resourceSet;
        }
    }
}

