/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.generator;

import com.sap.cloud.security.ams.dcl.generator.DCLCompilerProvider;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerTools;
import com.sap.cloud.security.ams.dcl.generator.DCLResourceSetCompiler;
import com.sap.cloud.security.ams.dcl.generator.DCLResourceSetProcessor;
import com.sap.cloud.security.ams.dcl.generator.DCLSeverity;
import com.sap.cloud.security.ams.dcl.generator.ResAdapter;
import com.sap.cloud.security.ams.dcl.generator.ResourceLoader;
import com.sap.cloud.security.ams.dcl.generator.ResourceLoaderSourceDirectory;
import com.sap.cloud.security.ams.dcl.generator.ResourceWriter;
import com.sap.cloud.security.ams.dcl.generator.ResourceWriterFileSystem;
import com.sap.cloud.security.ams.dcl.processors.DCLDefaultPackageProcessor;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.diagnostics.Severity;

public class DCLCompilerParameter {
    public static final String P_MULTI_TENANT = "multitenant";
    public static final String P_REGO_GENERATION = "regogeneration";
    public static final String P_PARTIAL_COMPILE = "partialcompile";
    public static final String P_ONE_ENTITY_PER_TENANT_DOCUMENT = "oneentitypertenantdocument";
    public static final String P_ONLY_COMPOSITION_AND_RESTRICTION = "onlycompositionandrestriction";
    public static final String P_DCN = "dcn";
    public static final String P_ACCEPT_DCN = "acceptdcn";
    public static final String P_USING_SUPPORT = "usingsupport";
    private File sourceDirectory;
    private File outputDirectory;
    private boolean verbose = false;
    private IssuesReporting issuesReporting = IssuesReporting.OFF;
    private boolean reportEmptyIssues = false;
    private boolean partialGeneration = false;
    private boolean regoGeneration = true;
    private boolean regoTestGeneration = true;
    private DCLSeverity failOn = DCLSeverity.ERROR;
    private DCLCompilerProvider compilerProvider = DCLCompilerProvider.DEFAULT;
    private final List<DCLResourceSetProcessor> resourceSetProcessors = new ArrayList<DCLResourceSetProcessor>();
    private SeverityPrinter severityPrinter;
    private boolean mtSupport = false;
    private boolean isGlobalGeneration = true;
    private boolean oneEntityPerTenantDocument = false;
    private boolean onlyPolicyRefinements = false;
    private String parameter;
    private ResourceLoader resourceLoader = null;
    private ResourceWriter resourceWriter = new ResourceWriterFileSystem(this);
    private boolean supportDCN;
    private boolean generateLocalPackage = true;
    private boolean usingSupport = false;

    public DCLCompilerParameter() {
        this.resourceSetProcessors.add(new DCLResourceSetCompiler());
        this.resourceSetProcessors.add(new DCLDefaultPackageProcessor());
    }

    public void setSourceDirectory(File src) throws IOException {
        this.sourceDirectory = DCLCompilerTools.sanitizeDirectory(src);
    }

    public void setOutputDirectory(File out) throws IOException {
        this.outputDirectory = DCLCompilerTools.sanitizeDirectory(out);
    }

    public void setDirectories(File src, File out) throws IOException {
        if (src == out) {
            out = src = DCLCompilerTools.sanitizeDirectory(src);
        } else {
            src = DCLCompilerTools.sanitizeDirectory(src);
            out = DCLCompilerTools.sanitizeDirectory(out);
        }
        this.setDirectoriesUnchecked(src, out);
    }

    public void setDirectoriesUnchecked(File src, File out) {
        this.sourceDirectory = src;
        this.outputDirectory = out;
    }

    public File getSourceDirectory() throws IOException {
        if (this.sourceDirectory == null) {
            throw new IllegalStateException("Source directory not set.");
        }
        return this.sourceDirectory;
    }

    public File getSourceFile(String relativeFile) throws IOException {
        return DCLCompilerTools.getFile(this.sourceDirectory, relativeFile);
    }

    public boolean hasOutput() {
        return this.outputDirectory != null;
    }

    public File getOutputDirectory() throws IOException {
        if (this.outputDirectory == null) {
            throw new IllegalStateException("Output directory not set.");
        }
        return this.outputDirectory;
    }

    public File getOutputDirectory(String relativeDirectory) throws IOException {
        return DCLCompilerTools.getDirectory(this.outputDirectory, relativeDirectory);
    }

    public File grantOutputDirectoryFor(String relativeFile) throws IOException {
        return DCLCompilerTools.grantDirectoryForFile(this.outputDirectory, relativeFile);
    }

    public String toRelativeSourcePath(File sourceFile) throws IOException {
        return DCLCompilerTools.getRelativePath(this.sourceDirectory, sourceFile);
    }

    public String toRelativeSourcePath(Resource resource) throws IOException {
        return ResAdapter.getRelativeSourcePath(resource, this.sourceDirectory);
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public DCLSeverity getFailOn() {
        return this.failOn;
    }

    public void setFailOn(DCLSeverity failOn) {
        if (failOn == null) {
            throw new IllegalArgumentException("failOn must not be null");
        }
        this.failOn = failOn;
    }

    public boolean isFailed(DCLSeverity severity) {
        return severity.compareTo(this.failOn) <= 0;
    }

    public boolean isReportEmptyIssues() {
        return this.reportEmptyIssues;
    }

    public void setReportEmptyIssues(boolean reportEmptyIssues) {
        this.reportEmptyIssues = reportEmptyIssues;
    }

    public boolean isPartialGeneration() {
        return this.partialGeneration;
    }

    public void setPartialGeneration(boolean partialGeneration) {
        this.partialGeneration = partialGeneration;
    }

    public boolean isRegoGeneration() {
        return this.regoGeneration;
    }

    public void setRegoGeneration(boolean regoGeneration) {
        this.regoGeneration = regoGeneration;
    }

    public IssuesReporting getIssuesReporting() {
        return this.issuesReporting;
    }

    public void setIssuesReporting(IssuesReporting issuesReporting) {
        this.issuesReporting = issuesReporting != null ? issuesReporting : IssuesReporting.OFF;
    }

    public DCLCompilerProvider getCompilerProvider() {
        return this.compilerProvider;
    }

    public void setCompilerProvider(DCLCompilerProvider compilerProvider) {
        if (compilerProvider == null) {
            throw new IllegalArgumentException("compilerProvider must not be null");
        }
        this.compilerProvider = compilerProvider;
    }

    public void addResourceSetProcessor(DCLResourceSetProcessor processor) {
        this.resourceSetProcessors.add(processor);
    }

    public List<DCLResourceSetProcessor> getResourceSetProcessors() {
        return this.resourceSetProcessors;
    }

    public void println(String data) {
        if (this.isVerbose() && this.getSeverityPrinter() != null) {
            this.getSeverityPrinter().println(Severity.INFO, data);
        }
    }

    public SeverityPrinter getSeverityPrinter() {
        return this.severityPrinter;
    }

    public void setSeverityPrinter(SeverityPrinter printer) {
        this.severityPrinter = printer;
    }

    public void setSeverityPrinter(final PrintStream out) {
        Objects.requireNonNull(out);
        this.setSeverityPrinter(new SeverityPrinter(){

            @Override
            public void println(Severity severity, String x) {
                out.println(x);
            }

            @Override
            public void print(Severity severity, StringBuilder sb) {
                if (sb.length() > 8192 || severity == null) {
                    out.append(sb);
                    sb.setLength(0);
                }
            }
        });
    }

    public boolean isMtSupport() {
        return this.mtSupport;
    }

    public void setMtSupport(boolean mtSupport) {
        this.mtSupport = mtSupport;
        if (!mtSupport) {
            this.usingSupport = false;
        }
    }

    public boolean isOnlyOneEntityPerTenant() {
        return this.oneEntityPerTenantDocument;
    }

    public void setOnlyOneEntityPerTenant(boolean onlyOneEntityPerTenant) {
        this.oneEntityPerTenantDocument = onlyOneEntityPerTenant;
    }

    public boolean isOnlyPolicyRefinements() {
        return this.onlyPolicyRefinements;
    }

    public void setOnlyPolicyRefinements(boolean onlyPolicyRefinements) {
        this.onlyPolicyRefinements = onlyPolicyRefinements;
    }

    public boolean isGlobalGeneration() {
        return this.isGlobalGeneration;
    }

    public void setGlobalGeneration(boolean isGlobalGeneration) {
        this.isGlobalGeneration = isGlobalGeneration;
    }

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader != null ? this.resourceLoader : ResourceLoaderSourceDirectory.INSTANCE;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public ResourceWriter getResourceWriter() {
        return this.resourceWriter;
    }

    public void setResourceWriter(ResourceWriter resourceWriter) {
        this.resourceWriter = resourceWriter != null ? resourceWriter : new ResourceWriterFileSystem(this);
    }

    public boolean isRegoTestGeneration() {
        return this.regoTestGeneration;
    }

    public void setRegoTestGeneration(boolean regoTestGeneration) {
        this.regoTestGeneration = regoTestGeneration;
    }

    public boolean isSupportDCN() {
        return this.supportDCN;
    }

    public void setSupportDCN(boolean supportDCN) {
        this.supportDCN = supportDCN;
    }

    public boolean isGenerateLocalPackage() {
        return this.generateLocalPackage;
    }

    public void setGenerateLocalPackage(boolean generateLocalPackage) {
        this.generateLocalPackage = generateLocalPackage;
    }

    public boolean isUsingSupport() {
        return this.usingSupport;
    }

    public void setUsingSupport(boolean tenantUsing) {
        if (tenantUsing) {
            this.usingSupport = true;
            this.mtSupport = true;
        } else {
            this.usingSupport = false;
        }
    }

    public static enum IssuesReporting {
        SOURCE,
        SINGLE,
        OFF;

    }

    public static interface SeverityPrinter {
        public void println(Severity var1, String var2);

        public void print(Severity var1, StringBuilder var2);
    }
}

