/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.generator;

import com.sap.cloud.security.ams.dcl.generator.DCLCompiler;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerProvider;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerResult;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public class DCLCompilerProviderCached
extends DCLCompilerProvider
implements AutoCloseable {
    private Queue<DCLCompiler> compilers = new LinkedBlockingQueue<DCLCompiler>();

    @Override
    public DCLCompiler lease(DCLCompilerResult result) {
        DCLCompiler compiler = this.compilers.poll();
        if (compiler == null) {
            return super.lease(result);
        }
        compiler.init(result);
        return compiler;
    }

    @Override
    public void unlease(DCLCompiler compiler) {
        super.unlease(compiler);
        this.compilers.add(compiler);
    }

    @Override
    public void close() {
        this.compilers.clear();
    }
}

