/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.generator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sap.cloud.security.ams.dcl.DCLTools;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerParameter;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerTools;
import com.sap.cloud.security.ams.dcl.generator.DCLSeverity;
import com.sap.cloud.security.ams.dcl.generator.IssueTypeAdapter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.validation.Issue;

public class DCLCompilerResult {
    private DCLSeverity dclSeverity;
    private String message;
    private boolean deprecations;
    private Map<String, List<Issue>> dclIssues = Collections.emptyMap();
    private final transient DCLCompilerParameter compilerParameter;
    private boolean errorsMitigated;
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(Issue.class, IssueTypeAdapter.getInstance()).create();

    private DCLCompilerResult() {
        this.compilerParameter = null;
        this.dclSeverity = DCLSeverity.OK;
    }

    public DCLCompilerResult(DCLCompilerParameter compilerParameter) {
        this.compilerParameter = Objects.requireNonNull(compilerParameter, "DCLCompilerParameter must not be null.");
        this.dclSeverity = DCLSeverity.OK;
    }

    public DCLCompilerParameter getCompilerParameter() {
        return this.compilerParameter;
    }

    public DCLSeverity getSeverity() {
        return this.dclSeverity;
    }

    public void setSeverity(DCLSeverity severity) {
        this.dclSeverity = Objects.requireNonNull(severity, "State must not be null");
    }

    public void setState(DCLSeverity severity, String message, boolean deprecations) {
        this.setSeverity(severity);
        this.setMessage(message);
        this.setDeprecations(deprecations);
    }

    public Map<String, List<Issue>> getIssueMap() {
        return this.dclIssues;
    }

    public void setIssueMap(Map<String, List<Issue>> issueMap) {
        this.dclIssues = DCLTools.hasContent(issueMap) ? Collections.unmodifiableMap(issueMap) : Collections.emptyMap();
        DCLCompilerTools.setStateforIssue(this, this.dclIssues);
    }

    public void setDeprecations(boolean deprecations) {
        this.deprecations = deprecations;
    }

    public boolean hasDeprecations() {
        return this.deprecations;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    private String saveJson(Object data) throws IOException {
        return GSON.toJson(data);
    }

    private void saveJson(String fileName, Object data) throws IOException {
        this.compilerParameter.getResourceWriter().write(fileName, GSON.toJson(data));
    }

    public void saveSingleResultFile() throws IOException {
        this.saveJson("_dcl_.result", this);
    }

    public void saveResultPerSourceFile() throws IOException {
        for (Map.Entry<String, List<Issue>> entry : this.dclIssues.entrySet()) {
            if (!this.compilerParameter.isReportEmptyIssues() && entry.getValue().isEmpty()) continue;
            this.saveJson(DCLTools.changeSuffix(entry.getKey(), ".issues"), entry.getValue());
        }
    }

    public Map<String, String> getResults() throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        switch (this.compilerParameter.getIssuesReporting()) {
            case SOURCE: {
                for (Map.Entry<String, List<Issue>> entry : this.dclIssues.entrySet()) {
                    if (!this.compilerParameter.isReportEmptyIssues() && entry.getValue().isEmpty()) continue;
                    result.put(DCLTools.changeSuffix(entry.getKey(), ".issues"), this.saveJson(entry.getValue()));
                }
                break;
            }
            case SINGLE: {
                result.put("_dcl_.result", this.saveJson(this));
                break;
            }
        }
        return result;
    }

    public void saveResults() throws IOException {
        switch (this.compilerParameter.getIssuesReporting()) {
            case SOURCE: {
                this.saveResultPerSourceFile();
                break;
            }
            case SINGLE: {
                this.saveSingleResultFile();
                break;
            }
        }
    }

    public boolean isFailed() {
        return this.compilerParameter.isFailed(this.getSeverity());
    }

    public boolean isSuccessful() {
        return !this.isFailed();
    }

    public boolean knowsFile(String relativePath) {
        return this.dclIssues.containsKey(relativePath);
    }

    public DCLSeverity getSeverity(String relativePath) {
        List<Issue> issues = this.dclIssues.get(relativePath);
        if (issues == null) {
            if (this.knowsFile(relativePath)) {
                return DCLSeverity.OK;
            }
            throw new IllegalArgumentException("No Issues defined for path '" + relativePath + "'.");
        }
        return DCLCompilerTools.getMaxSeverity(DCLSeverity.OK, issues);
    }

    public DCLSeverity getSeverity(Resource resource) throws IOException {
        String relativePath = this.compilerParameter.toRelativeSourcePath(resource);
        return this.getSeverity(relativePath);
    }

    public void setErrorsMitigated(boolean errorsMitigated) {
        this.errorsMitigated = errorsMitigated;
    }

    public boolean isErrorsMitigated() {
        return this.errorsMitigated;
    }
}

