/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.generator;

import com.sap.cloud.security.ams.dcl.DCLTools;
import com.sap.cloud.security.ams.dcl.generator.DCLCompiler;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerParameter;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerProvider;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerResult;
import com.sap.cloud.security.ams.dcl.generator.DCLSeverity;
import com.sap.cloud.security.ams.dcl.generator.ResAdapter;
import com.sap.cloud.security.ams.dcl.validation.DCLIssue;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Comparator;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Issue;

public class DCLCompilerTools {
    private static final String BLANKS = "                                                  ";
    private static final String TABS = "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t";
    private static final String CARET = "^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^";
    private static final Integer MINUS_1 = -1;
    public static final Comparator<Issue> ISSUE_COMPARATOR = (issue1, issue2) -> {
        int lineNumberCompare = DCLCompilerTools.nullSafeCompare(issue1.getLineNumber(), issue2.getLineNumber());
        if (lineNumberCompare != 0) {
            return lineNumberCompare;
        }
        int columnCompare = DCLCompilerTools.nullSafeCompare(issue1.getColumn(), issue2.getColumn());
        if (columnCompare != 0) {
            return columnCompare;
        }
        int offsetCompare = DCLCompilerTools.nullSafeCompare(issue1.getOffset(), issue2.getOffset());
        if (offsetCompare != 0) {
            return offsetCompare;
        }
        return Strings.notNull(issue1.getMessage()).compareTo(Strings.notNull(issue2.getMessage()));
    };

    private DCLCompilerTools() {
    }

    static File sanitizeDirectory(File dir) throws IOException {
        if (dir != null && !(dir = dir.getCanonicalFile()).isDirectory()) {
            throw new FileNotFoundException("Not a directory at " + dir.getPath());
        }
        return dir;
    }

    static String getRelativePath(File baseDir, File sourceFile) throws IOException {
        if (baseDir.equals(sourceFile)) {
            return "";
        }
        String result = baseDir.toPath().relativize(sourceFile.toPath()).toFile().getPath();
        File check = new File(baseDir, result).getCanonicalFile();
        if (!check.getPath().equals(baseDir.getPath()) && !check.getPath().startsWith(baseDir.getPath() + File.separator)) {
            throw new IOException(sourceFile.getPath() + " not within base directory.");
        }
        return result;
    }

    private static File getFileOrDirectory(File base, String relativePath, boolean check, boolean isFile) throws IOException {
        if (base == null) {
            return null;
        }
        if (DCLTools.isEmpty(relativePath)) {
            return base;
        }
        File res = DCLCompilerTools.checkForNested(base, relativePath);
        if (check) {
            if (isFile) {
                if (!res.isFile()) {
                    throw new FileNotFoundException(res.getPath() + " (file not found).");
                }
            } else if (!res.isDirectory()) {
                throw new FileNotFoundException(res.getPath() + " (sub-Directory not found).");
            }
        }
        return res;
    }

    private static File checkForNested(File base, String name) throws IOException {
        File res = new File(base, name).getCanonicalFile();
        if (!res.getPath().startsWith(base.getPath() + File.separator)) {
            throw new IOException(name + " not within base directory.");
        }
        return res;
    }

    public static File getFile(File base, String relativePath) throws IOException {
        return DCLCompilerTools.getFileOrDirectory(base, relativePath, true, true);
    }

    public static File getFileUnchecked(File base, String relativePath) throws IOException {
        return DCLCompilerTools.getFileOrDirectory(base, relativePath, false, true);
    }

    public static File getDirectory(File base, String relativePath) throws IOException {
        return DCLCompilerTools.getFileOrDirectory(base, relativePath, true, false);
    }

    public static File grantDirectoryForFile(File base, String fileName) throws IOException {
        return DCLCompilerTools.grantDirectory(base, fileName, true);
    }

    private static File grantDirectory(File base, String name, boolean isFile) throws IOException {
        File dir;
        if (DCLTools.isEmpty(name)) {
            return base;
        }
        File target = DCLCompilerTools.checkForNested(base, name);
        File file = dir = isFile ? target.getParentFile() : target;
        if (!dir.isDirectory()) {
            if (dir.isFile()) {
                throw new IOException("Failed to create directoriy because it is a file '" + dir.getPath() + "'.");
            }
            if (!dir.mkdirs()) {
                throw new IOException("Failed to create directories '" + dir.getPath() + "'.");
            }
        }
        return target;
    }

    public static void printIssues(String relativePath, List<Issue> issues, List<String> lines, DCLCompilerParameter.SeverityPrinter consumer) {
        if (DCLTools.isEmpty(issues)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        Throwable throwable = null;
        Object var6_7 = null;
        try (Formatter fmt = new Formatter(sb);){
            for (Issue issue : issues) {
                fmt.format("%s:%d:%s:%s:%s%n", new Object[]{relativePath, issue.getLineNumber(), issue.getSeverity(), issue.getCode(), issue.getMessage()});
                DCLCompilerTools.printLineAndCarret(sb, issue, lines);
                consumer.print(issue.getSeverity(), sb);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (sb.length() > 0) {
            consumer.print(null, sb);
        }
    }

    private static void printLineAndCarret(StringBuilder sb, Issue issue, List<String> lines) {
        if (issue.getLineNumber() == null || issue.getColumn() == null || lines == null) {
            return;
        }
        int line = issue.getLineNumber();
        int column = issue.getColumn();
        if (line < 1 || line > lines.size()) {
            return;
        }
        String issueLine = lines.get(line - 1);
        sb.append(issueLine);
        sb.append('\n');
        if (column < 1 || column > issueLine.length()) {
            return;
        }
        int pos = 0;
        int end = column - 1;
        while (pos < end) {
            int start = pos;
            while (pos < end && issueLine.charAt(pos) != '\t') {
                ++pos;
            }
            DCLCompilerTools.appendN(sb, BLANKS, pos - start);
            start = pos;
            while (pos < end && issueLine.charAt(pos) == '\t') {
                ++pos;
            }
            DCLCompilerTools.appendN(sb, TABS, pos - start);
        }
        Integer lineEndInt = issue.getLineNumberEnd();
        Integer colEndInt = issue.getColumnEnd();
        if (lineEndInt != null && colEndInt != null) {
            if (lineEndInt > line) {
                DCLCompilerTools.appendN(sb, CARET, issueLine.length() + 1 - column);
            } else if (lineEndInt == line && colEndInt > column) {
                DCLCompilerTools.appendN(sb, CARET, colEndInt - column);
            } else {
                sb.append('^');
            }
        } else {
            sb.append('^');
        }
        sb.append('\n');
    }

    private static void appendN(StringBuilder sb, String content, int n) {
        while (n > 0) {
            int cnt = Math.min(n, content.length());
            sb.append(content, 0, cnt);
            n -= cnt;
        }
    }

    private static Issue getIssueWithHigherSeverity(DCLSeverity currentMax, List<Issue> issues) {
        if (currentMax == DCLSeverity.ERROR || !DCLTools.hasContent(issues)) {
            return null;
        }
        DCLSeverity newMax = currentMax;
        Issue higherSeverityIssue = null;
        for (Issue issue : issues) {
            DCLSeverity severity = DCLCompilerTools.convertToDCLSeverity(issue);
            if (newMax.compareTo(severity) <= 0) continue;
            newMax = severity;
            higherSeverityIssue = issue;
            if (newMax != DCLSeverity.ERROR) continue;
            return higherSeverityIssue;
        }
        if (higherSeverityIssue == null || currentMax.compareTo(newMax) <= 0) {
            return null;
        }
        return higherSeverityIssue;
    }

    public static void setStateforIssue(DCLCompilerResult result, Map<String, List<Issue>> dclIssues) {
        boolean hasDeprecations = false;
        DCLSeverity overallSeverity = DCLSeverity.OK;
        String message = null;
        for (Map.Entry<String, List<Issue>> entry : dclIssues.entrySet()) {
            Issue newMax;
            List<Issue> issues = entry.getValue();
            if (!hasDeprecations) {
                for (Issue issue : issues) {
                    if (!DCLIssue.getIssueByCodeOrDefault(issue.getCode(), DCLIssue.UNKNOWN_ERROR).isDeprecated()) continue;
                    hasDeprecations = true;
                }
            }
            if ((newMax = DCLCompilerTools.getIssueWithHigherSeverity(overallSeverity, issues)) != null) {
                overallSeverity = DCLCompilerTools.convertToDCLSeverity(newMax);
                message = newMax.toString();
            }
            if (hasDeprecations && overallSeverity == DCLSeverity.ERROR) break;
        }
        result.setState(overallSeverity, message, hasDeprecations);
    }

    public static DCLSeverity getMaxSeverity(DCLSeverity currentMax, List<Issue> issues) {
        DCLSeverity newMax = currentMax;
        Issue higherSeverityIssue = DCLCompilerTools.getIssueWithHigherSeverity(currentMax, issues);
        if (higherSeverityIssue != null) {
            newMax = DCLCompilerTools.convertToDCLSeverity(higherSeverityIssue);
        }
        return newMax;
    }

    public static DCLCompilerResult compile(DCLCompilerParameter cp) throws Exception {
        DCLCompilerResult result = new DCLCompilerResult(cp);
        DCLCompilerTools.compile(result);
        return result;
    }

    public static <T extends DCLCompilerResult> T compile(T result) throws Exception {
        DCLCompilerProvider provider = result.getCompilerParameter().getCompilerProvider();
        DCLCompiler main = provider.lease(result);
        try {
            main.compile(result);
            T t = result;
            return t;
        }
        finally {
            provider.unlease(main);
        }
    }

    public static DCLSeverity convertToDCLSeverity(Severity severity) {
        switch (severity) {
            case ERROR: {
                return DCLSeverity.ERROR;
            }
            case WARNING: {
                return DCLSeverity.WARNING;
            }
            case INFO: {
                return DCLSeverity.INFO;
            }
        }
        return DCLSeverity.OK;
    }

    public static DCLSeverity convertToDCLSeverity(Issue issue) {
        return DCLCompilerTools.convertToDCLSeverity(issue.getSeverity());
    }

    private static int nullSafeCompare(Integer x, Integer y) {
        return DCLCompilerTools.notNull(x).compareTo(DCLCompilerTools.notNull(y));
    }

    private static Integer notNull(Integer x) {
        return x != null ? x : MINUS_1;
    }

    public static Resource getPackageReferenceResource(Resource resource) {
        for (Resource r : resource.getResourceSet().getResources()) {
            if (!DCLCompilerTools.isLowerResourceSamePackage(r, resource)) continue;
            resource = r;
        }
        return resource;
    }

    private static boolean isLowerResourceSamePackage(Resource resourceA, Resource resourceB) {
        if (resourceA == resourceB) {
            return false;
        }
        URI a = resourceA.getURI();
        URI b = resourceB.getURI();
        int sc = a.segmentCount();
        if (sc != b.segmentCount()) {
            return false;
        }
        int i = sc - 2;
        while (i >= 0) {
            if (!Objects.equals(a.segment(i), b.segment(i))) {
                return false;
            }
            --i;
        }
        return a.lastSegment().compareTo(b.lastSegment()) < 0;
    }

    public static String getResourcePath(Resource resource) {
        for (Adapter adapter : resource.eAdapters()) {
            if (!(adapter instanceof ResAdapter)) continue;
            ResAdapter resAdapter = (ResAdapter)adapter;
            return resAdapter.relativeSourcePath;
        }
        return null;
    }
}

