/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.generator;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerResult;
import com.sap.cloud.security.ams.dcl.generator.DCLInMemoryFileSystemAccess;
import com.sap.cloud.security.ams.dcl.generator.ResourceWriter;
import java.io.IOException;
import org.eclipse.xtext.generator.AbstractFileSystemAccess2;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;

@Singleton
public class DCLFileSystemAccess2 {
    @Inject
    private JavaIoFileSystemAccess fileSystemAccessIO;
    @Inject
    private DCLInMemoryFileSystemAccess fileSystemAccessMemory;
    private AbstractFileSystemAccess2 fsa;

    private boolean isMemory() {
        return this.fsa == this.fileSystemAccessMemory;
    }

    public void setInMemory(boolean memory) {
        this.fsa = memory ? this.fileSystemAccessMemory : this.fileSystemAccessIO;
    }

    public AbstractFileSystemAccess2 getFileSystemAccess() {
        return this.fsa;
    }

    public void addResults(DCLCompilerResult result) throws IOException {
        if (this.isMemory()) {
            this.fileSystemAccessMemory.getAllFiles().putAll(result.getResults());
        } else {
            result.saveResults();
        }
    }

    public void saveResources(ResourceWriter rw) throws IOException {
        if (this.isMemory()) {
            this.fileSystemAccessMemory.saveResources(rw);
        }
    }

    public void clear() {
        this.fileSystemAccessMemory.getAllFiles().clear();
    }
}

