/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.generator;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;

class DCLFilesVisitor
extends SimpleFileVisitor<Path> {
    private Predicate<Path> folderCheck;
    private List<File> files = new ArrayList<File>();

    DCLFilesVisitor(Predicate<Path> check) {
        this.folderCheck = check;
    }

    public List<File> getFiles() {
        List<File> res = this.files;
        this.files = null;
        Collections.sort(res);
        return res;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        return this.folderCheck.test(dir) ? super.preVisitDirectory(dir, attrs) : FileVisitResult.SKIP_SUBTREE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        File f = file.toFile();
        if (f.getName().toLowerCase(Locale.US).endsWith(".dcl")) {
            this.files.add(f);
        }
        return super.visitFile(file, attrs);
    }
}

