/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.generator;

import com.google.common.collect.Iterators;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionSpecialValue;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.IDList;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.TestCase;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.TestCaseInput;
import java.util.Collections;
import java.util.List;

public class DCLGeneratorTools {
    private DCLGeneratorTools() {
    }

    public static boolean hasSpecialValue(TestCaseInput input) {
        return input != null && Iterators.filter(input.eAllContents(), ExpressionSpecialValue.class).hasNext();
    }

    public static List<String> getList(IDList it) {
        if (it == null || it.isStar()) {
            return Collections.singletonList(null);
        }
        return it.getNames();
    }

    public static <T> List<T> getList(List<T> it) {
        if (it == null || it.isEmpty()) {
            return Collections.singletonList(null);
        }
        return it;
    }

    public static boolean isResultFromEffect(TestCase tc) {
        return tc.isDeny() || tc.isGrant();
    }
}

