/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.generator;

import com.sap.cloud.security.ams.dcl.DCLTools;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.FunctionDefinition;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.PolicyDefinition;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.PolicyDocument;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.TestCase;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerResult;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerTools;
import com.sap.cloud.security.ams.dcl.generator.DCLSeverity;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.validation.Issue;

public class DCLPartialGenerationProcessor {
    private final Set<PolicyDefinition> erroneousPolicies = new HashSet<PolicyDefinition>();
    private final Set<FunctionDefinition> erroneousFunctions = new HashSet<FunctionDefinition>();
    private final Set<TestCase> erroneousTestCases = new HashSet<TestCase>();
    private final Set<Issue> visitedErrors = new HashSet<Issue>();
    private final Set<Issue> mitigatedErrors = new HashSet<Issue>();

    public ProcessingResult process(ResourceSet resourceSet, DCLCompilerResult result) {
        if (resourceSet == null || result == null) {
            return ProcessingResult.ALL_ERRORS_MITIGATED;
        }
        this.erroneousPolicies.clear();
        this.erroneousFunctions.clear();
        this.erroneousTestCases.clear();
        this.visitedErrors.clear();
        this.mitigatedErrors.clear();
        this.addObjectsWithErrors(this.erroneousPolicies, resourceSet, result.getIssueMap(), PolicyDefinition.class);
        this.addObjectsWithErrors(this.erroneousFunctions, resourceSet, result.getIssueMap(), FunctionDefinition.class);
        this.addObjectsWithErrors(this.erroneousTestCases, resourceSet, result.getIssueMap(), TestCase.class);
        this.removeErroneousObjects(resourceSet);
        return this.visitedErrors.equals(this.mitigatedErrors) ? ProcessingResult.ALL_ERRORS_MITIGATED : ProcessingResult.NOT_ALL_ERRORS_MITIGATED;
    }

    private void removeErroneousObjects(ResourceSet resourceSet) {
        resourceSet.getResources().forEach(resource -> {
            PolicyDocument policyDocument = DCLTools.getPolicyDocument(resource);
            if (policyDocument != null) {
                EList<PolicyDefinition> policyDefinitions = policyDocument.getPolicies();
                policyDefinitions.removeIf(this.erroneousPolicies::contains);
                EList<FunctionDefinition> functionDefinitions = policyDocument.getFunctions();
                functionDefinitions.removeIf(this.erroneousFunctions::contains);
                policyDocument.getTestScenarios().forEach(ts -> {
                    EList<TestCase> testCases = ts.getTestCases();
                    testCases.removeIf(this.erroneousTestCases::contains);
                });
                policyDocument.getTestScenarios().removeIf(x -> x.getTestCases().isEmpty());
            }
        });
    }

    private <T> void addObjectsWithErrors(Set<T> objectSet, ResourceSet resourceSet, Map<String, List<Issue>> issueMap, Class<T> type) {
        for (Map.Entry<String, List<Issue>> issues : issueMap.entrySet()) {
            List<Issue> resourceIssues = issues.getValue();
            if (DCLTools.isEmpty(resourceIssues)) continue;
            for (Issue issue : resourceIssues) {
                EObject eoWithError;
                T parent;
                if (!DCLCompilerTools.convertToDCLSeverity(issue.getSeverity()).equals((Object)DCLSeverity.ERROR)) continue;
                this.visitedErrors.add(issue);
                URI uriToProblem = issue.getUriToProblem();
                if (uriToProblem == null || (parent = DCLPartialGenerationProcessor.computeParent(eoWithError = resourceSet.getEObject(uriToProblem, false), type)) == null) continue;
                this.mitigatedErrors.add(issue);
                objectSet.add(parent);
            }
        }
    }

    public static <T> T computeParent(EObject o, Class<T> parentType) {
        if (o == null) {
            return null;
        }
        if (parentType.isInstance(o)) {
            return (T)o;
        }
        return DCLPartialGenerationProcessor.computeParent(o.eContainer(), parentType);
    }

    public static enum ProcessingResult {
        ALL_ERRORS_MITIGATED,
        NOT_ALL_ERRORS_MITIGATED;

    }
}

