/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.generator;

import com.google.inject.Inject;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerParameter;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerResult;
import com.sap.cloud.security.ams.dcl.generator.DCLFileSystemAccess2;
import com.sap.cloud.security.ams.dcl.generator.DCLResourceSetProcessor;
import java.io.IOException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.generator.AbstractFileSystemAccess2;
import org.eclipse.xtext.generator.GeneratorContext;
import org.eclipse.xtext.generator.GeneratorDelegate;
import org.eclipse.xtext.util.CancelIndicator;

public class DCLResourceSetCompiler
implements DCLResourceSetProcessor {
    @Inject
    private GeneratorDelegate generator;
    @Inject
    private DCLFileSystemAccess2 fsa;

    @Override
    public void process(ResourceSet resourceSet, DCLCompilerResult result, DCLResourceSetProcessor.State state) throws IOException {
        if (state == DCLResourceSetProcessor.State.ERROR) {
            return;
        }
        DCLCompilerParameter cp = result.getCompilerParameter();
        if (!cp.hasOutput()) {
            cp.println("No target directory set. Skipping generation.");
            return;
        }
        if (result.isFailed() && !cp.isPartialGeneration()) {
            cp.println("Result in state failed. Skipping generation.");
            return;
        }
        if (!cp.isRegoGeneration()) {
            cp.println("Rego is disabled. Skipping generation.");
            return;
        }
        AbstractFileSystemAccess2 fileAccess = this.fsa.getFileSystemAccess();
        fileAccess.setCurrentSource(cp.getSourceDirectory().getPath());
        fileAccess.setOutputPath(cp.getOutputDirectory().getPath());
        GeneratorContext context = new GeneratorContext();
        context.setCancelIndicator(CancelIndicator.NullImpl);
        for (Resource resource : resourceSet.getResources()) {
            String rsp = cp.toRelativeSourcePath(resource);
            if (cp.isFailed(result.getSeverity(resource))) {
                if (cp.isPartialGeneration()) {
                    cp.println("Continue generation (errors mitigated): " + rsp);
                } else {
                    cp.println("Skipping generation (due to errors): " + rsp);
                    continue;
                }
            }
            cp.println("Generating: " + rsp);
            this.generator.generate(resource, fileAccess, context);
        }
    }
}

