/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.generator;

import com.sap.cloud.security.ams.dcl.DCLBuildInformationTools;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerParameter;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerResult;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerTools;
import com.sap.cloud.security.ams.dcl.generator.DCLSeverity;
import com.sap.cloud.security.ams.dcl.processors.DCLUIIndexSerializer;
import com.sap.cloud.security.ams.dcl.processors.DcnSerializer;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;

public class DCLStandaloneCompiler {
    public static final String FAIL_ON_DEPRECATION = "deprecation";
    public static final String FAIL_ON_WARNING = "warning";
    public static final String COMPILATION_FAILED_DEPRECATIONS = "Compilation failed due to existing deprecations in dcl files. To change this behavior, you can configure the failOn parameter.";
    public static final String COMPILATION_FAILED_WARNINGS = "Compilation failed due to existing warnings in dcl files. To change this behavior, you can configure the failOn parameter.";
    private static final PrintStream ERR = System.err;
    private static final PrintStream OUT = System.out;

    private DCLStandaloneCompiler() {
    }

    public static void main(String[] args) throws Exception {
        System.exit(DCLStandaloneCompiler.doMain(args));
    }

    public static int doMain(String[] args) throws Exception {
        DCLCompilerParameterExt cp;
        try {
            cp = DCLStandaloneCompiler.processArgs(args);
            if (cp == null) {
                return DCLSeverity.ERROR.getExitCode();
            }
        }
        catch (IOException e) {
            ERR.println(e.getMessage());
            return DCLSeverity.ERROR.getExitCode();
        }
        return cp.isMultiple() ? DCLStandaloneCompiler.compileFolder(cp) : DCLStandaloneCompiler.compileSingle(cp);
    }

    private static void updateCompilerResult(DCLCompilerParameterExt cp, DCLCompilerResult cr) {
        DCLSeverity sev = cr.getSeverity();
        if (sev == DCLSeverity.ERROR) {
            return;
        }
        if (cp.isFailOnDeprecation() && cr.hasDeprecations()) {
            cr.setMessage(COMPILATION_FAILED_DEPRECATIONS);
            cr.setSeverity(DCLSeverity.ERROR);
        } else if (cp.isFailOnWarning() && sev == DCLSeverity.WARNING) {
            cr.setMessage(COMPILATION_FAILED_WARNINGS);
            cr.setSeverity(DCLSeverity.ERROR);
        }
    }

    private static int compileSingle(DCLCompilerParameterExt cp) throws Exception {
        DCLCompilerResult cr = DCLCompilerTools.compile(cp);
        DCLStandaloneCompiler.updateCompilerResult(cp, cr);
        if (cr.getMessage() != null) {
            ERR.println(cr.getMessage());
        }
        return cr.getSeverity().getExitCode();
    }

    private static int compileFolder(DCLCompilerParameterExt cp) throws IOException, Exception {
        File root = cp.getSourceDirectory();
        File[] directories = root.listFiles((current, name) -> new File(current, name).isDirectory());
        DCLSeverity resultSeverity = DCLSeverity.OK;
        File[] fileArray = directories;
        int n = directories.length;
        int n2 = 0;
        while (n2 < n) {
            File sourceDir = fileArray[n2];
            cp.setDirectories(sourceDir, sourceDir);
            OUT.println("Compiling " + sourceDir.getName());
            long start = System.currentTimeMillis();
            DCLCompilerResult cr = DCLCompilerTools.compile(cp);
            DCLStandaloneCompiler.updateCompilerResult(cp, cr);
            resultSeverity = resultSeverity.max(cr.getSeverity());
            if (cr.getMessage() != null) {
                ERR.println(cr.getMessage());
            }
            OUT.println("Completed in " + (System.currentTimeMillis() - start) + "ms");
            OUT.println();
            ++n2;
        }
        return resultSeverity.getExitCode();
    }

    private static DCLCompilerParameterExt processArgs(String[] args) throws IOException {
        String argm;
        DCLCompilerParameterExt cp = new DCLCompilerParameterExt();
        cp.setSeverityPrinter(ERR);
        int idx = 0;
        File out = null;
        while (idx < args.length && (argm = args[idx]).startsWith("-")) {
            String cfg;
            String key;
            ++idx;
            int p = argm.indexOf("=");
            if (p == -1) {
                key = argm.substring(1);
                cfg = "";
            } else {
                key = argm.substring(1, p);
                cfg = argm.substring(p + 1);
            }
            switch (key) {
                case "dcn": {
                    cp.addResourceSetProcessor(new DcnSerializer(cfg));
                    break;
                }
                case "uiindex": {
                    cp.addResourceSetProcessor(new DCLUIIndexSerializer(cfg));
                    break;
                }
                case "verbose": {
                    cp.setVerbose(true);
                    break;
                }
                case "out": {
                    out = new File(cfg);
                    break;
                }
                case "multitenant": {
                    cp.setMtSupport(true);
                    break;
                }
                case "usingsupport": {
                    cp.setUsingSupport(true);
                    break;
                }
                case "multiple": {
                    cp.setMultiple(true);
                    break;
                }
                case "failOn": {
                    if (FAIL_ON_DEPRECATION.equals(cfg)) {
                        cp.setFailOnDeprecation(true);
                        break;
                    }
                    if (!FAIL_ON_WARNING.equals(cfg)) break;
                    cp.setFailOnWarning(true);
                    break;
                }
                case "compileTestToDcn": {
                    cp.addResourceSetProcessor(new DcnSerializer("testsOnly"));
                    cp.setRegoTestGeneration(false);
                }
            }
        }
        if (idx < args.length) {
            File dir = new File(args[idx]);
            cp.setDirectories(dir, out != null ? out : dir);
            return cp;
        }
        cp.setVerbose(true);
        OUT.println("Standalone DCL compiler - " + DCLBuildInformationTools.getVersionInfo());
        OUT.println("Arguments: [options] <path to dcl root folder>");
        return null;
    }

    private static class DCLCompilerParameterExt
    extends DCLCompilerParameter {
        private boolean multiple = false;
        private boolean failOnDeprecation = false;
        private boolean failOnWarning = false;

        private DCLCompilerParameterExt() {
        }

        public boolean isMultiple() {
            return this.multiple;
        }

        public void setMultiple(boolean multiple) {
            this.multiple = multiple;
        }

        public boolean isFailOnDeprecation() {
            return this.failOnDeprecation;
        }

        public void setFailOnDeprecation(boolean failOnDeprecation) {
            this.failOnDeprecation = failOnDeprecation;
        }

        public boolean isFailOnWarning() {
            return this.failOnWarning;
        }

        public void setFailOnWarning(boolean failOnWarning) {
            this.failOnWarning = failOnWarning;
        }
    }
}

