/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.generator;

import com.google.inject.Inject;
import com.sap.cloud.security.ams.dcl.DCLResourceHelper;
import com.sap.cloud.security.ams.dcl.DCLStringProcessing;
import com.sap.cloud.security.ams.dcl.DCLTools;
import com.sap.cloud.security.ams.dcl.DCLType;
import com.sap.cloud.security.ams.dcl.ResourceLocation;
import com.sap.cloud.security.ams.dcl.client.dcn.DataType;
import com.sap.cloud.security.ams.dcl.client.dcn.DcnBuilder;
import com.sap.cloud.security.ams.dcl.client.dcn.DcnContainer;
import com.sap.cloud.security.ams.dcl.client.dcn.DcnSchemaBuilder;
import com.sap.cloud.security.ams.dcl.client.dcn.Effect;
import com.sap.cloud.security.ams.dcl.client.dcn.Function;
import com.sap.cloud.security.ams.dcl.client.dcn.Policy;
import com.sap.cloud.security.ams.dcl.client.dcn.Rule;
import com.sap.cloud.security.ams.dcl.client.dcn.Schema;
import com.sap.cloud.security.ams.dcl.client.dcn.SchemaAttribute;
import com.sap.cloud.security.ams.dcl.client.dcn.TestAssertion;
import com.sap.cloud.security.ams.dcl.client.dcn.TestCase;
import com.sap.cloud.security.ams.dcl.client.dcn.TestInput;
import com.sap.cloud.security.ams.dcl.client.dcn.Use;
import com.sap.cloud.security.ams.dcl.client.el.AttributeName;
import com.sap.cloud.security.ams.dcl.client.el.Call;
import com.sap.cloud.security.ams.dcl.client.el.QualifiedName;
import com.sap.cloud.security.ams.dcl.client.el.QualifiedNamesBuilder;
import com.sap.cloud.security.ams.dcl.client.language.DataControlLanguageScanner;
import com.sap.cloud.security.ams.dcl.client.language.DataControlLanguageTools;
import com.sap.cloud.security.ams.dcl.client.language.TokenFormat;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.Annotation;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.Constant;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.DataControlLanguagePackage;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.Expression;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionAnd;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionArray;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionBetween;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionBoolean;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionCall;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionConstant;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionIdentifier;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionIn;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionIsNull;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionIsRestricted;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionLike;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionNull;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionNumber;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionOr;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionRelational;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionSpecialValue;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionString;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.FunctionDefinition;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.JMap;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.JMapEntry;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.JSONObject;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.JSONObjectEntry;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.NamedElement;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.PolicyDefinition;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.PolicyDocument;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.PolicyList;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.PolicyUse;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.Restriction;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.RoleRule;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaDefinition;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaMap;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaType;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.TestCaseInput;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.TestScenario;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerParameter;
import com.sap.cloud.security.ams.dcl.generator.DCLGeneratorTools;
import com.sap.cloud.security.ams.dcl.processors.DCLBaseSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class DCLToDcnHelper {
    private static final EReference EXPRESSION_CALL_DEFINITION = DataControlLanguagePackage.eINSTANCE.getExpressionCall_Left();
    private static final EReference POLICY_USE_POLICY = DataControlLanguagePackage.eINSTANCE.getPolicyUse_Policy();
    private static final QualifiedName QN_BROKEN = QualifiedName.create("--broken--");
    private static final AttributeName AN_BROKEN = AttributeName.create("--broken--");
    private static final AttributeName AN_APP = QualifiedNamesBuilder.toCachedIfAvailable(AttributeName.create("$app"));
    private static final AttributeName AN_ENV = QualifiedNamesBuilder.toCachedIfAvailable(AttributeName.create("$env"));
    @Inject
    private DCLResourceHelper resourceHelper;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    private final List<String> tempStrings = new ArrayList<String>();
    private final StringBuilder sb = new StringBuilder();
    private final DataControlLanguageScanner scanner = DataControlLanguageScanner.create(TokenFormat.DCL_IDENTIFIER);
    private static final Map<DCLType, DataType> DCL_TO_DCN_DATA_TYPE = new EnumMap<DCLType, DataType>(DCLType.class);

    static {
        DCL_TO_DCN_DATA_TYPE.put(DCLType.Boolean, DataType.Boolean);
        DCL_TO_DCN_DATA_TYPE.put(DCLType.BooleanArray, DataType.BooleanArray);
        DCL_TO_DCN_DATA_TYPE.put(DCLType.Number, DataType.Number);
        DCL_TO_DCN_DATA_TYPE.put(DCLType.NumberArray, DataType.NumberArray);
        DCL_TO_DCN_DATA_TYPE.put(DCLType.String, DataType.String);
        DCL_TO_DCN_DATA_TYPE.put(DCLType.StringArray, DataType.StringArray);
        DCL_TO_DCN_DATA_TYPE.put(DCLType.Structure, DataType.Structure);
    }

    public Object convert(Expression it) {
        return this.convertDCL(Objects.requireNonNull(it, "it must not be null"));
    }

    private Object convertDCL(EObject it) {
        if (it == null) {
            return null;
        }
        switch (it.eClass().getClassifierID()) {
            case 19: {
                ExpressionIdentifier o = (ExpressionIdentifier)it;
                String name = null;
                this.tempStrings.clear();
                EObject current = o.getSchemaAttribute();
                while (true) {
                    if (current instanceof SchemaMap) {
                        current = current.eContainer();
                    }
                    if (current instanceof SchemaType) {
                        current = current.eContainer();
                    }
                    if (!(current instanceof com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaAttribute)) break;
                    name = ((com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaAttribute)current).getName();
                    if (name == null) {
                        this.tempStrings.clear();
                        return AN_BROKEN;
                    }
                    this.tempStrings.add(name);
                    current = current.eContainer();
                }
                this.tempStrings.add(DCLStringProcessing.getSegmentType(name).toString());
                Collections.reverse(this.tempStrings);
                AttributeName an = AttributeName.create(this.tempStrings);
                this.tempStrings.clear();
                return an;
            }
            case 31: {
                ExpressionOr o = (ExpressionOr)it;
                ArrayList<Object> member = new ArrayList<Object>();
                for (Expression e : o.getOrList()) {
                    member.add(this.convert(e));
                }
                return Call.createFrom(Call.QualifiedNames.OR, member);
            }
            case 32: {
                ExpressionAnd o = (ExpressionAnd)it;
                ArrayList<Object> member = new ArrayList<Object>();
                for (Expression e : o.getAndList()) {
                    member.add(this.convert(e));
                }
                return Call.createFrom(Call.QualifiedNames.AND, member);
            }
            case 33: {
                ExpressionRelational o = (ExpressionRelational)it;
                return Call.create(DCLBaseSerializer.getRuntimeRelationalOperatorName(o.getOperator()), this.convert(o.getLeft()), this.convert(o.getRight()));
            }
            case 34: {
                QualifiedName qn;
                ExpressionLike o = (ExpressionLike)it;
                QualifiedName qualifiedName = qn = o.isNot() ? Call.QualifiedNames.NOT_LIKE : Call.QualifiedNames.LIKE;
                if (DCLTools.isEmpty(o.getEscape())) {
                    return Call.create(qn, this.convert(o.getLeft()), (Object)o.getPattern());
                }
                return Call.create(qn, this.convert(o.getLeft()), (Object)o.getPattern(), (Object)o.getEscape());
            }
            case 35: {
                ExpressionIn o = (ExpressionIn)it;
                QualifiedName qn = o.isNot() ? Call.QualifiedNames.NOT_IN : Call.QualifiedNames.IN;
                return Call.create(qn, this.convert(o.getLeft()), this.convert(o.getRight()));
            }
            case 36: {
                ExpressionBetween o = (ExpressionBetween)it;
                QualifiedName qn = o.isNot() ? Call.QualifiedNames.NOT_BETWEEN : Call.QualifiedNames.BETWEEN;
                return Call.create(qn, this.convert(o.getLeft()), this.convert(o.getLower()), this.convert(o.getUpper()));
            }
            case 37: {
                ExpressionIsNull o = (ExpressionIsNull)it;
                QualifiedName qn = o.isNot() ? Call.QualifiedNames.IS_NOT_NULL : Call.QualifiedNames.IS_NULL;
                return Call.create(qn, this.convert(o.getLeft()));
            }
            case 42: {
                ExpressionBoolean e = (ExpressionBoolean)it;
                return e.isValue();
            }
            case 43: {
                return null;
            }
            case 40: {
                ExpressionNumber o = (ExpressionNumber)it;
                return o.getValue().doubleValue();
            }
            case 41: {
                ExpressionString o = (ExpressionString)it;
                return o.getValue();
            }
            case 23: {
                ExpressionArray e = (ExpressionArray)it;
                ArrayList<Object> res = new ArrayList<Object>(e.getValues().size());
                for (Constant c : e.getValues()) {
                    res.add(this.convert(c));
                }
                return res;
            }
            case 20: {
                JMap e = (JMap)it;
                HashMap<String, Object> res = new HashMap<String, Object>();
                for (JMapEntry entry : e.getEntries()) {
                    this.convertJMapEntry(res, entry);
                }
                return res;
            }
            case 39: {
                ExpressionCall e = (ExpressionCall)it;
                Call res = Call.create(this.crossQN(e, EXPRESSION_CALL_DEFINITION, e.getLeft(), e.getLeft().getName()));
                return res;
            }
            case 38: {
                ExpressionIsRestricted e = (ExpressionIsRestricted)it;
                return e.isNotRestricted() ? Call.create(Call.QualifiedNames.NOT_RESTRICTED, this.convert(e.getLeft())) : Call.create(Call.QualifiedNames.RESTRICTED, this.convert(e.getLeft()));
            }
            case 45: {
                JSONObject e = (JSONObject)it;
                HashMap<String, Object> res = new HashMap<String, Object>();
                for (JSONObjectEntry entry : e.getEntries()) {
                    res.put(entry.getElement(), this.convert(entry.getValue()));
                }
                return res;
            }
        }
        throw new IllegalStateException("DCL Type not supported: " + it.getClass().getName());
    }

    private Map<String, Object> convertAnnotations(List<Annotation> it) {
        if (it == null || it.isEmpty()) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Annotation ann : it) {
            ExpressionConstant value = ann.getValue();
            result.put(ann.getId(), value == null ? Boolean.TRUE : this.convert(value));
        }
        return result;
    }

    private void convertJMapEntry(Map<String, Object> map, JMapEntry entry) {
        ExpressionConstant value = entry.getValue();
        if (value instanceof ExpressionNull) {
            return;
        }
        if (value instanceof ExpressionSpecialValue) {
            return;
        }
        map.put(entry.getSchemaAttribute().getName(), this.convert(value));
    }

    private String getAssignemtPolicyName(PolicyDefinition pd) {
        String name;
        org.eclipse.xtext.naming.QualifiedName qname = this.qualifiedNameProvider.getFullyQualifiedName(pd);
        this.sb.setLength(0);
        int i = 0;
        while (i < qname.getSegmentCount() - 1) {
            if (i > 0) {
                this.sb.append('.');
            }
            this.sb.append(qname.getSegment(i));
            ++i;
        }
        if (this.sb.length() > 0) {
            this.sb.append('.');
        }
        DataControlLanguageTools.appendQuotedString(this.sb, name, (name = qname.getLastSegment()).indexOf(46) == -1);
        String result = this.sb.toString();
        this.sb.setLength(0);
        return result;
    }

    public Object getExpectedResult(com.sap.cloud.security.ams.dcl.dataControlLanguage.TestCase tc, boolean convert) {
        if (tc.isDeny()) {
            return Boolean.FALSE;
        }
        if (tc.isGrant()) {
            return Boolean.TRUE;
        }
        if (tc.getExpression() != null) {
            if (convert) {
                return this.convert(tc.getExpression());
            }
            return tc.getExpression();
        }
        throw new IllegalStateException("Unknown state in TestCase. No GRANT, DENY or expression present.");
    }

    public List<String> convertPolicyList(PolicyList polList) {
        if (polList == null || DCLTools.isEmpty(polList.getPolicies())) {
            return null;
        }
        ArrayList<String> policyList = new ArrayList<String>();
        for (PolicyDefinition pdef : polList.getPolicies()) {
            policyList.add(this.getAssignemtPolicyName(pdef));
        }
        return policyList;
    }

    public TestInput getDcnTestInput(TestCaseInput it) {
        TestInput res = new TestInput().content(new HashMap<String, Object>()).ignores(new ArrayList<AttributeName>()).unknowns(new ArrayList<AttributeName>());
        if (it == null) {
            return res;
        }
        JMap jMap = it.getMap();
        if (jMap == null || jMap.getEntries().isEmpty()) {
            return res;
        }
        Map<String, Object> map = res.content();
        HashMap<String, Object> app = null;
        HashMap<String, Object> ext = null;
        for (JMapEntry e : jMap.getEntries()) {
            switch (DCLStringProcessing.getSegmentType(e.getSchemaAttribute().getName())) {
                case APP: {
                    if (app == null) {
                        app = new HashMap<String, Object>();
                        map.put("$app", app);
                    }
                    this.convertJMapEntry(app, e);
                    break;
                }
                case ENV: {
                    if (ext == null) {
                        ext = new HashMap<String, Object>();
                        map.put("$env", ext);
                    }
                    this.convertJMapEntry(ext, e);
                }
            }
        }
        if (DCLGeneratorTools.hasSpecialValue(it)) {
            for (JMapEntry e : jMap.getEntries()) {
                switch (DCLStringProcessing.getSegmentType(e.getSchemaAttribute().getName())) {
                    case APP: {
                        DCLToDcnHelper.fillSpecials(e, AttributeName.create("$app"), res);
                        break;
                    }
                    case ENV: {
                        DCLToDcnHelper.fillSpecials(e, AttributeName.create("$env"), res);
                    }
                }
            }
        }
        return res;
    }

    private static void fillSpecials(JMapEntry it, AttributeName an, TestInput testInput) {
        ExpressionConstant value = it.getValue();
        an = (AttributeName)an.append(it.getSchemaAttribute().getName());
        if (value instanceof ExpressionSpecialValue) {
            ExpressionSpecialValue sv = (ExpressionSpecialValue)value;
            if (sv.getValue().toUpperCase(Locale.US).equals("IGNORE")) {
                testInput.ignores().add(an);
            } else {
                testInput.unknowns().add(an);
            }
        }
        if (value instanceof JMap) {
            JMap e = (JMap)value;
            for (JMapEntry entry : e.getEntries()) {
                DCLToDcnHelper.fillSpecials(entry, an, testInput);
            }
        }
    }

    private List<String> getDCLNames(EObject eObject, EStructuralFeature feature, boolean addScope) {
        List<INode> nodes = NodeModelUtils.findNodesForFeature(eObject, feature);
        if (DCLTools.hasContent(nodes)) {
            String text = NodeModelUtils.getTokenText(nodes.get(0));
            if (text.indexOf(46) != -1) {
                this.scanner.input(text);
                this.scanner.skipWhitespace();
                return this.scanner.scanQualifiedName(addScope);
            }
            return Collections.singletonList(text);
        }
        return null;
    }

    private QualifiedName crossQN(EObject container, EStructuralFeature feature, EObject target, String name) {
        if (target.eIsProxy()) {
            List<String> names = this.getDCLNames(container, feature, false);
            if (names != null && names.size() == 1) {
                ResourceLocation location = this.resourceHelper.getResourceLocation(container.eResource());
                names = location.getFullQualifiedDCLArray(names.get(0));
            }
            return names == null ? QN_BROKEN : QualifiedName.create(names);
        }
        return this.QN(target, name);
    }

    private List<QualifiedName> QNs(PolicyList policyList) {
        return policyList == null ? null : DCLToDcnHelper.convert(policyList.getPolicies(), this::QN);
    }

    protected QualifiedName QN(NamedElement it) {
        return this.QN(it, it.getName());
    }

    private QualifiedName QN(EObject target, String name) {
        if (target.eIsProxy()) {
            throw new IllegalStateException();
        }
        ResourceLocation location = this.resourceHelper.getResourceLocation(target.eResource());
        if (location == null) {
            throw new IllegalStateException();
        }
        return location.getDclQualifiedName(name);
    }

    private DataType convert(DCLType type) {
        DataType res = DCL_TO_DCN_DATA_TYPE.get((Object)type);
        return Objects.requireNonNull(res, "Type must be known");
    }

    private static <T extends EObject, U> List<U> convert(List<T> coll, java.util.function.Function<T, U> converter) {
        if (DCLTools.isEmpty(coll)) {
            return Collections.emptyList();
        }
        ArrayList<U> res = new ArrayList<U>(coll.size());
        for (EObject el : coll) {
            res.add(converter.apply(el));
        }
        return res;
    }

    private static <T extends EObject, S extends EObject, U> List<U> convert(List<T> collA, List<S> collB, java.util.function.Function<T, U> converterA, java.util.function.Function<S, U> converterB) {
        if (DCLTools.isEmpty(collA) && DCLTools.isEmpty(collB)) {
            return Collections.emptyList();
        }
        ArrayList<U> res = new ArrayList<U>(collA.size() + collB.size());
        for (EObject el : collA) {
            res.add(converterA.apply(el));
        }
        for (EObject el : collB) {
            res.add(converterB.apply(el));
        }
        return res;
    }

    public List<TestCase> convertTestCases(PolicyDocument it) {
        if (it == null) {
            return null;
        }
        return DCLToDcnHelper.convert(it.getTestScenarios(), this::convert);
    }

    public DcnContainer convert(PolicyDocument it) {
        if (it == null) {
            return null;
        }
        return new DcnContainer().version(1).policies(DCLToDcnHelper.convert(it.getPolicies(), this::convert)).functions(DCLToDcnHelper.convert(it.getFunctions(), this::convert)).testCases(DCLToDcnHelper.convert(it.getTestScenarios(), this::convert)).schemas(it.getSchema() == null ? null : Collections.singletonList(this.convert(it.getSchema()))).userData(it);
    }

    private Policy convert(PolicyDefinition it) {
        return ((Policy)new Policy().qualifiedName(this.QN(it)).description(DCLTools.getFirstStringAnnotation(it, "description")).defaultPolicy(DCLTools.isDefault(it)).internal(DCLTools.isInternal(it)).rules(DCLToDcnHelper.convert(it.getRules(), it.getRoleRules(), this::convert, this::convert)).uses(DCLToDcnHelper.convert(it.getUses(), this::convert)).annotations((Map)this.convertAnnotations(it.getAnnotations()))).userData(it);
    }

    private Function convert(FunctionDefinition it) {
        DCLType dataType = DCLType.fromDataType(it.getDataType(), false);
        return ((Function)new Function().qualifiedName(this.QN(it)).returnType(this.convert(dataType)).result(this.convert(it.getResult())).annotations((Map)this.convertAnnotations(it.getAnnotations()))).userData(it);
    }

    private Schema convert(SchemaDefinition it) {
        DcnSchemaBuilder sb = DCLTools.isEmpty(it.getName()) ? DcnBuilder.schema() : DcnBuilder.tenantSchema(this.QN(it, null), it.getName());
        Schema schema = sb.build().userData(it);
        schema.annotations((Map)this.convertAnnotations(it.getAnnotations()));
        SchemaAttribute rootAtt = schema.definition();
        SchemaAttribute attApp = null;
        SchemaAttribute attEnv = null;
        rootAtt.nested(new HashMap<String, SchemaAttribute>());
        for (com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaAttribute e : it.getEntries()) {
            switch (DCLStringProcessing.getSegmentType(e.getName())) {
                case APP: {
                    if (attApp == null) {
                        attApp = DCLToDcnHelper.new_DcnSchemaAttribute(AN_APP, DataType.Structure);
                        rootAtt.nested().put("$app", attApp);
                    }
                    this.fill(attApp, e);
                    break;
                }
                case ENV: {
                    if (attEnv == null) {
                        attEnv = DCLToDcnHelper.new_DcnSchemaAttribute(AN_ENV, DataType.Structure);
                        rootAtt.nested().put("$env", attEnv);
                    }
                    this.fill(attEnv, e);
                }
            }
        }
        return schema;
    }

    private void fill(SchemaAttribute parent, com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaAttribute it) {
        String name = it.getName();
        if (DCLTools.isEmpty(name)) {
            return;
        }
        DCLType type = DCLTools.getExpressionType(it);
        if (!type.isSchemaType()) {
            return;
        }
        SchemaAttribute att = ((SchemaAttribute)DCLToDcnHelper.new_DcnSchemaAttribute((AttributeName)parent.attributeName().append(name), this.convert(type)).annotations((Map)this.convertAnnotations(it.getAnnotations()))).userData(it);
        if (parent.nested() == null) {
            parent.nested(new HashMap<String, SchemaAttribute>());
        }
        parent.nested().put(name, att);
        if (att.type() == DataType.Structure) {
            for (com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaAttribute nest : it.getType().getNested().getEntries()) {
                this.fill(att, nest);
            }
        }
    }

    private static SchemaAttribute new_DcnSchemaAttribute(AttributeName an, DataType type) {
        return new SchemaAttribute().attributeName(an).type(type);
    }

    private TestCase convert(TestScenario it) {
        return ((TestCase)new TestCase().qualifiedName(this.QN(it)).testAssertions(DCLToDcnHelper.convert(it.getTestCases(), this::convert)).annotations((Map)this.convertAnnotations(it.getAnnotations()))).userData(it);
    }

    private TestAssertion convert(com.sap.cloud.security.ams.dcl.dataControlLanguage.TestCase it) {
        return ((TestAssertion)new TestAssertion().actions(DCLBaseSerializer.getNames(it.getActions())).resources(DCLBaseSerializer.getNames(it.getResources())).policies(this.QNs(it.getPolicyList())).scopeFilter(this.QNs(it.getScopeFilter())).testInputs(DCLToDcnHelper.convert(it.getTestCaseInputs(), this::convert)).expect(this.getExpectedResult(it, true)).annotations((Map)this.convertAnnotations(it.getAnnotations()))).userData(it);
    }

    private TestInput convert(TestCaseInput it) {
        if (it.getMap() == null) {
            return null;
        }
        return this.getDcnTestInput(it).userData(it);
    }

    private Use convert(PolicyUse it) {
        return new Use().qualifiedPolicyName(this.crossQN(it, POLICY_USE_POLICY, it.getPolicy(), it.getPolicy().getName())).restrictions(DCLToDcnHelper.convert(it.getRestrictions(), this::convert)).userData(it);
    }

    private Rule convert(com.sap.cloud.security.ams.dcl.dataControlLanguage.Rule it) {
        return ((Rule)new Rule().effect(Effect.GRANT).actions(DCLBaseSerializer.getNames(it.getActions())).resources(DCLBaseSerializer.getNames(it.getResources())).condition(this.convertDCL(it.getCondition())).annotations((Map)this.convertAnnotations(it.getAnnotations()))).userData(it);
    }

    private Rule convert(RoleRule it) {
        return new Rule().effect(Effect.GRANT).actions(DCLBaseSerializer.getNames(it.getRoles())).resources(Arrays.asList("$SCOPES")).condition(this.convertDCL(it.getCondition())).role(true).userData(it);
    }

    private List<Call> convert(Restriction it) {
        return DCLToDcnHelper.convert(it.getParameter(), this::convert);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, Object> grantMapPath(Map<String, Object> root, String ... path) {
        Map<String, Object> current = root;
        String[] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            if (current.containsKey(p)) {
                Object val = current.get(p);
                if (!(val instanceof Map)) throw new IllegalStateException("Element not a map");
                current = (Map)val;
            } else {
                HashMap temp = new HashMap();
                current.put(p, temp);
                current = temp;
            }
            ++n2;
        }
        return current;
    }

    public void addTestCaseLocations(DcnContainer container, DCLCompilerParameter cp) {
        if (DCLTools.hasContent(container.testCases())) {
            if (container.metadata() == null) {
                container.metadata(new HashMap<String, Object>());
            }
            for (TestCase tc : container.testCases()) {
                int[] positions;
                Map<String, Object> testCase = DCLToDcnHelper.grantMapPath(container.metadata(), "$dcn", "testCases", tc.qualifiedName().toEncodedString());
                if (!(tc.userData() instanceof EObject)) continue;
                EObject eObj = (EObject)tc.userData();
                String sourceFile = DCLTools.getSourceFile(cp, eObj.eResource());
                if (DCLTools.hasContent(sourceFile)) {
                    testCase.put("srcFile", sourceFile);
                }
                if ((positions = DCLTools.getSourcePosition(eObj)) != null) {
                    testCase.put("srcPosition", positions);
                }
                if (!DCLTools.hasContent(tc.testAssertions())) continue;
                ArrayList testAssertions = new ArrayList(tc.testAssertions().size());
                for (TestAssertion ta : tc.testAssertions()) {
                    HashMap<String, int[]> testAssertion = new HashMap<String, int[]>();
                    if (ta.userData() instanceof EObject && (positions = DCLTools.getSourcePosition(eObj = (EObject)ta.userData())) != null) {
                        testAssertion.put("srcPosition", positions);
                    }
                    testAssertions.add(testAssertion);
                }
                testCase.put("testAssertions", testAssertions);
            }
        }
    }
}

