/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.generator;

import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.inject.Inject;
import com.sap.cloud.security.ams.dcl.DCLBuildInformationTools;
import com.sap.cloud.security.ams.dcl.DCLMtTools;
import com.sap.cloud.security.ams.dcl.DCLNameTools;
import com.sap.cloud.security.ams.dcl.DCLResourceHelper;
import com.sap.cloud.security.ams.dcl.DCLStringProcessing;
import com.sap.cloud.security.ams.dcl.DCLTools;
import com.sap.cloud.security.ams.dcl.LikeRegexConverter;
import com.sap.cloud.security.ams.dcl.ResourceLocation;
import com.sap.cloud.security.ams.dcl.client.commons.Parameter;
import com.sap.cloud.security.ams.dcl.client.language.DataControlLanguageTools;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.Constant;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.DataControlLanguagePackage;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.DataType;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.Expression;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionAnd;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionArray;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionBetween;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionBoolean;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionCall;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionConstant;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionIdentifier;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionIn;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionIsNull;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionIsRestricted;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionLike;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionNull;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionNumber;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionOr;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionRelational;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionSpecialValue;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionString;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.IDList;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.JMap;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.JMapEntry;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.PolicyDefinition;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.PolicyDocument;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.PolicyList;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.PolicyUse;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.Restriction;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.RoleList;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.RoleRule;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.Rule;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaDefinition;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.TestCase;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.TestCaseInput;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.TestScenario;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerResult;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerResultAccessor;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerTools;
import com.sap.cloud.security.ams.dcl.generator.DCLGeneratorTools;
import com.sap.cloud.security.ams.dcl.generator.DCLNameType;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class DataControlLanguageGenerator
extends AbstractGenerator {
    private static final Logger LOG = Logger.getLogger(DataControlLanguageGenerator.class);
    private static final Parameter.PropertyScope DCL_SCOPE = Parameter.propertyScope("com.sap.dcl", "opa");
    private static final boolean BF_REGO_SELF_RELATION = DCL_SCOPE.create("fixREGOSelfRelation", true).getValue();
    @Inject
    @Extension
    private IQualifiedNameProvider _iQualifiedNameProvider;
    @Inject
    private DCLNameTools dclNameTools;
    @Inject
    private LikeRegexConverter likeConverter;
    @Inject
    private DCLResourceHelper dclResourceHelper;
    @Inject
    private DCLCompilerResultAccessor cra;
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;
    @Inject
    private IContainer.Manager containerManager;
    private ResourceLocation resourceLoc;
    private boolean mtSupport;
    private boolean isGlobalGeneration;
    private final StringBuilder sb = new StringBuilder(256);
    private String tenant = null;
    private int nestedTempIndex;
    private PolicyDefinition currentPolicy;
    private String currentPolicyName;
    private String currentPolicyNameEscaped;
    private int currentRuleIndex;
    private Restriction currentRestriction;
    private static final Pattern ASCII_NAME_PATTERN = Pattern.compile("([a-zA-Z_][a-zA-Z_0-9]*)|(\"([a-zA-Z_][a-zA-Z_0-9]*)\")");
    private static final Pattern ASCII_REPLACE_PATTERN = Pattern.compile("[^a-zA-Z_0-9]");
    private Map<String, String> encodedName = new HashMap<String, String>();
    private final Map<List<String>, String> knownExpressions = new HashMap<List<String>, String>();
    private final Set<String> knownPolicies = new HashSet<String>();
    private final StringBuilder nestedExpressions = new StringBuilder(1024);
    private int subexpression_idx;
    private static final ImmutableMap<String, String> OPERATOR_MAP = new ImmutableMap.Builder<String, String>().put("=", "==").put("<>", "!=").build();

    @Override
    public void doGenerate(Resource resource, IFileSystemAccess2 fsa, IGeneratorContext context) {
        this.knownExpressions.clear();
        this.knownPolicies.clear();
        this.tenant = null;
        EObject _head = IterableExtensions.head(resource.getContents());
        PolicyDocument pd = (PolicyDocument)_head;
        this.resourceLoc = this.dclResourceHelper.createResourceLocation(resource);
        boolean _hasIssue = this.resourceLoc.hasIssue();
        if (_hasIssue) {
            return;
        }
        DCLCompilerResult compileResult = this.cra.get();
        this.isGlobalGeneration = compileResult != null && compileResult.getCompilerParameter().isGlobalGeneration();
        boolean genLocal = compileResult == null || compileResult.getCompilerParameter().isGenerateLocalPackage();
        this.mtSupport = DCLMtTools.isMtSupport(this.cra);
        if (pd != null) {
            if (!genLocal && this.resourceLoc.isInLocalPackage()) {
                return;
            }
            boolean _hasContent = DCLTools.hasContent(this.resourceLoc.getDclPackage());
            if (_hasContent) {
                Resource _packageReferenceResource;
                boolean _tripleEquals;
                SchemaDefinition packageSchema;
                if (this.mtSupport && (packageSchema = this.getTenantPackageSchema(resource)) != null) {
                    this.tenant = packageSchema.getName();
                }
                boolean generateApiAndDisp = false;
                generateApiAndDisp = this.isGlobalGeneration ? (_tripleEquals = resource == (_packageReferenceResource = DCLCompilerTools.getPackageReferenceResource(resource))) : true;
                if (generateApiAndDisp) {
                    String _relativePath = this.resourceLoc.getRelativePath();
                    String _plus = _relativePath + String.valueOf(Character.valueOf('/'));
                    String apiFilePath = _plus + "_dcl_api.rego";
                    String _relativePath_1 = this.resourceLoc.getRelativePath();
                    String _plus_1 = _relativePath_1 + String.valueOf(Character.valueOf('/'));
                    String dispFilePath = _plus_1 + "_dcl_disp.rego";
                    fsa.generateFile(apiFilePath, this.compileDCLPackageAPI(resource));
                    fsa.generateFile(dispFilePath, this.compileDCLPackageDisp(resource));
                }
            }
            String relName = this.resourceLoc.getRelativeDocumentName();
            boolean _hasContent_1 = DCLTools.hasContent(pd.getPolicies());
            if (_hasContent_1) {
                fsa.generateFile(relName + ".rego", this.compilePolicyDocument(pd));
            }
            if (DCLTools.hasContent(pd.getTestScenarios()) && (compileResult == null || compileResult.getCompilerParameter().isRegoTestGeneration())) {
                fsa.generateFile(relName + "_dcl_test.rego", this.compilePolicyDocumentTests(pd));
            }
        }
    }

    public CharSequence checkPolicyAssignment() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("__pol[_] == \"");
        String _dclPackage = this.resourceLoc.getDclPackage();
        _builder.append(_dclPackage);
        _builder.append(".");
        _builder.append(this.currentPolicyNameEscaped);
        _builder.append("\"");
        return _builder;
    }

    public String regoName(Rule it, String name) {
        DCLNameType _xifexpression = null;
        boolean _isDeny = DCLTools.isDeny(it);
        _xifexpression = _isDeny ? DCLNameType.RULE_DENY : DCLNameType.RULE_GRANT;
        return this.regoName(_xifexpression, name);
    }

    public String regoName(RoleRule it, String name) {
        DCLNameType _xifexpression = null;
        boolean _isDeny = DCLTools.isDeny(it);
        _xifexpression = _isDeny ? DCLNameType.RULE_DENY : DCLNameType.RULE_GRANT;
        return this.regoName(_xifexpression, name);
    }

    public void appendPath(StringBuilder sb, QualifiedName qname) {
        int i = 0;
        while (i < qname.getSegmentCount() - 1) {
            boolean _greaterThan;
            int _length = sb.length();
            boolean bl = _greaterThan = _length > 0;
            if (_greaterThan) {
                sb.append(".");
            }
            sb.append(qname.getSegment(i));
            ++i;
        }
    }

    public String regoFQName(DCLNameType nameType, QualifiedName qname) {
        boolean _not;
        this.sb.setLength(0);
        boolean _isSamePackage = this.resourceLoc.isSamePackage(qname);
        boolean bl = _not = !_isSamePackage;
        if (_not) {
            this.sb.append("data");
            this.appendPath(this.sb, qname);
            this.sb.append(".__disp.");
        }
        this.appendRegoName(this.sb, nameType, qname.getLastSegment());
        return this.sb.toString();
    }

    public String createAssignemtPolicyName(PolicyDefinition pd) {
        String name;
        int _indexOf;
        boolean _greaterThan;
        QualifiedName qname = this._iQualifiedNameProvider.getFullyQualifiedName(pd);
        this.sb.setLength(0);
        this.appendPath(this.sb, qname);
        int _length = this.sb.length();
        boolean bl = _greaterThan = _length > 0;
        if (_greaterThan) {
            this.sb.append(".");
        }
        boolean _equals = (_indexOf = (name = qname.getLastSegment()).indexOf(".")) == -1;
        DataControlLanguageTools.appendQuotedString(this.sb, name, _equals);
        return this.sb.toString();
    }

    public StringBuilder appendRegoName(StringBuilder sb, DCLNameType nameType, String name) {
        StringBuilder _xblockexpression = null;
        boolean allAscII = ASCII_NAME_PATTERN.matcher(name).matches();
        if (!allAscII && !Objects.equals((Object)nameType, (Object)DCLNameType.TEST_SCENARIO)) {
            sb.append("_");
        }
        sb.append(nameType.getPrefix());
        if (nameType != null) {
            switch (nameType) {
                case EXPRESSSION: {
                    ++this.subexpression_idx;
                    sb.append(this.resourceLoc.getDocumentName());
                    sb.append("_dcl_");
                    sb.append(this.subexpression_idx);
                    sb.append("_");
                    break;
                }
            }
        }
        StringBuilder _xifexpression = null;
        if (allAscII) {
            _xifexpression = sb.append(name);
        } else {
            StringBuilder _xblockexpression_1 = null;
            Function<String, String> _function = n -> {
                String _replaceAll = ASCII_REPLACE_PATTERN.matcher((CharSequence)n).replaceAll("");
                String _plus = _replaceAll + "_";
                HashCode _hashString = Hashing.sha1().hashString((CharSequence)n, StandardCharsets.UTF_8);
                return _plus + String.valueOf(_hashString);
            };
            String n2 = this.encodedName.computeIfAbsent(name, _function);
            _xifexpression = _xblockexpression_1 = sb.append(n2);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String regoName(DCLNameType nameType, String name) {
        this.sb.setLength(0);
        this.appendRegoName(this.sb, nameType, name);
        return this.sb.toString();
    }

    public String createSubExpression(List<String> branches) {
        String subName = this.knownExpressions.get(branches);
        if (subName == null) {
            subName = this.regoName(DCLNameType.EXPRESSSION, this.currentPolicyName);
            this.knownExpressions.put(branches, subName);
            StringConcatenation _builder = new StringConcatenation();
            _builder.newLine();
            for (String el : branches) {
                _builder.append(subName);
                _builder.append(" {");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append(el, "    ");
                _builder.newLineIfNotEmpty();
                _builder.append("}");
                _builder.newLine();
            }
            this.nestedExpressions.insert(0, _builder);
        }
        return subName;
    }

    public String createSubExpression(String eLeft) {
        return this.createSubExpression(Collections.singletonList(eLeft));
    }

    public String createSubExpression(String eLeft, String eRight) {
        return this.createSubExpression(Arrays.asList(eLeft, eRight));
    }

    public String compileSubexpressions() {
        String res = this.nestedExpressions.toString();
        this.nestedExpressions.setLength(0);
        return res;
    }

    public boolean isEmptyIDList(IDList nl) {
        return nl == null || nl.isStar() || nl.getNames() == null || nl.getNames().isEmpty();
    }

    public boolean isEmptyIDList(RoleList rl) {
        return rl == null || rl.getNames() == null || rl.getNames().isEmpty();
    }

    public CharSequence compileIDList(String name, IDList nl) {
        CharSequence _xblockexpression = null;
        boolean _isEmptyIDList = this.isEmptyIDList(nl);
        if (_isEmptyIDList) {
            return "";
        }
        CharSequence _xifexpression = null;
        int _length = ((Object[])Conversions.unwrapArray(nl.getNames(), Object.class)).length;
        boolean _equals = _length == 1;
        _xifexpression = _equals ? this.compileID(name, (String)nl.getNames().get(0)) : this.compileIDs(name, nl.getNames());
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public CharSequence compileIDList(String name, RoleList nl) {
        CharSequence _xblockexpression = null;
        boolean _isEmptyIDList = this.isEmptyIDList(nl);
        if (_isEmptyIDList) {
            return "";
        }
        CharSequence _xifexpression = null;
        int _length = ((Object[])Conversions.unwrapArray(nl.getNames(), Object.class)).length;
        boolean _equals = _length == 1;
        _xifexpression = _equals ? this.compileID(name, (String)nl.getNames().get(0)) : this.compileIDs(name, nl.getNames());
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public CharSequence compileID(String name, String id) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\"");
        String _regoEscape = this.regoEscape(id);
        _builder.append(_regoEscape);
        _builder.append("\" == input[\"");
        _builder.append("$dcl");
        _builder.append("\"].");
        _builder.append(name);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence compileIDs(String name, EList<String> ids) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("[");
        boolean _hasElements = false;
        for (String n : ids) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate(", ", "");
            }
            _builder.append("\"");
            String _regoEscape = this.regoEscape(n);
            _builder.append(_regoEscape);
            _builder.append("\"");
        }
        _builder.append("][_] == input[\"");
        _builder.append("$dcl");
        _builder.append("\"].");
        _builder.append(name);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence header() {
        return this.header(false);
    }

    public CharSequence header(boolean disp) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("# Generated by dcl-compiler: ");
        String _versionInfo = DCLBuildInformationTools.getVersionInfo();
        _builder.append(_versionInfo);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("package ");
        String _dclPackage = this.resourceLoc.getDclPackage();
        _builder.append(_dclPackage);
        if (disp) {
            _builder.append(".__disp");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence compileDCLPackageDisp(Resource resource) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _header = this.header(true);
        _builder.append(_header);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        if (this.isGlobalGeneration) {
            _builder.append("__nameMap := {");
            _builder.newLine();
            List<PolicyDefinition> _allPackagePolicies = this.allPackagePolicies(resource);
            boolean _hasElements = false;
            for (PolicyDefinition pd : _allPackagePolicies) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate(",", "");
                }
                boolean _isDefault = DCLTools.isDefault(pd);
                if (_isDefault) {
                    _builder.append("# ");
                }
                _builder.append("\"");
                String _regoEscape = this.regoEscape(DCLStringProcessing.createQualifiedPolicy(this.resourceLoc.getDclPackage(), pd.getName()));
                _builder.append(_regoEscape);
                _builder.append("\": \"");
                String _regoName = this.regoName(DCLNameType.RULE_GRANT, pd.getName());
                _builder.append(_regoName);
                _builder.append("\"");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("}");
            _builder.newLine();
        } else {
            _builder.append("__resolveName(polName) = sourceName {");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("false");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("sourceName := \"\" # for type inference");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("__defaultPol {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("false");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence compileDCLPackageAPI(Resource resource) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _header = this.header();
        _builder.append(_header);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import data.");
        String _dclPackage = this.resourceLoc.getDclPackage();
        _builder.append(_dclPackage);
        _builder.append(".__disp");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("__pol = x {");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("x := input[\"");
        _builder.append("$dcl", "  ");
        _builder.append("\"].");
        _builder.append("policies", "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("} else = x {");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("dcl_utp  := input[\"");
        _builder.append("$dcl", "  ");
        _builder.append("\"].");
        _builder.append("principal2policies", "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("data_utp := data.");
        _builder.append("principal2policies", "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("walk(data_utp,[dcl_utp, x])");
        _builder.newLine();
        _builder.append("} else = x {");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("dcl_utp  := input[\"");
        _builder.append("$dcl", "  ");
        _builder.append("\"].");
        _builder.append("principal2policies", "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("data_utp := data.");
        _builder.append("principal2policies", "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("x := []");
        _builder.newLine();
        _builder.append("} else = x {");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("not input[\"");
        _builder.append("$dcl", "  ");
        _builder.append("\"].");
        _builder.append("principal2policies", "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("x := []");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("__polFilter = x {");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("x := input[\"");
        _builder.append("$dcl", "  ");
        _builder.append("\"].");
        _builder.append("scopeFilter", "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("} else = null");
        _builder.newLine();
        _builder.newLine();
        _builder.append("__dclerror = x {");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("not __pol");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("x := {\"$dclerror\": -102, \"message\": \"Cannot determine assigned policies\"} ");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("__callOrDefault(policies) {");
        _builder.newLine();
        if (this.mtSupport && this.tenant != null) {
            _builder.append("  ");
            _builder.append("\"");
            String _regoEscape = this.regoEscape(this.tenant);
            _builder.append(_regoEscape, "  ");
            _builder.append("\" == input[\"");
            _builder.append("$dcl", "  ");
            _builder.append("\"].");
            _builder.append("tenant", "  ");
            _builder.append(" ");
            _builder.newLineIfNotEmpty();
        }
        if (this.isGlobalGeneration) {
            _builder.append("  ");
            _builder.append("p := __disp.__nameMap[ policies[_] ]");
            _builder.newLine();
        } else {
            _builder.append("  ");
            _builder.append("p := __disp.__resolveName( policies[_] )");
            _builder.newLine();
        }
        _builder.append("  ");
        _builder.append("__disp[ p ]");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append("__callOrDefault(_) {");
        _builder.newLine();
        if (this.mtSupport && this.tenant != null) {
            _builder.append("  ");
            _builder.append("\"");
            String _regoEscape_1 = this.regoEscape(this.tenant);
            _builder.append(_regoEscape_1, "  ");
            _builder.append("\" == input[\"");
            _builder.append("$dcl", "  ");
            _builder.append("\"].");
            _builder.append("tenant", "  ");
            _builder.append(" ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("  ");
        _builder.append("__disp.__defaultPol");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("__filter( null ) {");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("true");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append("__filter( filter ) {");
        _builder.newLine();
        if (this.mtSupport && this.tenant != null) {
            _builder.append("  ");
            _builder.append("\"");
            String _regoEscape_2 = this.regoEscape(this.tenant);
            _builder.append(_regoEscape_2, "  ");
            _builder.append("\" == input[\"");
            _builder.append("$dcl", "  ");
            _builder.append("\"].");
            _builder.append("tenant", "  ");
            _builder.append(" ");
            _builder.newLineIfNotEmpty();
        }
        if (this.isGlobalGeneration) {
            _builder.append("  ");
            _builder.append("f := __disp.__nameMap[ filter[_] ]");
            _builder.newLine();
        } else {
            _builder.append("  ");
            _builder.append("f := __disp.__resolveName( filter[_] )");
            _builder.newLine();
        }
        _builder.append("  ");
        _builder.append("__disp[ f ]");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("__grant(policies, filter) {");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("__filter(filter)");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("__callOrDefault(policies)");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        if (this.mtSupport && this.tenant != null) {
            _builder.append("__allowTest { __grant(__pol, __polFilter) }");
            _builder.newLine();
            _builder.append("__allowTestInput( val ) = result {");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("result := object.union( val, {\"");
            _builder.append("$dcl", "  ");
            _builder.append("\": {\"");
            _builder.append("tenant", "  ");
            _builder.append("\": \"");
            String _regoEscape_3 = this.regoEscape(this.tenant);
            _builder.append(_regoEscape_3, "  ");
            _builder.append("\" } } )");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# <API>");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("ping := true");
        _builder.newLine();
        _builder.newLine();
        _builder.append("allow    { __grant(__pol, __polFilter) }");
        _builder.newLine();
        _builder.append("else = x { x := __dclerror }");
        _builder.newLine();
        _builder.append("else = x { x := false }");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("allowAction = x {");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("not input[\"");
        _builder.append("$dcl", "  ");
        _builder.append("\"].");
        _builder.append("resource", "  ");
        _builder.append(" ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("x := allow");
        _builder.newLine();
        _builder.append("} else = x {");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("i := input[\"");
        _builder.append("$dcl", "  ");
        _builder.append("\"].");
        _builder.append("resource", "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("x := {\"$dclerror\": -103, \"message\": \"");
        _builder.append("resource", "  ");
        _builder.append(" must not be set for allowAction\"} ");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("allowPartial { __grant(__pol, __polFilter) }");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# </API>");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        return _builder;
    }

    public SchemaDefinition getTenantPackageSchema(Resource resource) {
        IResourceDescriptions resourceDescriptions = this.resourceDescriptionsProvider.getResourceDescriptions(resource);
        IResourceDescription resourceDescription = resourceDescriptions.getResourceDescription(resource.getURI());
        List<IContainer> visibleContainers = this.containerManager.getVisibleContainers(resourceDescription, resourceDescriptions);
        for (IContainer c : visibleContainers) {
            Iterable<IEObjectDescription> _exportedObjects = c.getExportedObjects(DataControlLanguagePackage.eINSTANCE.getSchemaDefinition(), this.resourceLoc.getSchemaQualifiedName(), false);
            for (IEObjectDescription od : _exportedObjects) {
                boolean _not;
                EObject _resolve = EcoreUtil.resolve(od.getEObjectOrProxy(), resource);
                SchemaDefinition obj = (SchemaDefinition)_resolve;
                boolean _eIsProxy = obj.eIsProxy();
                boolean bl = _not = !_eIsProxy;
                if (!_not) continue;
                return obj;
            }
        }
        return null;
    }

    public List<PolicyDefinition> allPackagePolicies(Resource resource) {
        IResourceDescriptions resourceDescriptions = this.resourceDescriptionsProvider.getResourceDescriptions(resource);
        IResourceDescription resourceDescription = resourceDescriptions.getResourceDescription(resource.getURI());
        List<IContainer> visibleContainers = this.containerManager.getVisibleContainers(resourceDescription, resourceDescriptions);
        ArrayList<PolicyDefinition> res = new ArrayList<PolicyDefinition>();
        for (IContainer c : visibleContainers) {
            Iterable<IEObjectDescription> _exportedObjectsByType = c.getExportedObjectsByType(DataControlLanguagePackage.eINSTANCE.getPolicyDefinition());
            for (IEObjectDescription od : _exportedObjectsByType) {
                boolean _not;
                boolean _isSamePackage = this.resourceLoc.isSamePackage(od.getQualifiedName());
                if (!_isSamePackage) continue;
                EObject _resolve = EcoreUtil.resolve(od.getEObjectOrProxy(), resource);
                PolicyDefinition obj = (PolicyDefinition)_resolve;
                boolean _eIsProxy = obj.eIsProxy();
                boolean bl = _not = !_eIsProxy;
                if (!_not) continue;
                res.add(obj);
            }
        }
        return res;
    }

    protected CharSequence compileMapping(PolicyDocument it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        if (DCLTools.hasContent(it.getPolicies()) && !this.isGlobalGeneration) {
            _builder.append("__resolveName(polName) = sourceName {");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("nameMap := {");
            _builder.newLine();
            EList<PolicyDefinition> _policies = it.getPolicies();
            boolean _hasElements = false;
            for (PolicyDefinition pd : _policies) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate(",", "    ");
                }
                _builder.append("    ");
                boolean _isDefault = DCLTools.isDefault(pd);
                if (_isDefault) {
                    _builder.append("# ");
                }
                _builder.append("\"");
                String _regoEscape = this.regoEscape(DCLStringProcessing.createQualifiedPolicy(this.resourceLoc.getDclPackage(), pd.getName()));
                _builder.append(_regoEscape, "    ");
                _builder.append("\": \"");
                String _regoName = this.regoName(DCLNameType.RULE_GRANT, pd.getName());
                _builder.append(_regoName, "    ");
                _builder.append("\"");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("    ");
            _builder.append("}");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("sourceName := nameMap[polName]");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence compilePolicyDocument(PolicyDocument it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _header = this.header(true);
        _builder.append(_header);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _compileMapping = this.compileMapping(it);
        _builder.append(_compileMapping);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList<PolicyDefinition> _policies = it.getPolicies();
        for (PolicyDefinition pd : _policies) {
            CharSequence _compile = this.compile(pd);
            _builder.append(_compile);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence compilePolicyDocumentTests(PolicyDocument it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _header = this.header();
        _builder.append(_header);
        _builder.newLineIfNotEmpty();
        if (this.mtSupport) {
            Set<String> _listReferencedPackages = DCLMtTools.listReferencedPackages(it.getTestScenarios(), this.resourceLoc.getQualifiedName(), this.dclResourceHelper);
            for (String pkg : _listReferencedPackages) {
                _builder.append("__allowTest { data.");
                _builder.append(pkg);
                _builder.append(".__grant(__pol, __polFilter) }");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        EList<TestScenario> _testScenarios = it.getTestScenarios();
        for (TestScenario tc : _testScenarios) {
            CharSequence _compile = this.compile(tc);
            _builder.append(_compile);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _compile(PolicyDefinition it) {
        StringConcatenation _xblockexpression = null;
        this.currentPolicy = it;
        this.currentPolicyName = this.currentPolicy.getName();
        this.currentPolicyNameEscaped = this.regoEscape(this.currentPolicyName);
        this.subexpression_idx = 0;
        StringConcatenation _xtrycatchfinallyexpression = null;
        try {
            StringConcatenation _xblockexpression_1 = null;
            this.currentRuleIndex = 0;
            StringConcatenation _builder = new StringConcatenation();
            _builder.newLine();
            _builder.append("#");
            _builder.newLine();
            _builder.append("# POLICY ");
            _builder.append(this.currentPolicyNameEscaped);
            _builder.newLineIfNotEmpty();
            _builder.append("#");
            _builder.newLine();
            boolean _isDefault = DCLTools.isDefault(it);
            if (_isDefault) {
                _builder.append("__defaultPol = { ");
                String _regoName = this.regoName(DCLNameType.RULE_GRANT, it.getName());
                _builder.append(_regoName);
                _builder.append(" }");
                _builder.newLineIfNotEmpty();
            }
            if (DCLTools.hasContent(it.getRules()) || DCLTools.hasContent(it.getRoleRules()) || DCLTools.hasContent(it.getUses())) {
                EList<Rule> _rules = it.getRules();
                for (Rule g : _rules) {
                    CharSequence _compile = this.compile(g);
                    _builder.append(_compile);
                    _builder.newLineIfNotEmpty();
                }
                EList<RoleRule> _roleRules = it.getRoleRules();
                for (RoleRule r : _roleRules) {
                    CharSequence _compile_1 = this.compile(r);
                    _builder.append(_compile_1);
                    _builder.newLineIfNotEmpty();
                }
                EList<PolicyUse> _uses = it.getUses();
                for (PolicyUse u : _uses) {
                    CharSequence _compile_2 = this.compile(u);
                    _builder.append(_compile_2);
                    _builder.newLineIfNotEmpty();
                }
            } else {
                String _regoName_1 = this.regoName(DCLNameType.RULE_GRANT, this.currentPolicyName);
                _builder.append(_regoName_1);
                _builder.append(" { false }");
                _builder.newLineIfNotEmpty();
            }
            _xtrycatchfinallyexpression = _xblockexpression_1 = _builder;
        }
        finally {
            this.currentPolicy = null;
            this.currentPolicyName = null;
            this.currentPolicyNameEscaped = null;
        }
        _xblockexpression = _xtrycatchfinallyexpression;
        return _xblockexpression;
    }

    protected CharSequence _compile(ExpressionSpecialValue it) {
        throw new IllegalStateException("Cannot generate SpecialValues.");
    }

    protected CharSequence _compile(PolicyUse it) {
        return this.compilePolicyUse(it, true);
    }

    public CharSequence compilePolicyUse(PolicyUse it, boolean withNested) {
        PolicyDefinition usedPolicy = it.getPolicy();
        String usedPolicyName = usedPolicy.getName();
        String usedPolicyNameEscaped = this.regoEscape(usedPolicyName);
        QualifiedName usedPolicyFQName = this._iQualifiedNameProvider.getFullyQualifiedName(usedPolicy);
        boolean _isEmpty = it.getRestrictions().isEmpty();
        if (_isEmpty) {
            this.nestedTempIndex = 0;
            StringConcatenation _builder = new StringConcatenation();
            _builder.newLine();
            _builder.append("## ");
            _builder.append(this.currentPolicyNameEscaped);
            _builder.append(": USE ");
            _builder.append(usedPolicyNameEscaped);
            _builder.newLineIfNotEmpty();
            String _regoName = this.regoName(DCLNameType.RULE_GRANT, this.currentPolicyName);
            _builder.append(_regoName);
            _builder.append(" {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            String _regoFQName = this.regoFQName(DCLNameType.RULE_GRANT, usedPolicyFQName);
            _builder.append(_regoFQName, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
            String _compileSubexpressions = this.compileSubexpressions();
            _builder.append(_compileSubexpressions);
            _builder.newLineIfNotEmpty();
            return _builder;
        }
        Object res = "";
        int restrictionIdx = 0;
        EList<Restriction> _restrictions = it.getRestrictions();
        for (Restriction r : _restrictions) {
            ++restrictionIdx;
            this.currentRestriction = r;
            try {
                int usedGrantIndex = 0;
                EList<Rule> _rules = usedPolicy.getRules();
                for (Rule usedRule : _rules) {
                    boolean _tripleNotEquals;
                    ++usedGrantIndex;
                    this.nestedTempIndex = 0;
                    Object _res = res;
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append(this.currentPolicyNameEscaped);
                    _builder_1.append(": USE ");
                    _builder_1.append(usedPolicyNameEscaped);
                    _builder_1.append(" RESTRICT.");
                    _builder_1.append(restrictionIdx);
                    _builder_1.append(" (regenerate ## ");
                    _builder_1.append(usedPolicyNameEscaped);
                    _builder_1.append(": GRANT ");
                    _builder_1.append(usedGrantIndex);
                    _builder_1.append(")");
                    StringConcatenation _builder_2 = new StringConcatenation();
                    String _regoName_1 = this.regoName(DCLNameType.RULE_GRANT, this.currentPolicyName);
                    _builder_2.append(_regoName_1);
                    _builder_2.append(" {");
                    _builder_2.newLineIfNotEmpty();
                    _builder_2.append("    ");
                    _builder_2.append("## Original");
                    _builder_2.newLine();
                    _builder_2.append("    ");
                    CharSequence _compileIDList = this.compileIDList("action", usedRule.getActions());
                    _builder_2.append((Object)_compileIDList, "    ");
                    _builder_2.newLineIfNotEmpty();
                    _builder_2.append("    ");
                    CharSequence _compileIDList_1 = this.compileIDList("resource", usedRule.getResources());
                    _builder_2.append((Object)_compileIDList_1, "    ");
                    _builder_2.newLineIfNotEmpty();
                    Expression _condition = usedRule.getCondition();
                    boolean bl = _tripleNotEquals = _condition != null;
                    if (_tripleNotEquals) {
                        _builder_2.append("    ");
                        _builder_2.append("# WHERE with applied restrictions");
                        _builder_2.newLine();
                        _builder_2.append("    ");
                        CharSequence _compile = this.compile(usedRule.getCondition());
                        _builder_2.append((Object)_compile, "    ");
                        _builder_2.newLineIfNotEmpty();
                    }
                    if (!DCLTools.isDeny(usedRule) && DCLTools.hasRule(usedPolicy, true)) {
                        _builder_2.append("    ");
                        _builder_2.append("not ");
                        String _regoFQName_1 = this.regoFQName(DCLNameType.RULE_DENY, usedPolicyFQName);
                        _builder_2.append(_regoFQName_1, "    ");
                        _builder_2.newLineIfNotEmpty();
                    }
                    _builder_2.append("}");
                    _builder_2.newLine();
                    CharSequence _renderPolicy = this.renderPolicy(_builder_1.toString(), _builder_2.toString());
                    res = (String)_res + String.valueOf(_renderPolicy);
                }
                EList<RoleRule> _roleRules = usedPolicy.getRoleRules();
                for (RoleRule usedRule_1 : _roleRules) {
                    boolean _tripleNotEquals;
                    ++usedGrantIndex;
                    this.nestedTempIndex = 0;
                    Object _res = res;
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append(this.currentPolicyNameEscaped);
                    _builder_1.append(": USE ");
                    _builder_1.append(usedPolicyNameEscaped);
                    _builder_1.append(" RESTRICT.");
                    _builder_1.append(restrictionIdx);
                    _builder_1.append(" (regenerate ## ");
                    _builder_1.append(usedPolicyNameEscaped);
                    _builder_1.append(": GRANT ");
                    _builder_1.append(usedGrantIndex);
                    _builder_1.append(")");
                    StringConcatenation _builder_2 = new StringConcatenation();
                    String _regoName_1 = this.regoName(DCLNameType.RULE_GRANT, this.currentPolicyName);
                    _builder_2.append(_regoName_1);
                    _builder_2.append(" {");
                    _builder_2.newLineIfNotEmpty();
                    _builder_2.append("    ");
                    _builder_2.append("## Original");
                    _builder_2.newLine();
                    _builder_2.append("    ");
                    CharSequence _compileIDList = this.compileIDList("action", usedRule_1.getRoles());
                    _builder_2.append((Object)_compileIDList, "    ");
                    _builder_2.newLineIfNotEmpty();
                    _builder_2.append("    ");
                    CharSequence _compileID = this.compileID("resource", "$SCOPES");
                    _builder_2.append((Object)_compileID, "    ");
                    _builder_2.newLineIfNotEmpty();
                    Expression _condition = usedRule_1.getCondition();
                    boolean bl = _tripleNotEquals = _condition != null;
                    if (_tripleNotEquals) {
                        _builder_2.append("    ");
                        _builder_2.append("# WHERE with applied restrictions");
                        _builder_2.newLine();
                        _builder_2.append("    ");
                        CharSequence _compile = this.compile(usedRule_1.getCondition());
                        _builder_2.append((Object)_compile, "    ");
                        _builder_2.newLineIfNotEmpty();
                    }
                    if (!DCLTools.isDeny(usedRule_1) && DCLTools.hasRule(usedPolicy, true)) {
                        _builder_2.append("    ");
                        _builder_2.append("not ");
                        String _regoFQName_1 = this.regoFQName(DCLNameType.RULE_DENY, usedPolicyFQName);
                        _builder_2.append(_regoFQName_1, "    ");
                        _builder_2.newLineIfNotEmpty();
                    }
                    _builder_2.append("}");
                    _builder_2.newLine();
                    CharSequence _renderPolicy = this.renderPolicy(_builder_1.toString(), _builder_2.toString());
                    res = (String)_res + String.valueOf(_renderPolicy);
                }
            }
            finally {
                this.currentRestriction = null;
            }
        }
        if (withNested) {
            EList<PolicyUse> _uses = it.getPolicy().getUses();
            for (PolicyUse use : _uses) {
                String _res = res;
                CharSequence _compilePolicyUse = this.compilePolicyUse(use, false);
                res = _res + String.valueOf(_compilePolicyUse);
            }
        }
        return res;
    }

    public CharSequence renderPolicy(String header, String body) {
        StringConcatenation _xifexpression = null;
        boolean _add = this.knownPolicies.add(body);
        if (_add) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.newLine();
            _builder.append("## ");
            _builder.append(header);
            _builder.newLineIfNotEmpty();
            _builder.append(body);
            _builder.newLineIfNotEmpty();
            String _compileSubexpressions = this.compileSubexpressions();
            _builder.append(_compileSubexpressions);
            _builder.newLineIfNotEmpty();
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.newLine();
            _builder_1.append("## ");
            _builder_1.append(header);
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("## Skipped - already existing");
            _builder_1.newLine();
            _xifexpression = _builder_1;
        }
        return _xifexpression;
    }

    protected CharSequence _compile(Rule it) {
        boolean _tripleNotEquals;
        CharSequence _xblockexpression = null;
        int _currentRuleIndex = this.currentRuleIndex;
        this.currentRuleIndex = _currentRuleIndex + 1;
        this.nestedTempIndex = 0;
        this.nestedExpressions.setLength(0);
        boolean hasBody = it.getCondition() != null && !DCLTools.isDeny(it) && DCLTools.hasRule(this.currentPolicy, true) || !this.isEmptyIDList(it.getActions()) || !this.isEmptyIDList(it.getResources());
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(this.currentPolicyNameEscaped);
        _builder.append(".");
        _builder.append(this.currentRuleIndex);
        _builder.append(": ");
        boolean _isDeny = DCLTools.isDeny(it);
        if (_isDeny) {
            _builder.append("DENY");
        } else {
            _builder.append("GRANT");
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        String _regoName = this.regoName(it, this.currentPolicyName);
        _builder_1.append(_regoName);
        _builder_1.append(" {");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("    ");
        CharSequence _compileIDList = this.compileIDList("action", it.getActions());
        _builder_1.append((Object)_compileIDList, "    ");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("    ");
        CharSequence _compileIDList_1 = this.compileIDList("resource", it.getResources());
        _builder_1.append((Object)_compileIDList_1, "    ");
        _builder_1.newLineIfNotEmpty();
        Expression _condition = it.getCondition();
        boolean bl = _tripleNotEquals = _condition != null;
        if (_tripleNotEquals) {
            _builder_1.append("    ");
            _builder_1.append("# WHERE");
            _builder_1.newLine();
            _builder_1.append("    ");
            CharSequence _compile = this.compile(it.getCondition());
            _builder_1.append((Object)_compile, "    ");
            _builder_1.newLineIfNotEmpty();
        }
        if (!DCLTools.isDeny(it) && DCLTools.hasRule(this.currentPolicy, true)) {
            _builder_1.append("    ");
            _builder_1.append("not ");
            String _regoName_1 = this.regoName(DCLNameType.RULE_DENY, this.currentPolicyName);
            _builder_1.append(_regoName_1, "    ");
            _builder_1.newLineIfNotEmpty();
        }
        if (!hasBody) {
            _builder_1.append("    ");
            _builder_1.append("true");
            _builder_1.newLine();
        }
        _builder_1.append("}");
        _builder_1.newLine();
        _xblockexpression = this.renderPolicy(_builder.toString(), _builder_1.toString());
        return _xblockexpression;
    }

    protected CharSequence _compile(RoleRule it) {
        boolean _tripleNotEquals;
        CharSequence _xblockexpression = null;
        int _currentRuleIndex = this.currentRuleIndex;
        this.currentRuleIndex = _currentRuleIndex + 1;
        this.nestedTempIndex = 0;
        this.nestedExpressions.setLength(0);
        boolean hasBody = it.getCondition() != null && !DCLTools.isDeny(it) && DCLTools.hasRule(this.currentPolicy, true) || !this.isEmptyIDList(it.getRoles());
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(this.currentPolicyNameEscaped);
        _builder.append(".");
        _builder.append(this.currentRuleIndex);
        _builder.append(": ");
        boolean _isDeny = DCLTools.isDeny(it);
        if (_isDeny) {
            _builder.append("DENY");
        } else {
            _builder.append("GRANT");
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        String _regoName = this.regoName(it, this.currentPolicyName);
        _builder_1.append(_regoName);
        _builder_1.append(" {");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("    ");
        CharSequence _compileIDList = this.compileIDList("action", it.getRoles());
        _builder_1.append((Object)_compileIDList, "    ");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("    ");
        CharSequence _compileID = this.compileID("resource", "$SCOPES");
        _builder_1.append((Object)_compileID, "    ");
        _builder_1.newLineIfNotEmpty();
        Expression _condition = it.getCondition();
        boolean bl = _tripleNotEquals = _condition != null;
        if (_tripleNotEquals) {
            _builder_1.append("    ");
            _builder_1.append("# WHERE");
            _builder_1.newLine();
            _builder_1.append("    ");
            CharSequence _compile = this.compile(it.getCondition());
            _builder_1.append((Object)_compile, "    ");
            _builder_1.newLineIfNotEmpty();
        }
        if (!DCLTools.isDeny(it) && DCLTools.hasRule(this.currentPolicy, true)) {
            _builder_1.append("    ");
            _builder_1.append("not ");
            String _regoName_1 = this.regoName(DCLNameType.RULE_DENY, this.currentPolicyName);
            _builder_1.append(_regoName_1, "    ");
            _builder_1.newLineIfNotEmpty();
        }
        if (!hasBody) {
            _builder_1.append("    ");
            _builder_1.append("true");
            _builder_1.newLine();
        }
        _builder_1.append("}");
        _builder_1.newLine();
        _xblockexpression = this.renderPolicy(_builder.toString(), _builder_1.toString());
        return _xblockexpression;
    }

    protected CharSequence _compile(ExpressionOr it) {
        ArrayList<String> elements = new ArrayList<String>();
        EList<Expression> _orList = it.getOrList();
        for (Expression e : _orList) {
            elements.add(this.compile(e).toString());
        }
        return this.createSubExpression(elements);
    }

    protected CharSequence _compile(ExpressionAnd it) {
        StringConcatenation _builder = new StringConcatenation();
        EList<Expression> _andList = it.getAndList();
        for (Expression e : _andList) {
            CharSequence _compile = this.compile(e);
            _builder.append(_compile);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _compile(ExpressionNumber it) {
        StringConcatenation _builder = new StringConcatenation();
        BigDecimal _value = it.getValue();
        _builder.append(_value);
        return _builder;
    }

    protected CharSequence _compile(ExpressionString it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\"");
        String _regoEscape = this.regoEscape(it.getValue());
        _builder.append(_regoEscape);
        _builder.append("\"");
        return _builder;
    }

    protected CharSequence _compile(ExpressionNull it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("null");
        return _builder;
    }

    protected CharSequence _compile(ExpressionBoolean it) {
        return DataControlLanguageGenerator.toTrueFalse(it.isValue());
    }

    public String compileText(ExpressionIdentifier it) {
        return this.dclNameTools.toString(it, DCLNameTools.IDSerializationMode.MESSAGE);
    }

    protected CharSequence _compile(ExpressionIdentifier it) {
        return this.dclNameTools.toString(it, DCLNameTools.IDSerializationMode.REGO);
    }

    protected CharSequence _compile(ExpressionArray it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("[");
        EList<Constant> _values = it.getValues();
        boolean _hasElements = false;
        for (Constant v : _values) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate(", ", "");
            }
            CharSequence _compile = this.compile(v);
            _builder.append(_compile);
        }
        _builder.append("]");
        return _builder;
    }

    public String regoEscape(String data) {
        boolean _hasContent = DCLTools.hasContent(data);
        if (_hasContent) {
            this.sb.setLength(0);
            boolean _escapeJSONString = DCLStringProcessing.escapeJSONString(data, this.sb, false);
            if (_escapeJSONString) {
                return this.sb.toString();
            }
        }
        return data;
    }

    public String regoLikeEscape(String data) {
        boolean _hasContent = DCLTools.hasContent(data);
        if (_hasContent) {
            this.sb.setLength(0);
            boolean _escapeRegoLikeString = DCLStringProcessing.escapeRegoLikeString(data, this.sb, false);
            if (_escapeRegoLikeString) {
                return this.sb.toString();
            }
        }
        return data;
    }

    protected CharSequence _compile(ExpressionLike it) {
        StringConcatenation _xblockexpression = null;
        String regex = this.likeConverter.toPattern(it.getPattern(), it.getEscape());
        StringConcatenation _builder = new StringConcatenation();
        String _nOT = DataControlLanguageGenerator.toNOT(it.isNot());
        _builder.append(_nOT);
        _builder.append("regex.match( \"");
        String _regoLikeEscape = this.regoLikeEscape(regex);
        _builder.append(_regoLikeEscape);
        _builder.append("\", ");
        CharSequence _compile = this.compile(it.getLeft());
        _builder.append(_compile);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public boolean isNumericSchemaElementIdentifier(Expression it) {
        return it instanceof ExpressionIdentifier && Objects.equals(((ExpressionIdentifier)it).getSchemaAttribute().getType().getDataType(), DataType.DT_NUMBER);
    }

    public CharSequence compileRelational(Expression eLeft, Expression eRight, String op) {
        StringConcatenation _xblockexpression = null;
        CharSequence left = this.compile(eLeft);
        CharSequence right = this.compile(eRight);
        StringConcatenation _xifexpression = null;
        if (BF_REGO_SELF_RELATION && eLeft instanceof ExpressionIdentifier && eRight instanceof ExpressionIdentifier && Objects.equals(left, right)) {
            StringConcatenation _xblockexpression_1 = null;
            String tempName = this.tempName();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(tempName);
            _builder.append(" := ");
            _builder.append(left);
            _builder.newLineIfNotEmpty();
            _builder.append(tempName);
            _builder.append(" ");
            _builder.append(op);
            _builder.append(" ");
            _builder.append(tempName);
            _builder.newLineIfNotEmpty();
            _xifexpression = _xblockexpression_1 = _builder;
        } else {
            StringConcatenation _xifexpression_1 = null;
            boolean _isNumericSchemaElementIdentifier = this.isNumericSchemaElementIdentifier(eLeft);
            if (_isNumericSchemaElementIdentifier) {
                StringConcatenation _xifexpression_2 = null;
                boolean _isNumericSchemaElementIdentifier_1 = this.isNumericSchemaElementIdentifier(eRight);
                if (_isNumericSchemaElementIdentifier_1) {
                    StringConcatenation _xblockexpression_2 = null;
                    String tempNameL = this.tempName();
                    String tempNameR = this.tempName();
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append(tempNameL);
                    _builder.append(" := ");
                    _builder.append(left);
                    _builder.newLineIfNotEmpty();
                    _builder.append(tempNameR);
                    _builder.append(" := ");
                    _builder.append(right);
                    _builder.newLineIfNotEmpty();
                    _builder.append(tempNameL);
                    _builder.append(" ");
                    _builder.append(op);
                    _builder.append(" ");
                    _builder.append(tempNameR);
                    _builder.newLineIfNotEmpty();
                    _xifexpression_2 = _xblockexpression_2 = _builder;
                } else {
                    StringConcatenation _xblockexpression_3 = null;
                    String tempNameL = this.tempName();
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append(tempNameL);
                    _builder.append(" := ");
                    _builder.append(left);
                    _builder.newLineIfNotEmpty();
                    _builder.append(tempNameL);
                    _builder.append(" ");
                    _builder.append(op);
                    _builder.append(" ");
                    _builder.append(right);
                    _builder.newLineIfNotEmpty();
                    _xifexpression_2 = _xblockexpression_3 = _builder;
                }
                _xifexpression_1 = _xifexpression_2;
            } else {
                StringConcatenation _xifexpression_3 = null;
                boolean _isNumericSchemaElementIdentifier_2 = this.isNumericSchemaElementIdentifier(eRight);
                if (_isNumericSchemaElementIdentifier_2) {
                    StringConcatenation _xblockexpression_4 = null;
                    String tempNameR = this.tempName();
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append(tempNameR);
                    _builder.append(" := ");
                    _builder.append(right);
                    _builder.newLineIfNotEmpty();
                    _builder.append(left);
                    _builder.append(" ");
                    _builder.append(op);
                    _builder.append(" ");
                    _builder.append(tempNameR);
                    _builder.newLineIfNotEmpty();
                    _xifexpression_3 = _xblockexpression_4 = _builder;
                } else {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append(left);
                    _builder.append(" ");
                    _builder.append(op);
                    _builder.append(" ");
                    _builder.append(right);
                    _builder.newLineIfNotEmpty();
                    _xifexpression_3 = _builder;
                }
                _xifexpression_1 = _xifexpression_3;
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected CharSequence _compile(ExpressionRelational it) {
        return this.compileRelational(it.getLeft(), it.getRight(), OPERATOR_MAP.getOrDefault(it.getOperator(), it.getOperator()));
    }

    public String tempName() {
        int _plusPlus = this.nestedTempIndex++;
        return "___temp_" + String.valueOf((Object)_plusPlus);
    }

    protected CharSequence _compile(ExpressionIn it) {
        StringConcatenation _xifexpression = null;
        Expression _right = it.getRight();
        if (_right instanceof ExpressionArray) {
            StringConcatenation _xblockexpression = null;
            String tempName = this.tempName();
            String array = this.compile(it.getRight()).toString();
            StringConcatenation _xifexpression_1 = null;
            boolean _equals = Objects.equals(array, "[]");
            if (_equals) {
                StringConcatenation _xifexpression_2 = null;
                boolean _isNot = it.isNot();
                if (_isNot) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append(tempName);
                    _builder.append(" := ");
                    CharSequence _compile = this.compile(it.getLeft());
                    _builder.append(_compile);
                    _builder.newLineIfNotEmpty();
                    _xifexpression_2 = _builder;
                } else {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("false");
                    _builder_1.newLine();
                    _xifexpression_2 = _builder_1;
                }
                _xifexpression_1 = _xifexpression_2;
            } else {
                StringConcatenation _xifexpression_3 = null;
                boolean _isNumericSchemaElementIdentifier = this.isNumericSchemaElementIdentifier(it.getLeft());
                if (_isNumericSchemaElementIdentifier) {
                    StringConcatenation _xblockexpression_1 = null;
                    String tempNameL = this.tempName();
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append(tempName);
                    _builder_2.append(" := {");
                    int _length = array.length();
                    int _minus = _length - 1;
                    String _substring = array.substring(1, _minus);
                    _builder_2.append(_substring);
                    _builder_2.append("}");
                    _builder_2.newLineIfNotEmpty();
                    _builder_2.append(tempNameL);
                    _builder_2.append(" := ");
                    CharSequence _compile_1 = this.compile(it.getLeft());
                    _builder_2.append(_compile_1);
                    _builder_2.newLineIfNotEmpty();
                    String _nOT = DataControlLanguageGenerator.toNOT(it.isNot());
                    _builder_2.append(_nOT);
                    _builder_2.append(tempName);
                    _builder_2.append("[");
                    _builder_2.append(tempNameL);
                    _builder_2.append("]");
                    _builder_2.newLineIfNotEmpty();
                    _xifexpression_3 = _xblockexpression_1 = _builder_2;
                } else {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append(tempName);
                    _builder_2.append(" := {");
                    int _length = array.length();
                    int _minus = _length - 1;
                    String _substring = array.substring(1, _minus);
                    _builder_2.append(_substring);
                    _builder_2.append("}");
                    _builder_2.newLineIfNotEmpty();
                    String _nOT = DataControlLanguageGenerator.toNOT(it.isNot());
                    _builder_2.append(_nOT);
                    _builder_2.append(tempName);
                    _builder_2.append("[");
                    CharSequence _compile_1 = this.compile(it.getLeft());
                    _builder_2.append(_compile_1);
                    _builder_2.append("]");
                    _builder_2.newLineIfNotEmpty();
                    _xifexpression_3 = _builder_2;
                }
                _xifexpression_1 = _xifexpression_3;
            }
            _xifexpression = _xblockexpression = _xifexpression_1;
        } else {
            StringConcatenation _xifexpression_2;
            StringConcatenation _xifexpression_1 = null;
            Expression _right_1 = it.getRight();
            if (_right_1 instanceof ExpressionIdentifier) {
                _xifexpression_2 = null;
                boolean _isNumericSchemaElementIdentifier = this.isNumericSchemaElementIdentifier(it.getLeft());
                if (_isNumericSchemaElementIdentifier) {
                    StringConcatenation _xblockexpression_1 = null;
                    String tempNameL = this.tempName();
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append(tempNameL);
                    _builder.append(" := ");
                    CharSequence _compile = this.compile(it.getLeft());
                    _builder.append(_compile);
                    _builder.newLineIfNotEmpty();
                    _builder.append(tempNameL);
                    _builder.append(" == ");
                    CharSequence _compile_1 = this.compile(it.getRight());
                    _builder.append(_compile_1);
                    _builder.append("[_] ");
                    _builder.newLineIfNotEmpty();
                    _xifexpression_2 = _xblockexpression_1 = _builder;
                } else {
                    StringConcatenation _builder = new StringConcatenation();
                    CharSequence _compile = this.compile(it.getLeft());
                    _builder.append(_compile);
                    _builder.append(" == ");
                    CharSequence _compile_1 = this.compile(it.getRight());
                    _builder.append(_compile_1);
                    _builder.append("[_] ");
                    _builder.newLineIfNotEmpty();
                    _xifexpression_2 = _builder;
                }
            } else {
                throw new IllegalStateException("Can only generate IN with constant arrays or identifiers of array type.");
            }
            _xifexpression_1 = _xifexpression_2;
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    protected CharSequence _compile(ExpressionBetween it) {
        StringConcatenation _xifexpression = null;
        boolean _isNot = it.isNot();
        if (_isNot) {
            StringConcatenation _builder = new StringConcatenation();
            StringConcatenation _builder_1 = new StringConcatenation();
            CharSequence _compileRelational = this.compileRelational(it.getLeft(), it.getLower(), "<");
            _builder_1.append(_compileRelational);
            StringConcatenation _builder_2 = new StringConcatenation();
            CharSequence _compileRelational_1 = this.compileRelational(it.getLeft(), it.getUpper(), ">");
            _builder_2.append(_compileRelational_1);
            String _createSubExpression = this.createSubExpression(_builder_1.toString(), _builder_2.toString());
            _builder.append(_createSubExpression);
            _builder.newLineIfNotEmpty();
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_3 = new StringConcatenation();
            CharSequence _compileRelational_2 = this.compileRelational(it.getLeft(), it.getLower(), ">=");
            _builder_3.append(_compileRelational_2);
            _builder_3.newLineIfNotEmpty();
            CharSequence _compileRelational_3 = this.compileRelational(it.getLeft(), it.getUpper(), "<=");
            _builder_3.append(_compileRelational_3);
            _builder_3.newLineIfNotEmpty();
            _xifexpression = _builder_3;
        }
        return _xifexpression;
    }

    protected CharSequence _compile(ExpressionCall it) {
        return this.compile(it.getLeft().getResult());
    }

    protected CharSequence _compile(ExpressionIsNull it) {
        StringConcatenation _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        String _tempName = this.tempName();
        _builder.append(_tempName);
        _builder.append(" := ");
        CharSequence _compile = this.compile(it.getLeft());
        _builder.append(_compile);
        String isNotNull = _builder.toString();
        StringConcatenation _xifexpression = null;
        boolean _isNot = it.isNot();
        if (_isNot) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(isNotNull);
            _xifexpression = _builder_1;
        } else {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("not ");
            String _createSubExpression = this.createSubExpression(isNotNull);
            _builder_2.append(_createSubExpression);
            _builder_2.newLineIfNotEmpty();
            _xifexpression = _builder_2;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static String toTrueFalse(boolean value) {
        String _xifexpression = null;
        _xifexpression = value ? "true" : "false";
        return _xifexpression;
    }

    public static String toNOT(boolean value) {
        String _xifexpression = null;
        _xifexpression = value ? "not " : "";
        return _xifexpression;
    }

    protected CharSequence _compile(ExpressionIsRestricted it) {
        CharSequence _xblockexpression = null;
        Expression _left = it.getLeft();
        ExpressionIdentifier left = (ExpressionIdentifier)_left;
        Expression restrExpression = this.currentRestrictionDefinedFor(left);
        CharSequence _xifexpression = null;
        if (restrExpression == null) {
            StringConcatenation _builder = new StringConcatenation();
            String _trueFalse = DataControlLanguageGenerator.toTrueFalse(it.isNotRestricted());
            _builder.append(_trueFalse);
            _builder.append(" # @");
            String _compileText = this.compileText(left);
            _builder.append(_compileText);
            _builder.newLineIfNotEmpty();
            _xifexpression = _builder;
        } else {
            CharSequence _xifexpression_1 = null;
            if (restrExpression instanceof ExpressionIsRestricted) {
                StringConcatenation _builder_1 = new StringConcatenation();
                String _trueFalse_1 = DataControlLanguageGenerator.toTrueFalse(((ExpressionIsRestricted)restrExpression).isNotRestricted());
                _builder_1.append(_trueFalse_1);
                _builder_1.append(" # @");
                Expression _left_1 = ((ExpressionIsRestricted)restrExpression).getLeft();
                String _compileText_1 = this.compileText((ExpressionIdentifier)_left_1);
                _builder_1.append(_compileText_1);
                _builder_1.newLineIfNotEmpty();
                _xifexpression_1 = _builder_1;
            } else {
                _xifexpression_1 = this.compile(restrExpression);
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private boolean isFQN(Expression id, QualifiedName fqn) {
        return id instanceof ExpressionIdentifier && this._iQualifiedNameProvider.getFullyQualifiedName(((ExpressionIdentifier)id).getSchemaAttribute()) == fqn;
    }

    private Expression currentRestrictionDefinedFor(ExpressionIdentifier ei) {
        if (this.currentRestriction != null) {
            QualifiedName fqn = this._iQualifiedNameProvider.getFullyQualifiedName(ei.getSchemaAttribute());
            EList<Expression> _parameter = this.currentRestriction.getParameter();
            for (Expression e : _parameter) {
                Expression res = this.getRestriction(e, fqn);
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    private Expression getRestriction(Expression e, QualifiedName fqn) {
        boolean _isFQN;
        Expression _switchResult = null;
        boolean _matched = false;
        if (e instanceof ExpressionRelational && (this.isFQN(((ExpressionRelational)e).getLeft(), fqn) || this.isFQN(((ExpressionRelational)e).getRight(), fqn))) {
            _matched = true;
            _switchResult = e;
        }
        if (!_matched && e instanceof ExpressionLike && (_isFQN = this.isFQN(((ExpressionLike)e).getLeft(), fqn))) {
            _matched = true;
            _switchResult = e;
        }
        if (!_matched && e instanceof ExpressionIn && (_isFQN = this.isFQN(((ExpressionIn)e).getLeft(), fqn))) {
            _matched = true;
            _switchResult = e;
        }
        if (!_matched && e instanceof ExpressionBetween && (_isFQN = this.isFQN(((ExpressionBetween)e).getLeft(), fqn))) {
            _matched = true;
            _switchResult = e;
        }
        if (!_matched && e instanceof ExpressionIsNull && (_isFQN = this.isFQN(((ExpressionIsNull)e).getLeft(), fqn))) {
            _matched = true;
            _switchResult = e;
        }
        if (!_matched && e instanceof ExpressionIsRestricted && (_isFQN = this.isFQN(((ExpressionIsRestricted)e).getLeft(), fqn))) {
            _matched = true;
            _switchResult = e;
        }
        if (!_matched) {
            _switchResult = null;
        }
        return _switchResult;
    }

    protected CharSequence _compile(JMap it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _compileMapContent = this.compileMapContent(it);
        _builder.append((Object)_compileMapContent, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        return _builder;
    }

    protected CharSequence _compile(JMapEntry it) {
        CharSequence _xifexpression = null;
        ExpressionConstant _value = it.getValue();
        if (_value instanceof ExpressionNull) {
            _xifexpression = "";
        } else {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("\"");
            String _regoEscape = this.regoEscape(it.getSchemaAttribute().getName());
            _builder.append(_regoEscape);
            _builder.append("\": ");
            CharSequence _compile = this.compile(it.getValue());
            _builder.append(_compile);
            _builder.append(",");
            _builder.newLineIfNotEmpty();
            _xifexpression = _builder;
        }
        return _xifexpression;
    }

    public CharSequence compileMapContent(JMap it) {
        StringConcatenation _builder = new StringConcatenation();
        EList<JMapEntry> _entries = it.getEntries();
        for (JMapEntry e : _entries) {
            _builder.newLineIfNotEmpty();
            CharSequence _compile = this.compile(e);
            _builder.append(_compile);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _compile(TestScenario it) {
        StringConcatenation _builder = new StringConcatenation();
        String _regoName = this.regoName(DCLNameType.TEST_SCENARIO, it.getName());
        _builder.append(_regoName);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        boolean _isEmpty = DCLTools.isEmpty(it.getTestCases());
        if (_isEmpty) {
            _builder.append("\t");
            _builder.append("true");
            _builder.newLine();
        } else {
            EList<TestCase> _testCases = it.getTestCases();
            for (TestCase tc : _testCases) {
                _builder.append("\t");
                CharSequence _compile = this.compile(tc);
                _builder.append((Object)_compile, "\t");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _compile(TestCase it) {
        boolean _tripleNotEquals;
        Expression _expression = it.getExpression();
        boolean bl = _tripleNotEquals = _expression != null;
        if (_tripleNotEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("true");
            _builder.newLine();
            _builder.newLine();
            return _builder;
        }
        Object res = "";
        List<String> _list = DCLGeneratorTools.getList(it.getActions());
        for (String action : _list) {
            List<String> _list_1 = DCLGeneratorTools.getList(it.getResources());
            for (String resource : _list_1) {
                List<TestCaseInput> _list_2 = DCLGeneratorTools.getList(it.getTestCaseInputs());
                for (TestCaseInput tci : _list_2) {
                    if (DCLGeneratorTools.hasSpecialValue(tci) || !DCLGeneratorTools.isResultFromEffect(it)) {
                        String _res = res;
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("true # special value encountered");
                        _builder_1.newLine();
                        _builder_1.newLine();
                        res = _res + String.valueOf(_builder_1);
                        continue;
                    }
                    String _res_1 = res;
                    StringConcatenation _builder_2 = new StringConcatenation();
                    if (this.mtSupport && this.tenant != null) {
                        String _nOT = DataControlLanguageGenerator.toNOT(it.isDeny());
                        _builder_2.append(_nOT);
                        _builder_2.append("__allowTest with input as __allowTestInput( {");
                        _builder_2.newLineIfNotEmpty();
                    } else {
                        String _nOT_1 = DataControlLanguageGenerator.toNOT(it.isDeny());
                        _builder_2.append(_nOT_1);
                        _builder_2.append("allow with input as {");
                        _builder_2.newLineIfNotEmpty();
                    }
                    _builder_2.append("\t");
                    CharSequence _compileDcl = this.compileDcl(action, resource, it.getPolicyList(), it.getScopeFilter());
                    _builder_2.append((Object)_compileDcl, "\t");
                    _builder_2.append(",");
                    _builder_2.newLineIfNotEmpty();
                    _builder_2.append("\t");
                    CharSequence _compileInput = this.compileInput(tci);
                    _builder_2.append((Object)_compileInput, "\t");
                    _builder_2.newLineIfNotEmpty();
                    _builder_2.append("}");
                    if (this.mtSupport && this.tenant != null) {
                        _builder_2.append(")");
                    }
                    _builder_2.newLineIfNotEmpty();
                    _builder_2.newLine();
                    res = _res_1 + String.valueOf(_builder_2);
                }
            }
        }
        return res;
    }

    public CharSequence compileDcl(String action, String resource, PolicyList policyList, PolicyList scopeFilter) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\"");
        _builder.append("$dcl");
        _builder.append("\": {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\"");
        _builder.append("action", "\t");
        _builder.append("\": ");
        if (action == null) {
            _builder.append("null");
        } else {
            _builder.append("\"");
            String _regoEscape = this.regoEscape(action);
            _builder.append(_regoEscape, "\t");
            _builder.append("\"");
        }
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\"");
        _builder.append("resource", "\t");
        _builder.append("\": ");
        if (resource == null) {
            _builder.append("null");
        } else {
            _builder.append("\"");
            String _regoEscape_1 = this.regoEscape(resource);
            _builder.append(_regoEscape_1, "\t");
            _builder.append("\"");
        }
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\"");
        _builder.append("policies", "\t");
        _builder.append("\": ");
        if (policyList == null) {
            _builder.append("[]");
        } else {
            CharSequence _compile = this.compile(policyList);
            _builder.append((Object)_compile, "\t");
        }
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        if (scopeFilter != null && DCLTools.hasContent(scopeFilter.getPolicies())) {
            _builder.append("\"");
            _builder.append("scopeFilter", "\t");
            _builder.append("\": ");
            CharSequence _compile_1 = this.compile(scopeFilter);
            _builder.append((Object)_compile_1, "\t");
            _builder.append(",");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\"");
        _builder.append("principal2policies", "\t");
        _builder.append("\": [\"TEST_ZONE\",\"TEST_USR\"]");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        return _builder;
    }

    public CharSequence compileInput(TestCaseInput it) {
        boolean _isEmpty_1;
        boolean _not_1;
        boolean _not;
        StringConcatenation _xblockexpression = null;
        if (it == null) {
            return "";
        }
        JMap map = it.getMap();
        if (map == null || map.getEntries().isEmpty()) {
            return "";
        }
        ArrayList<JMapEntry> apps = new ArrayList<JMapEntry>();
        ArrayList<JMapEntry> others = new ArrayList<JMapEntry>();
        EList<JMapEntry> _entries = map.getEntries();
        for (JMapEntry e : _entries) {
            String name = e.getSchemaAttribute().getName();
            DCLStringProcessing.SegmentType _segmentType = DCLStringProcessing.getSegmentType(name);
            if (_segmentType == null) continue;
            switch (_segmentType) {
                case APP: {
                    apps.add(e);
                    break;
                }
                case ENV: {
                    others.add(e);
                    break;
                }
            }
        }
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = others.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("\"");
            _builder.append("$env");
            _builder.append("\": {");
            _builder.newLineIfNotEmpty();
            for (JMapEntry e_1 : others) {
                _builder.append("    ");
                CharSequence _compile = this.compile(e_1);
                _builder.append((Object)_compile, "    ");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("},");
            _builder.newLine();
        }
        boolean bl2 = _not_1 = !(_isEmpty_1 = apps.isEmpty());
        if (_not_1) {
            _builder.append("\"");
            _builder.append("$app");
            _builder.append("\": {");
            _builder.newLineIfNotEmpty();
            for (JMapEntry e_2 : apps) {
                _builder.append("\t");
                CharSequence _compile_1 = this.compile(e_2);
                _builder.append((Object)_compile_1, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("},");
            _builder.newLine();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected CharSequence _compile(PolicyList it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("[");
        EList<PolicyDefinition> _policies = it.getPolicies();
        boolean _hasElements = false;
        for (PolicyDefinition v : _policies) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate(", ", "");
            }
            _builder.append("\"");
            String _regoEscape = this.regoEscape(this.createAssignemtPolicyName(v));
            _builder.append(_regoEscape);
            _builder.append("\"");
        }
        _builder.append("]");
        return _builder;
    }

    @XbaseGenerated
    public CharSequence compile(EObject it) {
        if (it instanceof ExpressionArray) {
            return this._compile((ExpressionArray)it);
        }
        if (it instanceof ExpressionBoolean) {
            return this._compile((ExpressionBoolean)it);
        }
        if (it instanceof ExpressionNull) {
            return this._compile((ExpressionNull)it);
        }
        if (it instanceof ExpressionNumber) {
            return this._compile((ExpressionNumber)it);
        }
        if (it instanceof ExpressionSpecialValue) {
            return this._compile((ExpressionSpecialValue)it);
        }
        if (it instanceof ExpressionString) {
            return this._compile((ExpressionString)it);
        }
        if (it instanceof JMap) {
            return this._compile((JMap)it);
        }
        if (it instanceof PolicyDefinition) {
            return this._compile((PolicyDefinition)it);
        }
        if (it instanceof TestScenario) {
            return this._compile((TestScenario)it);
        }
        if (it instanceof PolicyUse) {
            return this._compile((PolicyUse)it);
        }
        if (it instanceof Rule) {
            return this._compile((Rule)it);
        }
        if (it instanceof TestCase) {
            return this._compile((TestCase)it);
        }
        if (it instanceof ExpressionAnd) {
            return this._compile((ExpressionAnd)it);
        }
        if (it instanceof ExpressionBetween) {
            return this._compile((ExpressionBetween)it);
        }
        if (it instanceof ExpressionCall) {
            return this._compile((ExpressionCall)it);
        }
        if (it instanceof ExpressionIdentifier) {
            return this._compile((ExpressionIdentifier)it);
        }
        if (it instanceof ExpressionIn) {
            return this._compile((ExpressionIn)it);
        }
        if (it instanceof ExpressionIsNull) {
            return this._compile((ExpressionIsNull)it);
        }
        if (it instanceof ExpressionIsRestricted) {
            return this._compile((ExpressionIsRestricted)it);
        }
        if (it instanceof ExpressionLike) {
            return this._compile((ExpressionLike)it);
        }
        if (it instanceof ExpressionOr) {
            return this._compile((ExpressionOr)it);
        }
        if (it instanceof ExpressionRelational) {
            return this._compile((ExpressionRelational)it);
        }
        if (it instanceof JMapEntry) {
            return this._compile((JMapEntry)it);
        }
        if (it instanceof PolicyList) {
            return this._compile((PolicyList)it);
        }
        if (it instanceof RoleRule) {
            return this._compile((RoleRule)it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

