/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.generator;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.sap.cloud.security.ams.dcl.processors.GsonTools;
import java.lang.reflect.Type;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.validation.Issue;

public class IssueTypeAdapter
implements JsonSerializer<Issue>,
JsonDeserializer<Issue> {
    private static final Logger LOG = Logger.getLogger(IssueTypeAdapter.class);
    private static final IssueTypeAdapter INSTANCE = new IssueTypeAdapter();
    private static final String SEVERITY = "severity";
    private static final String SYNTAX_ERROR = "syntaxError";
    private static final String MESSAGE = "message";
    private static final String COLUMN = "column";
    private static final String LINE = "line";
    private static final String CODE = "code";

    protected IssueTypeAdapter() {
    }

    public static IssueTypeAdapter getInstance() {
        return INSTANCE;
    }

    @Override
    public JsonElement serialize(Issue issue, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jObject = new JsonObject();
        jObject.addProperty(LINE, issue.getLineNumber());
        jObject.addProperty(COLUMN, issue.getColumn());
        jObject.addProperty(MESSAGE, issue.getMessage());
        jObject.addProperty(SYNTAX_ERROR, issue.isSyntaxError());
        jObject.addProperty(SEVERITY, issue.getSeverity().name());
        jObject.addProperty(CODE, IssueTypeAdapter.parseIssueCode(issue));
        return jObject;
    }

    @Override
    public Issue deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jObject = json.getAsJsonObject();
        Issue.IssueImpl issue = new Issue.IssueImpl();
        issue.setLineNumber(GsonTools.getMemberAsInt(jObject, LINE));
        issue.setColumn(GsonTools.getMemberAsInt(jObject, COLUMN));
        issue.setMessage(GsonTools.getMemberAsString(jObject, MESSAGE));
        issue.setSyntaxError(GsonTools.getMemberAsBoolean(jObject, SYNTAX_ERROR));
        issue.setSeverity(IssueTypeAdapter.parseSeverity(GsonTools.getMemberAsString(jObject, SEVERITY)));
        issue.setCode(GsonTools.getMemberAsString(jObject, CODE));
        return issue;
    }

    static Severity parseSeverity(String severityString) {
        if (severityString != null) {
            try {
                return Severity.valueOf(severityString.toUpperCase(Locale.US));
            }
            catch (RuntimeException runtimeException) {}
        }
        return Severity.ERROR;
    }

    static int parseIssueCode(Issue issue) {
        String code = issue.getCode();
        if (code != null) {
            try {
                return Integer.parseInt(code);
            }
            catch (NumberFormatException numberFormatException) {
                LOG.error("Failed to parse Issue code '" + code + "'. Issue=" + issue.getMessage());
            }
        } else {
            LOG.error("Issue code is null. " + issue.getMessage());
        }
        return -1;
    }
}

