/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.generator;

import com.sap.cloud.security.ams.dcl.generator.DCLCompilerTools;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.resource.Resource;

class ResAdapter
extends AdapterImpl {
    public final String relativeSourcePath;

    public ResAdapter(String relativeSourcePath) {
        this.relativeSourcePath = Objects.requireNonNull(relativeSourcePath);
    }

    public static String getRelativeSourcePath(Resource resource, File sourceDirectory) throws IOException {
        for (Adapter adapter : resource.eAdapters()) {
            if (!(adapter instanceof ResAdapter)) continue;
            ResAdapter resAdapter = (ResAdapter)adapter;
            return resAdapter.relativeSourcePath;
        }
        String relativePath = DCLCompilerTools.getRelativePath(sourceDirectory, new File(resource.getURI().toFileString()));
        return ResAdapter.attach(resource, relativePath);
    }

    static String attach(Resource resource, String relativePath) {
        ResAdapter ra = new ResAdapter(relativePath);
        resource.eAdapters().add(ra);
        return ra.relativeSourcePath;
    }
}

