/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.generator;

import com.sap.cloud.security.ams.dcl.generator.DCLCompilerParameter;
import com.sap.cloud.security.ams.dcl.generator.ResourceLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Locale;
import org.eclipse.emf.common.util.URI;

class ResourceLoaderSourceDirectory
implements ResourceLoader {
    public static final ResourceLoader INSTANCE = new ResourceLoaderSourceDirectory();

    private ResourceLoaderSourceDirectory() {
    }

    @Override
    public void load(DCLCompilerParameter compileParameter, final ResourceLoader.LoadContext context) throws IOException {
        Files.walkFileTree(compileParameter.getSourceDirectory().toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                File f = file.toFile();
                String fileName = f.getName().toLowerCase(Locale.US);
                if (fileName.endsWith(".dcl") || fileName.endsWith(".dcn")) {
                    URI uri = URI.createFileURI(f.getPath());
                    Throwable throwable = null;
                    Object var7_8 = null;
                    try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                        context.addResource(uri, is);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                return super.visitFile(file, attrs);
            }
        });
    }
}

