/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.generator;

import com.sap.cloud.security.ams.dcl.DCLTools;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerParameter;
import com.sap.cloud.security.ams.dcl.generator.ResourceWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;

class ResourceWriterFileSystem
implements ResourceWriter {
    private final DCLCompilerParameter cp;

    public ResourceWriterFileSystem(DCLCompilerParameter cp) {
        this.cp = cp;
    }

    @Override
    public void write(String name, byte[] content) throws IOException {
        File file = this.cp.grantOutputDirectoryFor(name);
        Throwable throwable = null;
        Object var5_6 = null;
        try (OutputStream os = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            os.write(content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void write(String name, String content) throws IOException {
        File file = this.cp.grantOutputDirectoryFor(name);
        Throwable throwable = null;
        Object var5_6 = null;
        try (Writer ow = DCLTools.createUTF8FileWriter(file);){
            ow.write(content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

