/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.processors;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.inject.Inject;
import com.sap.cloud.security.ams.dcl.DCLResourceHelper;
import com.sap.cloud.security.ams.dcl.DCLStringProcessing;
import com.sap.cloud.security.ams.dcl.DCLTools;
import com.sap.cloud.security.ams.dcl.ResourceLocation;
import com.sap.cloud.security.ams.dcl.client.language.DataControlLanguageScanner;
import com.sap.cloud.security.ams.dcl.client.language.DataControlLanguageTools;
import com.sap.cloud.security.ams.dcl.client.language.TokenFormat;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.AnnotatedElement;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.Annotation;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.Constant;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.DataControlLanguagePackage;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionAnd;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionArray;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionBetween;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionBoolean;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionCall;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionConstant;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionIdentifier;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionIn;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionIsNull;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionIsRestricted;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionLike;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionNumber;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionOr;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionRelational;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionString;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.FunctionDefinition;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.IDList;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.JSONObject;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.JSONObjectEntry;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.PolicyDefinition;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.PolicyUse;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.Restriction;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.RoleList;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.RoleRule;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.Rule;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaAttribute;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaMap;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaType;
import com.sap.cloud.security.ams.dcl.processors.GsonTools;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public abstract class DCLBaseSerializer
implements JsonSerializer<EObject> {
    public static final String SEPARATOR = ";";
    private static final String BROKEN_REFERENCE_STRING = "--broken--";
    private static final List<String> BROKEN_REFERENCE_LIST = Collections.singletonList("--broken--");
    private static final JsonObject BROKEN_REF_STRING = GsonTools.ref(new JsonPrimitive("--broken--"));
    private static final JsonObject BROKEN_REF_LIST = GsonTools.ref(GsonTools.toArray(BROKEN_REFERENCE_LIST));
    protected static final EReference POLICY_USE_POLICY = DataControlLanguagePackage.eINSTANCE.getPolicyUse_Policy();
    protected static final EReference EXPRESSION_CALL_DEFINITION = DataControlLanguagePackage.eINSTANCE.getExpressionCall_Left();
    protected static final EReference EXPRESSION_IDENTIFIER_SCHEMA_ELEMENT = DataControlLanguagePackage.eINSTANCE.getExpressionIdentifier_SchemaAttribute();
    private final boolean referenceAsString;
    private final boolean scopedSchemaElements;
    private final StringBuilder buffer = new StringBuilder(128);
    private final List<String> tempStrings = new ArrayList<String>();
    private final DataControlLanguageScanner scanner = DataControlLanguageScanner.create(TokenFormat.DCL_IDENTIFIER);
    @Inject
    private DCLResourceHelper resourceHelper;

    protected DCLBaseSerializer(boolean referenceAsString, boolean scopedSchemaElements) {
        this.referenceAsString = referenceAsString;
        this.scopedSchemaElements = scopedSchemaElements;
    }

    protected abstract JsonElement operator(JsonSerializationContext var1, String var2, Object ... var3);

    @Override
    protected JsonElement serialize(ExpressionIdentifier it, Type type, JsonSerializationContext context) {
        JsonElement target;
        SchemaAttribute schemaElement = it.getSchemaAttribute();
        if (schemaElement.eIsProxy()) {
            List<String> names = this.getDCLNames(it, EXPRESSION_IDENTIFIER_SCHEMA_ELEMENT, this.scopedSchemaElements);
            if (names == null) {
                return this.referenceAsString ? BROKEN_REF_STRING : BROKEN_REF_LIST;
            }
            target = this.referenceAsString ? new JsonPrimitive(DataControlLanguageTools.encodeQualifiedName(names, this.buffer)) : GsonTools.toArray(names);
        } else {
            String name = null;
            this.tempStrings.clear();
            EObject current = schemaElement;
            while (true) {
                if (current instanceof SchemaMap) {
                    current = current.eContainer();
                }
                if (current instanceof SchemaType) {
                    current = current.eContainer();
                }
                if (!(current instanceof SchemaAttribute)) break;
                name = ((SchemaAttribute)current).getName();
                this.tempStrings.add(name);
                current = current.eContainer();
            }
            if (this.scopedSchemaElements) {
                this.tempStrings.add(DCLStringProcessing.getSegmentType(name).toString());
            }
            Collections.reverse(this.tempStrings);
            target = this.referenceAsString ? new JsonPrimitive(DataControlLanguageTools.encodeQualifiedName(this.tempStrings, this.buffer)) : GsonTools.toArray(this.tempStrings);
        }
        return GsonTools.ref(target);
    }

    @Override
    protected JsonElement serialize(ExpressionCall it, Type type, JsonSerializationContext context) {
        JsonObject o = new JsonObject();
        FunctionDefinition fd = it.getLeft();
        GsonTools.add(context, o, "call", this.crossReference(it, EXPRESSION_CALL_DEFINITION, fd, fd.getName()));
        GsonTools.opt(context, o, "args", Collections.emptyList());
        return o;
    }

    protected JsonObject serialize(PolicyUse it, Type type, JsonSerializationContext context) {
        JsonObject o = new JsonObject();
        PolicyDefinition policy = it.getPolicy();
        GsonTools.add(context, o, "use", this.crossReference(it, POLICY_USE_POLICY, policy, policy.getName()));
        GsonTools.opt(context, o, "restrictions", it.getRestrictions());
        return o;
    }

    protected JsonObject serialize(Rule it, Type type, JsonSerializationContext context) {
        JsonObject o = new JsonObject();
        GsonTools.add(context, o, "rule", DCLTools.isDeny(it) ? "deny" : "grant");
        GsonTools.opt(context, o, "actions", DCLBaseSerializer.getNames(it.getActions()));
        GsonTools.opt(context, o, "resources", DCLBaseSerializer.getNames(it.getResources()));
        GsonTools.opt(context, o, "condition", it.getCondition());
        return o;
    }

    protected JsonObject serialize(RoleRule it, Type type, JsonSerializationContext context) {
        JsonObject o = new JsonObject();
        GsonTools.add(context, o, "rule", DCLTools.isDeny(it) ? "deny" : "grant");
        GsonTools.opt(context, o, "actions", DCLBaseSerializer.getNames(it.getRoles()));
        GsonTools.opt(context, o, "resources", Arrays.asList("$SCOPES"));
        GsonTools.opt(context, o, "condition", it.getCondition());
        GsonTools.add(context, o, "role", true);
        return o;
    }

    protected JsonObject serialize(FunctionDefinition it, Type type, JsonSerializationContext context) {
        JsonObject o = new JsonObject();
        GsonTools.add(context, o, "function", this.reference(it, it.getName()));
        GsonTools.opt(context, o, "result", it.getResult());
        GsonTools.optIfTrue(context, o, "internal", DCLTools.isInternal(it));
        return o;
    }

    protected void optAnnotations(JsonObject container, AnnotatedElement it, JsonSerializationContext context, Collection<String> filter) {
        EList<Annotation> annotations = it.getAnnotations();
        if (!DCLTools.hasContent(annotations)) {
            return;
        }
        JsonObject res = new JsonObject();
        for (Annotation a : it.getAnnotations()) {
            if (filter != null && filter.contains(a.getId())) continue;
            ExpressionConstant value = a.getValue();
            res.add(a.getId(), value == null ? GsonTools.JSON_TRUE : this.serialize(value, (Type)null, context));
        }
        if (res.size() > 0) {
            container.add("annotations", res);
        }
    }

    protected void optAnnotations(JsonObject container, AnnotatedElement it, JsonSerializationContext context) {
        this.optAnnotations(container, it, context, null);
    }

    @Override
    public JsonElement serialize(EObject it, Type type, JsonSerializationContext context) {
        if (it == null) {
            return null;
        }
        switch (it.eClass().getClassifierID()) {
            case 42: {
                return GsonTools.toPrimitive(((ExpressionBoolean)it).isValue());
            }
            case 40: {
                return new JsonPrimitive(((ExpressionNumber)it).getValue());
            }
            case 41: {
                return new JsonPrimitive(((ExpressionString)it).getValue());
            }
            case 43: {
                return JsonNull.INSTANCE;
            }
            case 23: {
                ExpressionArray i = (ExpressionArray)it;
                JsonArray res = new JsonArray(i.getValues().size());
                for (Constant ec : i.getValues()) {
                    res.add(this.serialize(ec, (Type)null, context));
                }
                return res;
            }
            case 45: {
                JSONObject i = (JSONObject)it;
                JsonObject res = new JsonObject();
                for (JSONObjectEntry entry : i.getEntries()) {
                    res.add(entry.getElement(), this.serialize(entry.getValue(), (Type)null, context));
                }
                return res;
            }
            case 32: {
                ExpressionAnd i = (ExpressionAnd)it;
                return this.operator(context, "and", i.getAndList().toArray());
            }
            case 36: {
                ExpressionBetween i = (ExpressionBetween)it;
                return this.operator(context, i.isNot() ? "not_between" : "between", i.getLeft(), i.getLower(), i.getUpper());
            }
            case 39: {
                return this.serialize((ExpressionCall)it, type, context);
            }
            case 19: {
                return this.serialize((ExpressionIdentifier)it, type, context);
            }
            case 35: {
                ExpressionIn i = (ExpressionIn)it;
                return this.operator(context, i.isNot() ? "not_in" : "in", i.getLeft(), i.getRight());
            }
            case 37: {
                ExpressionIsNull i = (ExpressionIsNull)it;
                return this.operator(context, i.isNot() ? "is_not_null" : "is_null", i.getLeft());
            }
            case 38: {
                ExpressionIsRestricted i = (ExpressionIsRestricted)it;
                return this.operator(context, i.isNotRestricted() ? "not_restricted" : "restricted", i.getLeft());
            }
            case 34: {
                String name;
                ExpressionLike i = (ExpressionLike)it;
                String string = name = i.isNot() ? "not_like" : "like";
                if (DCLTools.isEmpty(i.getEscape())) {
                    return this.operator(context, name, i.getLeft(), i.getPattern());
                }
                return this.operator(context, name, i.getLeft(), i.getPattern(), i.getEscape());
            }
            case 31: {
                ExpressionOr i = (ExpressionOr)it;
                return this.operator(context, "or", i.getOrList().toArray());
            }
            case 33: {
                ExpressionRelational i = (ExpressionRelational)it;
                String name = DCLBaseSerializer.getRuntimeRelationalOperatorName(i.getOperator());
                return this.operator(context, name, i.getLeft(), i.getRight());
            }
            case 3: {
                Restriction i = (Restriction)it;
                return context.serialize(i.getParameter());
            }
            case 2: {
                return this.serialize((PolicyUse)it, type, context);
            }
            case 4: {
                return this.serialize((Rule)it, type, context);
            }
            case 5: {
                return this.serialize((RoleRule)it, type, context);
            }
            case 6: {
                return this.serialize((FunctionDefinition)it, type, context);
            }
            case 7: {
                throw new IllegalStateException("DCL Type not supported: " + it.getClass().getName());
            }
        }
        if (it instanceof Constant) {
            throw new IllegalStateException("DCL Type not supported: " + it.getClass().getName());
        }
        return null;
    }

    public static String getRuntimeRelationalOperatorName(String name) {
        switch (name) {
            case "<": {
                return "lt";
            }
            case "<=": {
                return "le";
            }
            case "=": {
                return "eq";
            }
            case "<>": {
                return "ne";
            }
            case ">=": {
                return "ge";
            }
            case ">": {
                return "gt";
            }
        }
        throw new IllegalArgumentException("Not a relational operator " + name);
    }

    private List<String> getDCLNames(EObject eObject, EStructuralFeature feature, boolean addScope) {
        List<INode> nodes = NodeModelUtils.findNodesForFeature(eObject, feature);
        if (DCLTools.hasContent(nodes)) {
            String text = NodeModelUtils.getTokenText(nodes.get(0));
            this.scanner.input(text);
            this.scanner.skipWhitespace();
            return this.scanner.scanQualifiedName(addScope);
        }
        return null;
    }

    protected Object crossReference(EObject container, EStructuralFeature feature, EObject target, String name) {
        if (target.eIsProxy()) {
            List<String> names = this.getDCLNames(container, feature, false);
            if (names != null && names.size() == 1) {
                ResourceLocation location = this.resourceHelper.getResourceLocation(container.eResource());
                location.getFullQualifiedDCLArray(names.get(0));
            }
            if (names == null) {
                return this.referenceAsString ? BROKEN_REFERENCE_STRING : BROKEN_REFERENCE_LIST;
            }
            return this.referenceAsString ? DataControlLanguageTools.encodeQualifiedName(names, this.buffer) : names;
        }
        return this.reference(target, name);
    }

    protected Object reference(EObject target, String name) {
        if (target.eIsProxy()) {
            throw new IllegalStateException();
        }
        ResourceLocation location = this.resourceHelper.getResourceLocation(target.eResource());
        if (location == null) {
            return this.referenceAsString ? BROKEN_REFERENCE_STRING : BROKEN_REFERENCE_LIST;
        }
        return this.referenceAsString ? location.getFullQualifiedDclName(name) : location.getFullQualifiedDCLArray(name);
    }

    public static List<String> getNames(IDList idList) {
        EList<String> names;
        if (idList != null && DCLTools.hasContent(names = idList.getNames())) {
            return names;
        }
        return null;
    }

    public static List<String> getNames(RoleList roleList) {
        EList<String> names;
        if (roleList != null && DCLTools.hasContent(names = roleList.getNames())) {
            return names;
        }
        return null;
    }

    protected boolean isInLocalPackage(Resource resource) {
        return this.resourceHelper.getResourceLocation(resource).isInLocalPackage();
    }
}

