/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.processors;

import com.google.inject.Inject;
import com.sap.cloud.security.ams.dcl.DCLResourceHelper;
import com.sap.cloud.security.ams.dcl.DCLTools;
import com.sap.cloud.security.ams.dcl.ResourceLocation;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerParameter;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerResult;
import com.sap.cloud.security.ams.dcl.generator.DCLFileSystemAccess2;
import com.sap.cloud.security.ams.dcl.generator.DCLResourceSetProcessor;
import com.sap.cloud.security.ams.dcl.generator.DataControlLanguageDefaultPackageGenerator;
import java.util.HashSet;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.generator.AbstractFileSystemAccess2;

public class DCLDefaultPackageProcessor
implements DCLResourceSetProcessor {
    @Inject
    private DCLResourceHelper dclResourceHelper;
    @Inject
    private DCLFileSystemAccess2 fsa;

    @Override
    public void process(ResourceSet resourceSet, DCLCompilerResult result, DCLResourceSetProcessor.State state) throws Exception {
        if (state == DCLResourceSetProcessor.State.ERROR) {
            return;
        }
        DCLCompilerParameter cp = result.getCompilerParameter();
        if (!cp.hasOutput()) {
            return;
        }
        if (!cp.isRegoGeneration()) {
            return;
        }
        HashSet<ResourceLocation> paths = new HashSet<ResourceLocation>();
        HashSet<String> pathIndex = new HashSet<String>();
        for (Resource resource : resourceSet.getResources()) {
            String path;
            ResourceLocation rl = this.dclResourceHelper.getResourceLocation(resource);
            if (!cp.isGenerateLocalPackage() && rl.isInLocalPackage() || pathIndex.contains(path = rl.getPath()) || !DCLTools.hasContent(path)) continue;
            pathIndex.add(rl.getPath());
            paths.add(rl);
        }
        DataControlLanguageDefaultPackageGenerator pg = new DataControlLanguageDefaultPackageGenerator();
        CharSequence content = pg.compileDefaultAPI(paths);
        AbstractFileSystemAccess2 fileAccess = this.fsa.getFileSystemAccess();
        fileAccess.generateFile("_dcl_api.rego", content);
    }
}

