/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.processors;

import com.google.common.collect.Iterators;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.sap.cloud.security.ams.dcl.DCLTools;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ActionList;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.DataControlLanguageFactory;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.Expression;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionIsRestricted;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.FunctionDefinition;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.PolicyDefinition;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.PolicyDocument;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ResourceList;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.RoleRule;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.Rule;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaAttribute;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaDefinition;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaMap;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaType;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerParameter;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerResult;
import com.sap.cloud.security.ams.dcl.generator.DCLResourceSetProcessor;
import com.sap.cloud.security.ams.dcl.generator.ResourceWriter;
import com.sap.cloud.security.ams.dcl.processors.DCLBaseSerializer;
import com.sap.cloud.security.ams.dcl.processors.GsonTools;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class DCLUIIndexSerializer
extends DCLBaseSerializer
implements DCLResourceSetProcessor {
    public static final String SUFFIX = ".uiindex";
    public static final String FILE_NAME = "_dcl_.uiindex";
    private final Gson gson;
    private boolean print = false;
    private DCLCompilerParameter cp;

    public DCLUIIndexSerializer(String config) {
        super(false, false);
        boolean pretty = false;
        String[] stringArray = config.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String cfg = stringArray[n2];
            if (cfg.equals("pretty")) {
                pretty = true;
            } else if (cfg.equals("print")) {
                this.print = true;
            }
            ++n2;
        }
        this.gson = this.createGson(pretty);
    }

    private Gson createGson(boolean pretty) {
        GsonBuilder builder = new GsonBuilder().disableHtmlEscaping().registerTypeHierarchyAdapter(EObject.class, this).serializeNulls();
        if (pretty) {
            builder.setPrettyPrinting();
        }
        return builder.create();
    }

    public DCLUIIndexSerializer(boolean pretty) {
        super(false, false);
        this.gson = this.createGson(pretty);
    }

    @Override
    public void process(ResourceSet resourceSet, DCLCompilerResult result, DCLResourceSetProcessor.State state) throws IOException {
        if (state == DCLResourceSetProcessor.State.MITIGATED) {
            return;
        }
        this.cp = result.getCompilerParameter();
        UIXRef ref = new UIXRef();
        for (Resource resource : resourceSet.getResources()) {
            PolicyDocument pd;
            if (!this.cp.isGenerateLocalPackage() && this.isInLocalPackage(resource) || (pd = DCLTools.getPolicyDocument(resource)) == null) continue;
            ref.policies.addAll(pd.getPolicies());
            ref.functions.addAll(pd.getFunctions());
            SchemaDefinition schema = pd.getSchema();
            if (schema != null && !schema.isTenant()) {
                ref.attributes = schema;
            }
            ref.addAllActionsResources(pd);
        }
        if (ref.attributes == null) {
            ref.attributes = DataControlLanguageFactory.eINSTANCE.createSchemaDefinition();
        }
        String res = this.gson.toJson(ref);
        ResourceWriter rw = this.cp.getResourceWriter();
        rw.write(FILE_NAME, res);
        if (this.cp.getSeverityPrinter() != null && this.print) {
            this.cp.println("UIIndex");
            this.cp.println("=======");
            this.cp.println(res);
            this.cp.println("=======");
        }
    }

    @Override
    protected JsonElement operator(JsonSerializationContext context, String name, Object ... elements) {
        if (elements.length > 2 && ("and".equals(name) || "or".equals(name))) {
            JsonElement el = this.operator(context, name, elements[0], elements[1]);
            int idx = 2;
            while (idx < elements.length) {
                el = this.operator(context, name, el, elements[idx]);
                ++idx;
            }
            return el;
        }
        JsonObject o = new JsonObject();
        GsonTools.add(context, o, "operator", name);
        GsonTools.opt(context, o, "args", elements);
        return o;
    }

    private static boolean hasRestrictions(PolicyDefinition policyDefinition) {
        Expression cond;
        for (Rule rule : policyDefinition.getRules()) {
            cond = rule.getCondition();
            if (cond == null || !(cond instanceof ExpressionIsRestricted) && !Iterators.filter(cond.eAllContents(), ExpressionIsRestricted.class).hasNext()) continue;
            return true;
        }
        for (RoleRule roleRule : policyDefinition.getRoleRules()) {
            cond = roleRule.getCondition();
            if (cond == null || !(cond instanceof ExpressionIsRestricted) && !Iterators.filter(cond.eAllContents(), ExpressionIsRestricted.class).hasNext()) continue;
            return true;
        }
        return false;
    }

    public JsonObject addSourceInformation(JsonSerializationContext context, JsonObject o, EObject eObject) {
        GsonTools.opt(context, o, "src:res", DCLTools.getSourceFile(this.cp, eObject.eResource()));
        GsonTools.opt(context, o, "src:pos", DCLTools.getSourcePosition(eObject));
        return o;
    }

    @Override
    protected JsonObject serialize(FunctionDefinition it, Type type, JsonSerializationContext context) {
        JsonObject res = super.serialize(it, type, context);
        this.addSourceInformation(context, res, it);
        return res;
    }

    @Override
    public JsonElement serialize(EObject it, Type type, JsonSerializationContext context) {
        JsonElement res = super.serialize(it, type, context);
        if (res != null) {
            return res;
        }
        if (it instanceof PolicyDefinition) {
            PolicyDefinition i = (PolicyDefinition)it;
            JsonObject o = new JsonObject();
            GsonTools.add(context, o, "policy", this.reference(i, i.getName()));
            GsonTools.opt(context, o, "description", DCLTools.getFirstStringAnnotation(i, "description"));
            GsonTools.add(context, o, "default", DCLTools.isDefault(i));
            GsonTools.optIfTrue(context, o, "internal", DCLTools.isInternal(i));
            GsonTools.opt(context, o, "label", DCLTools.getFirstStringAnnotation(i, "label"));
            GsonTools.add(context, o, "hasRestrictions", DCLUIIndexSerializer.hasRestrictions(i));
            if (i.getRules() != null) {
                ArrayList<Rule> rules = new ArrayList<Rule>(i.getRules());
                if (i.getRoleRules() != null) {
                    rules.addAll(i.getRoleRules());
                }
                GsonTools.add(context, o, "rules", rules);
            } else if (i.getRoleRules() != null) {
                GsonTools.add(context, o, "rules", i.getRoleRules());
            }
            GsonTools.opt(context, o, "uses", i.getUses());
            this.addSourceInformation(context, o, i);
            return o;
        }
        if (it instanceof SchemaMap) {
            SchemaMap i = (SchemaMap)it;
            return context.serialize(i.getEntries());
        }
        if (it instanceof SchemaAttribute) {
            SchemaAttribute i = (SchemaAttribute)it;
            SchemaType t = i.getType();
            SchemaMap nested = t.getNested();
            JsonObject o = new JsonObject();
            GsonTools.add(context, o, "type", nested == null ? t.getDataType().getLiteral() : context.serialize(nested));
            GsonTools.add(context, o, "id", i.getName());
            if (nested == null) {
                GsonTools.add(context, o, "isArray", t.isArray());
            }
            this.optAnnotations(o, i, context);
            return o;
        }
        return null;
    }

    public static class UIXRef {
        public Set<String> actions = new HashSet<String>();
        public Set<String> resources = new HashSet<String>();
        public List<PolicyDefinition> policies = new ArrayList<PolicyDefinition>();
        public List<FunctionDefinition> functions = new ArrayList<FunctionDefinition>();
        public SchemaMap attributes;

        public void addAllActionsResources(PolicyDocument pd) {
            for (PolicyDefinition pdef : pd.getPolicies()) {
                for (Rule pr : pdef.getRules()) {
                    ResourceList rl;
                    ActionList aL = pr.getActions();
                    if (aL != null) {
                        this.actions.addAll(aL.getNames());
                    }
                    if ((rl = pr.getResources()) == null) continue;
                    this.resources.addAll(rl.getNames());
                }
            }
        }
    }
}

