/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.processors;

import com.google.inject.Inject;
import com.sap.cloud.security.ams.dcl.DCLResourceHelper;
import com.sap.cloud.security.ams.dcl.DCLTools;
import com.sap.cloud.security.ams.dcl.client.dcn.DcnContainer;
import com.sap.cloud.security.ams.dcl.client.dcn.DcnTools;
import com.sap.cloud.security.ams.dcl.client.dcn.TestCase;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerParameter;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerResult;
import com.sap.cloud.security.ams.dcl.generator.DCLResourceSetProcessor;
import com.sap.cloud.security.ams.dcl.generator.DCLToDcnHelper;
import com.sap.cloud.security.ams.dcl.generator.ResourceWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class DcnSerializer
implements DCLResourceSetProcessor {
    public static final String PRETTY = "pretty";
    public static final String PRINT = "print";
    public static final String SUFFIX = "suffix:";
    public static final String ONOK = "onok";
    public static final String TESTONLY = "testsOnly";
    private static final String DCN_FILENAME = "combinedTests.dcn.test";
    private final Configuration configuration;
    @Inject
    private DCLToDcnHelper dclToDcnHelper;
    @Inject
    private DCLResourceHelper resourceHelper;

    public DcnSerializer(Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration);
    }

    public DcnSerializer(String config) {
        this(Configuration.fromConfig(config));
    }

    public DcnSerializer() {
        this(new Configuration());
    }

    @Override
    public void process(ResourceSet resourceSet, DCLCompilerResult result, DCLResourceSetProcessor.State state) throws Exception {
        if (this.configuration.isOnOk() && state == DCLResourceSetProcessor.State.ERROR) {
            return;
        }
        DcnTools.SerializationConfiguration sc = new DcnTools.SerializationConfiguration();
        sc.setPretty(this.configuration.isPretty());
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        DCLCompilerParameter cp = result.getCompilerParameter();
        ResourceWriter rw = cp.getResourceWriter();
        if (this.configuration.isTestsOnly()) {
            DcnContainer dcnContainer = new DcnContainer().version(1).testCases(new ArrayList<TestCase>());
            for (Resource resource : resourceSet.getResources()) {
                if (!cp.isGenerateLocalPackage() && this.isInLocalPackage(resource)) continue;
                dcnContainer.testCases().addAll(this.dclToDcnHelper.convertTestCases(DCLTools.getPolicyDocument(resource)));
            }
            this.dclToDcnHelper.addTestCaseLocations(dcnContainer, cp);
            byte[] data = DcnSerializer.toBytes(sc, bos, dcnContainer);
            rw.write(DCN_FILENAME, data);
        } else {
            boolean doPrint = this.configuration.isPrint() && cp.getSeverityPrinter() != null;
            for (Resource resource : resourceSet.getResources()) {
                if (!cp.isGenerateLocalPackage() && this.isInLocalPackage(resource)) continue;
                String fileName = cp.toRelativeSourcePath(resource);
                fileName = DCLTools.changeSuffix(fileName, this.configuration.getSuffix());
                byte[] data = this.createJSON(resource, result, sc, bos);
                rw.write(fileName, data);
                if (!doPrint) continue;
                cp.println("DCN: " + fileName);
                cp.println("=====");
                cp.println(new String(data, StandardCharsets.UTF_8));
                cp.println("=====");
            }
        }
    }

    protected byte[] createJSON(Resource resource, DCLCompilerResult result, DcnTools.SerializationConfiguration sc, ByteArrayOutputStream bos) throws IOException {
        DcnContainer container = this.dclToDcnHelper.convert(DCLTools.getPolicyDocument(resource));
        if (container == null) {
            return null;
        }
        return DcnSerializer.toBytes(sc, bos, container);
    }

    private static byte[] toBytes(DcnTools.SerializationConfiguration sc, ByteArrayOutputStream bos, DcnContainer container) throws IOException {
        bos.reset();
        DcnTools.getInstance().serialize((Object)container, bos, sc);
        return bos.toByteArray();
    }

    protected boolean isInLocalPackage(Resource resource) {
        return this.resourceHelper.getResourceLocation(resource).isInLocalPackage();
    }

    public static class Configuration {
        private boolean pretty = false;
        private boolean print = false;
        private String suffix = ".dcn";
        private boolean onOk = false;
        private boolean testsOnly = false;

        public boolean isPretty() {
            return this.pretty;
        }

        public void setPretty(boolean pretty) {
            this.pretty = pretty;
        }

        public static Configuration fromConfig(String config) {
            Configuration result = new Configuration();
            if (config != null) {
                String[] stringArray = config.split(";");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String cfg = stringArray[n2];
                    if (cfg.equals(DcnSerializer.PRETTY)) {
                        result.setPretty(true);
                    } else if (cfg.equals(DcnSerializer.PRINT)) {
                        result.setPrint(true);
                    } else if (cfg.startsWith(DcnSerializer.SUFFIX) && cfg.length() > DcnSerializer.SUFFIX.length()) {
                        result.setSuffix(cfg.substring(DcnSerializer.SUFFIX.length()));
                    } else if (cfg.equals(DcnSerializer.ONOK)) {
                        result.setOnOk(true);
                    } else if (cfg.equals(DcnSerializer.TESTONLY)) {
                        result.setTestsOnly(true);
                    }
                    ++n2;
                }
            }
            return result;
        }

        public boolean isPrint() {
            return this.print;
        }

        public void setPrint(boolean print) {
            this.print = print;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public void setSuffix(String suffix) {
            this.suffix = suffix;
        }

        public boolean isOnOk() {
            return this.onOk;
        }

        public void setOnOk(boolean onOk) {
            this.onOk = onOk;
        }

        public boolean isTestsOnly() {
            return this.testsOnly;
        }

        public void setTestsOnly(boolean testsOnly) {
            this.testsOnly = testsOnly;
        }
    }
}

