/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.processors;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.sap.cloud.security.ams.dcl.client.el.AttributeName;
import java.util.Collection;
import java.util.List;

public class GsonTools {
    public static final JsonPrimitive JSON_TRUE = new JsonPrimitive(true);
    public static final JsonPrimitive JSON_FALSE = new JsonPrimitive(false);

    private GsonTools() {
    }

    public static JsonPrimitive toPrimitive(boolean value) {
        return value ? JSON_TRUE : JSON_FALSE;
    }

    public static JsonArray toArray(List<String> values) {
        JsonArray arr = new JsonArray(values.size());
        int i = 0;
        while (i < values.size()) {
            arr.add(values.get(i));
            ++i;
        }
        return arr;
    }

    public static JsonObject ref(JsonElement target) {
        JsonObject jObject = new JsonObject();
        jObject.add("ref", target);
        return jObject;
    }

    public static void add(JsonSerializationContext context, JsonObject obj, String name, Object value) {
        if (value == null) {
            obj.addProperty(name, (String)value);
        } else if (value instanceof String) {
            obj.addProperty(name, (String)value);
        } else if (value instanceof Number) {
            obj.addProperty(name, (Number)value);
        } else if (value instanceof Boolean) {
            obj.addProperty(name, (Boolean)value);
        } else {
            obj.add(name, context.serialize(value));
        }
    }

    public static JsonObject optIfTrue(JsonSerializationContext context, JsonObject obj, String name, boolean value) {
        if (value) {
            obj.add(name, JSON_TRUE);
        }
        return obj;
    }

    public static JsonObject opt(JsonSerializationContext context, JsonObject obj, String name, Object value) {
        if (value == null) {
            return obj;
        }
        if (value instanceof Object[] && ((Object[])value).length == 0) {
            return obj;
        }
        if (value instanceof Collection && ((Collection)value).isEmpty()) {
            return obj;
        }
        GsonTools.add(context, obj, name, value);
        return obj;
    }

    public static JsonObject object(String name, JsonElement element) {
        JsonObject jObject = new JsonObject();
        jObject.add(name, element);
        return jObject;
    }

    public static Integer getMemberAsInt(JsonObject o, String memberName) {
        JsonElement el = o.get(memberName);
        return el != null && !el.isJsonNull() ? Integer.valueOf(el.getAsInt()) : null;
    }

    public static String getMemberAsString(JsonObject o, String memberName) {
        JsonElement el = o.get(memberName);
        return el != null && !el.isJsonNull() ? el.getAsString() : null;
    }

    public static boolean getMemberAsBoolean(JsonObject o, String memberName) {
        JsonElement el = o.get(memberName);
        return el != null && !el.isJsonNull() && el.getAsBoolean();
    }

    public static JsonObject serializeAttributeName(AttributeName an) {
        JsonArray anArray = new JsonArray(an.size());
        int i = 0;
        while (i < an.size()) {
            anArray.add(an.getSegment(i));
            ++i;
        }
        return GsonTools.ref(anArray);
    }
}

