/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.scoping;

import com.google.inject.Inject;
import com.sap.cloud.security.ams.dcl.DCLMtTools;
import com.sap.cloud.security.ams.dcl.DCLResourceHelper;
import com.sap.cloud.security.ams.dcl.DCLTools;
import com.sap.cloud.security.ams.dcl.ResourceLocation;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.DataControlLanguagePackage;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.JMapEntry;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.PolicyUse;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaAttribute;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaMap;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaType;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerResultAccessor;
import com.sap.cloud.security.ams.dcl.generator.DCLPerCompileAllCaches;
import com.sap.cloud.security.ams.dcl.scoping.AbstractDataControlLanguageScopeProvider;
import com.sap.cloud.security.ams.dcl.scoping.InTenantPredicate;
import com.sap.cloud.security.ams.dcl.scoping.InUsingListPredicate;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.FilteringScope;

public class DataControlLanguageScopeProvider
extends AbstractDataControlLanguageScopeProvider {
    @Inject
    private DCLResourceHelper dclResourceHelper;
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;
    @Inject
    private IContainer.Manager containerManager;
    @Inject
    private DCLCompilerResultAccessor cra;
    @Inject
    private DCLPerCompileAllCaches cache;

    private static JMapEntry getParentJMapEntry(EObject it) {
        if (it != null) {
            EObject parent = it.eContainer();
            if (parent instanceof JMapEntry) {
                return (JMapEntry)parent;
            }
            if (parent != null && (parent = parent.eContainer()) instanceof JMapEntry) {
                return (JMapEntry)parent;
            }
        }
        return null;
    }

    private static List<SchemaAttribute> getNestedSchemaElements(SchemaAttribute root) {
        EList<SchemaAttribute> entries;
        SchemaMap nested;
        SchemaType type;
        if (root != null && (type = root.getType()) != null && (nested = type.getNested()) != null && DCLTools.hasContent(entries = nested.getEntries())) {
            return entries;
        }
        return Collections.emptyList();
    }

    @Override
    public IScope getScope(EObject context, EReference reference) {
        if (reference == DataControlLanguagePackage.Literals.JMAP_ENTRY__SCHEMA_ATTRIBUTE) {
            JMapEntry parent = DataControlLanguageScopeProvider.getParentJMapEntry(context);
            if (parent == null) {
                IScope scope = this.getScope(DCLTools.getPolicyDocument(context.eResource()), DataControlLanguagePackage.Literals.SCHEMA_MAP__ENTRIES);
                return new FilteringScope(scope, od -> od.getName().getSegmentCount() == 1);
            }
            return Scopes.scopeFor(DataControlLanguageScopeProvider.getNestedSchemaElements(parent.getSchemaAttribute()), se -> QualifiedName.create(se.getName()), IScope.NULLSCOPE);
        }
        IScope scope = super.getScope(context, reference);
        Resource currentResource = context.eResource();
        ResourceLocation location = this.dclResourceHelper.getResourceLocation(currentResource);
        scope = this.addPackageScopeFilter(currentResource, location, scope);
        if (DCLMtTools.isUsingSupport(this.cra)) {
            if (!this.cache.isInitialized()) {
                InUsingListPredicate.buildUsingPackagesLut(currentResource, this.resourceDescriptionsProvider, this.cache.getOrCreate());
            }
            scope = this.addUsingListScopeFilter(currentResource, location, scope);
        }
        scope = this.addSelfFilter(context, scope);
        return scope;
    }

    private IScope addPackageScopeFilter(Resource currentResource, ResourceLocation location, IScope scope) {
        return new FilteringScope(scope, new InTenantPredicate(location, this.resourceDescriptionsProvider, this.containerManager, currentResource));
    }

    private IScope addUsingListScopeFilter(Resource currentResource, ResourceLocation location, IScope scope) {
        return new FilteringScope(scope, new InUsingListPredicate(this.resourceDescriptionsProvider, currentResource, location, this.cache.getOrCreate()));
    }

    private IScope addSelfFilter(EObject context, IScope scope) {
        if (context instanceof PolicyUse) {
            EObject pd = context.eContainer();
            return new FilteringScope(scope, od -> !Objects.equals(pd, od.getEObjectOrProxy()));
        }
        return scope;
    }
}

