/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.scoping;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.sap.cloud.security.ams.dcl.DCLMtTools;
import com.sap.cloud.security.ams.dcl.ResourceLocation;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.DataControlLanguagePackage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;

public class InTenantPredicate
implements Predicate<IEObjectDescription> {
    private static final EClass SCHEMA_DEFINITION = DataControlLanguagePackage.eINSTANCE.getSchemaDefinition();
    private final Resource resource;
    private final ResourceLocation resourceLocation;
    private final ResourceDescriptionsProvider resourceDescriptionsProvider;
    private final IContainer.Manager containerManager;
    private Map<QualifiedName, Boolean> tenantPackage;

    public InTenantPredicate(ResourceLocation resourceLocation, ResourceDescriptionsProvider resourceDescriptionsProvider, IContainer.Manager containerManager, Resource resource) {
        this.resource = resource;
        this.resourceLocation = resourceLocation;
        this.resourceDescriptionsProvider = resourceDescriptionsProvider;
        this.containerManager = containerManager;
    }

    private boolean isInTenantPackageCalculation(QualifiedName qn) {
        Iterator<Object> it;
        IResourceDescriptions index = this.resourceDescriptionsProvider.getResourceDescriptions(this.resource);
        IResourceDescription resourceDescription = index.getResourceDescription(this.resource.getURI());
        List<IContainer> visibleContainers = this.containerManager.getVisibleContainers(resourceDescription, index);
        QualifiedName qnSchema = qn.append("schema");
        switch (visibleContainers.size()) {
            case 0: {
                return false;
            }
            case 1: {
                it = visibleContainers.get(0).getExportedObjects(SCHEMA_DEFINITION, qnSchema, false).iterator();
                break;
            }
            default: {
                it = Iterators.concat(Iterators.transform(visibleContainers.iterator(), vc -> vc.getExportedObjects(SCHEMA_DEFINITION, qnSchema, false).iterator()));
            }
        }
        if (it.hasNext()) {
            IEObjectDescription tenantSchema = (IEObjectDescription)it.next();
            return tenantSchema != null && tenantSchema.getUserData("tenant") != null;
        }
        return false;
    }

    protected boolean isInTenantPackage(QualifiedName qname) {
        if (this.tenantPackage == null) {
            this.tenantPackage = new HashMap<QualifiedName, Boolean>();
        }
        return this.tenantPackage.computeIfAbsent(qname, this::isInTenantPackageCalculation);
    }

    @Override
    public boolean apply(IEObjectDescription od) {
        EObject obj = od.getEObjectOrProxy();
        if (obj == null) {
            return true;
        }
        if (!DCLMtTools.isReferenceableElement(od.getEObjectOrProxy())) {
            return true;
        }
        QualifiedName qname = od.getQualifiedName();
        if (this.getResourceLocation().isSamePackage(qname)) {
            return true;
        }
        if (qname.getSegmentCount() < 2) {
            return false;
        }
        return !this.isInTenantPackage(qname.skipLast(1));
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }
}

