/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.scoping;

import com.google.common.base.Predicate;
import com.sap.cloud.security.ams.dcl.DCLMtTools;
import com.sap.cloud.security.ams.dcl.ResourceLocation;
import com.sap.cloud.security.ams.dcl.client.el.QualifiedNamesBuilder;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.Annotation;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionArray;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionConstant;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionString;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaDefinition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;

public class InUsingListPredicate
implements Predicate<IEObjectDescription> {
    private static final QualifiedNamesBuilder NAMES_BUILDER = new QualifiedNamesBuilder();
    private final Resource resource;
    private final ResourceLocation resourceLocation;
    Map<Resource, Optional<Set<QualifiedName>>> usingPackagesLut;

    public InUsingListPredicate(ResourceDescriptionsProvider resourceDescriptionsProvider, Resource resource, ResourceLocation resourceLocation, Map<Resource, Optional<Set<QualifiedName>>> cache) {
        this.resource = resource;
        this.usingPackagesLut = cache;
        this.resourceLocation = resourceLocation;
    }

    public static void buildUsingPackagesLut(Resource resource, ResourceDescriptionsProvider resourceDescriptionsProvider, Map<Resource, Optional<Set<QualifiedName>>> cache) {
        IResourceDescriptions index = resourceDescriptionsProvider.getResourceDescriptions(resource);
        HashMap<URI, Set<QualifiedName>> usingPackagesLut = new HashMap<URI, Set<QualifiedName>>();
        for (IResourceDescription rd : index.getAllResourceDescriptions()) {
            for (IEObjectDescription od : rd.getExportedObjects()) {
                SchemaDefinition sd;
                EObject o = od.getEObjectOrProxy();
                if (!(o instanceof SchemaDefinition) || !(sd = (SchemaDefinition)o).isTenant()) continue;
                EList<Annotation> annotations = sd.getAnnotations();
                annotations.forEach(a -> {
                    ExpressionConstant value;
                    if ("using".equals(a.getId()) && (value = a.getValue()) instanceof ExpressionArray) {
                        HashSet packageNames = new HashSet(((ExpressionArray)value).getValues().size());
                        ((ExpressionArray)value).getValues().forEach(v -> {
                            if (v instanceof ExpressionString) {
                                packageNames.add(QualifiedName.create(NAMES_BUILDER.parseQualifiedName(((ExpressionString)v).getValue()).getSegments()));
                            }
                        });
                        usingPackagesLut.put(rd.getURI().trimSegments(1), packageNames);
                    }
                });
            }
        }
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet != null) {
            for (IResourceDescription rd : index.getAllResourceDescriptions()) {
                Resource r = resourceSet.getResource(rd.getURI(), true);
                Optional<Set<QualifiedName>> usingPackages = InUsingListPredicate.findAllowedPackagesforResource(r, usingPackagesLut);
                cache.put(r, usingPackages);
            }
        }
    }

    public static Optional<Set<QualifiedName>> findAllowedPackagesforResource(Resource resource, Map<URI, Set<QualifiedName>> lut) {
        URI uri = resource.getURI().trimSegments(1);
        while (uri.segments().length > 2) {
            if (lut.containsKey(uri)) {
                return Optional.of(lut.get(uri));
            }
            uri = uri.trimSegments(1);
        }
        return Optional.empty();
    }

    @Override
    public boolean apply(IEObjectDescription od) {
        EObject obj = od.getEObjectOrProxy();
        if (obj == null) {
            return true;
        }
        if (!DCLMtTools.isReferenceableElement(od.getEObjectOrProxy())) {
            return true;
        }
        QualifiedName qname = od.getQualifiedName();
        if (this.resourceLocation.isSamePackage(qname)) {
            return true;
        }
        if (qname.getSegmentCount() < 2) {
            return false;
        }
        Optional<Set<QualifiedName>> usingPackages = this.usingPackagesLut.get(this.resource);
        if (usingPackages != null && usingPackages.isPresent()) {
            Set<QualifiedName> up = usingPackages.get();
            if (up.isEmpty()) {
                return false;
            }
            return up.contains(od.getQualifiedName().skipLast(1));
        }
        return true;
    }
}

