/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.scoping;

import com.google.common.collect.Iterables;
import java.io.PrintStream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

public class TracingIScope
implements IScope {
    private static final PrintStream OUT = System.out;
    private IScope delegate;

    TracingIScope(IScope delegate) {
        this.delegate = delegate;
    }

    @Override
    public IEObjectDescription getSingleElement(QualifiedName name) {
        OUT.println("getSingleElement: " + String.valueOf(name));
        IEObjectDescription res = this.delegate.getSingleElement(name);
        OUT.println(res != null ? "found" : "not found");
        return res;
    }

    @Override
    public Iterable<IEObjectDescription> getElements(QualifiedName name) {
        OUT.println("getElements: " + String.valueOf(name));
        Iterable<IEObjectDescription> res = this.delegate.getElements(name);
        OUT.println(!Iterables.isEmpty(res) ? "found" : "not found");
        return res;
    }

    @Override
    public IEObjectDescription getSingleElement(EObject object) {
        OUT.println("getSingleElement(EObject)");
        return this.delegate.getSingleElement(object);
    }

    @Override
    public Iterable<IEObjectDescription> getElements(EObject object) {
        OUT.println("getElements(EObject)");
        return this.delegate.getElements(object);
    }

    @Override
    public Iterable<IEObjectDescription> getAllElements() {
        OUT.println("getAllElements()");
        return this.delegate.getAllElements();
    }
}

