/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.spi.dcn;

import com.sap.cloud.security.ams.dcl.client.dcn.DcnContainer;
import com.sap.cloud.security.ams.dcl.client.dcn.TestAssertion;
import com.sap.cloud.security.ams.dcl.client.dcn.TestCase;
import com.sap.cloud.security.ams.dcl.client.dcn.TestInput;
import com.sap.cloud.security.ams.dcl.client.el.QualifiedName;
import com.sap.cloud.security.ams.dcl.client.pdp.Attributes;
import com.sap.cloud.security.ams.dcl.spi.dcn.ComparisonMode;
import com.sap.cloud.security.ams.dcl.spi.dcn.DcnTestTools;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class DcnTestDriver {
    static final String UNKNOWN = "<<unknown>>";
    private static final String COMPARISON = "comparison";
    private static final List<?> SINGLETON_NULL_LIST = Collections.singletonList(null);
    private final Map<TestCase, String> testCaseToFileName = new HashMap<TestCase, String>();
    private final DcnContainer container;
    private final StackTraceElement[] callStack;
    private QualifiedName currentTestCaseQualifiedName;
    protected String currentFileName;
    protected int currentLineNumber;
    protected int currentColumn;

    protected DcnTestDriver(DcnContainer container) {
        this.container = Objects.requireNonNull(container);
        this.callStack = this.createTestStack(new RuntimeException());
    }

    private List<TestCase> testCases() {
        List<TestCase> tcs = this.container.testCases();
        return tcs == null ? Collections.emptyList() : tcs;
    }

    public QualifiedName getCurrentTestCaseQualifiedName() {
        return this.currentTestCaseQualifiedName;
    }

    public void iterate() throws Exception {
        this.iterate("");
    }

    protected List<TestCase> processTestCases(List<TestCase> testCases) {
        if (!DcnTestDriver.hasContent(testCases)) {
            return testCases;
        }
        ArrayList<TestCase> res = new ArrayList<TestCase>(testCases);
        Collections.sort(res, (o1, o2) -> this.getFileName((TestCase)o1).compareTo(this.getFileName((TestCase)o2)));
        return res;
    }

    protected String getFileName(TestCase testCase) {
        String res = this.testCaseToFileName.get(testCase);
        return res != null ? res : UNKNOWN;
    }

    public void iterate(String basePath) throws Exception {
        boolean hasBasePath = DcnTestDriver.hasContent(basePath);
        basePath = DcnTestDriver.normalizeFileName(basePath);
        this.populateTestCaseToFileNameMap(basePath);
        for (TestCase testCase : this.processTestCases(this.testCases())) {
            this.currentTestCaseQualifiedName = testCase.qualifiedName();
            Map testCaseMeta = (Map)DcnTestTools.navigate(this.container.metadata(), (Object)"$dcn", (Object)"testCases", (Object)this.currentTestCaseQualifiedName);
            this.computeCurrentFileName(testCaseMeta, basePath);
            int testAssertionIdx = 0;
            for (TestAssertion testAssertion : testCase.testAssertions()) {
                this.computeTestAssertionSourcePosition(testCaseMeta, ++testAssertionIdx - 1);
                ComparisonMode cm = ComparisonMode.DEFAULT;
                if (DcnTestDriver.hasContent(testAssertion.annotations())) {
                    cm = ComparisonMode.fromString((String)testAssertion.annotations().get(COMPARISON));
                }
                List<String> actions = DcnTestDriver.getAtLeastSingletonList(testAssertion.actions());
                List<String> resources = DcnTestDriver.getAtLeastSingletonList(testAssertion.resources());
                List<String> policies = DcnTestDriver.toEncodedStringsOrNull(testAssertion.policies());
                List<String> scopeFilterPolicies = DcnTestDriver.toEncodedStringsOrNull(testAssertion.scopeFilter());
                int inputIdx = 0;
                List<TestInput> testInputs = testAssertion.testInputs();
                if (testInputs == null) {
                    TestInput testInput = new TestInput();
                    testInputs = new ArrayList<TestInput>(1);
                    testInputs.add(testInput);
                }
                for (TestInput testInput : testInputs) {
                    ++inputIdx;
                    for (String action : actions) {
                        for (String resource : resources) {
                            Attributes attributes;
                            Attributes attributes2 = attributes = testInput.content() != null ? DcnTestTools.toAttributes(testInput) : Attributes.create();
                            if (DcnTestDriver.hasContent(action)) {
                                attributes.setAction(action);
                            }
                            if (DcnTestDriver.hasContent(resource)) {
                                attributes.setResource(resource);
                            }
                            if (DcnTestDriver.hasContent(policies)) {
                                attributes.setPolicies(policies);
                            }
                            if (DcnTestDriver.hasContent(scopeFilterPolicies)) {
                                attributes.setScopeFilterPolicies(scopeFilterPolicies);
                            }
                            String name = this.currentTestCaseQualifiedName.toEncodedString() + " (Assertion:" + testAssertionIdx + ", Input:" + inputIdx + ") " + attributes + "\n";
                            URI uri = null;
                            if (hasBasePath && this.currentLineNumber != -1) {
                                uri = new URI("classpath:/" + this.currentFileName.replace('\\', '/') + "?line=" + this.currentLineNumber + "&column=" + this.currentColumn);
                            }
                            Object expect = testAssertion.expect();
                            this.process(name, uri, attributes, cm, expect);
                        }
                    }
                }
            }
        }
    }

    private void populateTestCaseToFileNameMap(String basePath) {
        for (TestCase testCase : this.testCases()) {
            Map testCaseMeta = (Map)DcnTestTools.navigate(this.container.metadata(), (Object)"$dcn", (Object)"testCases", (Object)this.currentTestCaseQualifiedName);
            String name = null;
            if (testCaseMeta != null) {
                name = DcnTestTools.castOrNull(String.class, DcnTestTools.navigate((Object)testCaseMeta, (Object)"srcFile"));
            }
            this.testCaseToFileName.put(testCase, (String)(DcnTestDriver.hasContent(name) ? basePath + name : UNKNOWN));
        }
    }

    static String normalizeFileName(String fileName) {
        if (DcnTestDriver.hasContent(fileName)) {
            int start;
            fileName = fileName.replace('\\', '/');
            int end = fileName.length();
            for (start = 0; end > start && fileName.charAt(start) == '/'; ++start) {
            }
            while (end > start && fileName.charAt(end - 1) == '/') {
                --end;
            }
            if (start == 0 && end == fileName.length() - 1) {
                return fileName;
            }
            if (end > start) {
                return fileName.substring(start, end) + "/";
            }
        }
        return "<<unknown>>/";
    }

    private void computeCurrentFileName(Map<String, Object> testCaseMeta, String basePath) {
        String name = DcnTestTools.castOrNull(String.class, DcnTestTools.navigate(testCaseMeta, (Object)"srcFile"));
        this.currentFileName = DcnTestDriver.hasContent(name) ? basePath + name : UNKNOWN;
    }

    private void computeTestAssertionSourcePosition(Map<String, Object> testCaseMeta, int testAssertionIdx) {
        int[] pArray;
        Object position = DcnTestTools.navigate(testCaseMeta, (Object)"testAssertions", (Object)testAssertionIdx, (Object)"srcPosition");
        if (position instanceof List) {
            List pList = (List)position;
            if (pList.size() == 4) {
                this.currentLineNumber = ((Number)pList.get(0)).intValue();
                this.currentColumn = ((Number)pList.get(1)).intValue();
                return;
            }
        } else if (position instanceof int[] && (pArray = (int[])position).length == 4) {
            this.currentLineNumber = pArray[0];
            this.currentColumn = pArray[1];
            return;
        }
        this.currentLineNumber = -1;
        this.currentColumn = -1;
    }

    private StackTraceElement[] createTestStack(RuntimeException root) {
        StackTraceElement[] callStack;
        int idx = -1;
        int start = 0;
        boolean moveStart = true;
        for (StackTraceElement ste : callStack = root.getStackTrace()) {
            ++idx;
            if (moveStart && ste.getMethodName().equals("<init>")) {
                start = idx;
            } else {
                moveStart = false;
            }
            if (!ste.getClassName().contains("NativeMethodAccessorImpl")) continue;
            return Arrays.copyOfRange(callStack, start, idx);
        }
        return callStack;
    }

    private static List<String> toEncodedStringsOrNull(List<QualifiedName> coll) {
        ArrayList<String> res = null;
        if (DcnTestDriver.hasContent(coll)) {
            res = new ArrayList<String>(coll.size());
            for (QualifiedName qn : coll) {
                res.add(qn.toEncodedString());
            }
        }
        return res;
    }

    private static <T> List<T> getAtLeastSingletonList(List<T> it) {
        return it == null || it.isEmpty() ? SINGLETON_NULL_LIST : it;
    }

    private static boolean hasContent(String string) {
        return string != null && !string.isEmpty();
    }

    private static boolean hasContent(Map<?, ?> map) {
        return map != null && !map.isEmpty();
    }

    private static boolean hasContent(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    protected void patchStack(Throwable e, QualifiedName qn, String fileName, int lineNumber) {
        StackTraceElement location;
        StackTraceElement[] stes = (StackTraceElement[])this.callStack.clone();
        String encodedString = qn.toEncodedString();
        int pos = encodedString.lastIndexOf(46);
        String a = encodedString.substring(0, pos);
        String b = encodedString.substring(pos + 1);
        stes[0] = location = new StackTraceElement(a, b, fileName, lineNumber);
        e.setStackTrace(stes);
    }

    protected abstract void process(String var1, URI var2, Attributes var3, ComparisonMode var4, Object var5) throws Exception;
}

