/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.spi.dcn;

import com.sap.cloud.security.ams.dcl.client.dcn.TestInput;
import com.sap.cloud.security.ams.dcl.client.el.AttributeName;
import com.sap.cloud.security.ams.dcl.client.el.Call;
import com.sap.cloud.security.ams.dcl.client.el.QualifiedName;
import com.sap.cloud.security.ams.dcl.client.pdp.Attributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DcnTestTools {
    private DcnTestTools() {
    }

    public static Object sortedDclExpression(Object x) {
        if (x instanceof Call) {
            Call c = (Call)x;
            if (c.getQualifiedName().equals(Call.QualifiedNames.AND) || c.getQualifiedName().equals(Call.QualifiedNames.OR)) {
                ArrayList<Object> args = new ArrayList<Object>(c.getArgumentCount());
                for (Object arg : c.getArguments()) {
                    args.add(DcnTestTools.sortedDclExpression(arg));
                }
                Collections.sort(args, (o1, o2) -> {
                    if (o1 == null) {
                        if (o2 != null) {
                            return -1;
                        }
                        return 0;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    boolean o2call = o2 instanceof Call;
                    if (o1 instanceof Call) {
                        if (!o2call) {
                            return -1;
                        }
                    } else if (o2call) {
                        return 1;
                    }
                    if (o1.getClass() == o2.getClass() && o1 instanceof Comparable) {
                        return ((Comparable)o1).compareTo(o2);
                    }
                    int res = o1.hashCode() - o2.hashCode();
                    if (res == 0 && !Objects.equals(o1, o2)) {
                        throw new IllegalStateException("Cannot order objects for simple sorting. (" + o1 + " , " + o2 + ")");
                    }
                    return res;
                });
                return Call.createFrom(c.getQualifiedName(), args);
            }
            if ((c.getQualifiedName().equals(Call.QualifiedNames.EQ) || c.getQualifiedName().equals(Call.QualifiedNames.NE)) && c.getArgumentCount() == 2 && DcnTestTools.shouldSwapOperands(c.getArgument(0), c.getArgument(1))) {
                return Call.create(c.getQualifiedName(), c.getArgument(1), c.getArgument(0));
            }
        }
        return x;
    }

    public static boolean shouldSwapOperands(Object arg0, Object arg1) {
        return arg1 instanceof AttributeName && (!(arg0 instanceof AttributeName) || ((AttributeName)arg0).compareTo((AttributeName)arg1) > 0);
    }

    public static Attributes toAttributes(TestInput tcid) {
        Attributes attributes = Attributes.create(tcid.content());
        attributes.setUnknowns(tcid.unknowns());
        attributes.setIgnores(tcid.ignores());
        return attributes;
    }

    public static Object navigate(Object je, Object path) {
        if (je == null) {
            return null;
        }
        if (je instanceof Map && path instanceof String) {
            return ((Map)je).get(path);
        }
        if (je instanceof Map && path instanceof QualifiedName) {
            return ((Map)je).get(((QualifiedName)path).toEncodedString());
        }
        if (je instanceof List && path instanceof Integer) {
            List list = (List)je;
            int index = (Integer)path;
            if (index >= 0 && index < list.size()) {
                return list.get(index);
            }
        }
        return null;
    }

    public static Object navigate(Object je, Object p1, Object p2) {
        return DcnTestTools.navigate(DcnTestTools.navigate(je, p1), p2);
    }

    public static Object navigate(Object je, Object p1, Object p2, Object p3) {
        return DcnTestTools.navigate(DcnTestTools.navigate(je, p1, p2), p3);
    }

    public static Object navigate(Object je, Object ... path) {
        Object p;
        Object[] objectArray = path;
        int n = objectArray.length;
        for (int i = 0; i < n && (je = DcnTestTools.navigate(je, p = objectArray[i])) != null; ++i) {
        }
        return je;
    }

    public static <T> T castOrNull(Class<T> type, Object value) {
        return type.isInstance(value) ? (T)type.cast(value) : null;
    }
}

