/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.spi.dcn.tools;

import com.sap.cloud.security.ams.dcl.client.annotation.Beta;
import com.sap.cloud.security.ams.dcl.client.dcn.DataType;
import com.sap.cloud.security.ams.dcl.client.dcn.DcnContainer;
import com.sap.cloud.security.ams.dcl.client.dcn.Function;
import com.sap.cloud.security.ams.dcl.client.dcn.Policy;
import com.sap.cloud.security.ams.dcl.client.dcn.Rule;
import com.sap.cloud.security.ams.dcl.client.dcn.Schema;
import com.sap.cloud.security.ams.dcl.client.dcn.SchemaAttribute;
import com.sap.cloud.security.ams.dcl.client.dcn.TestAssertion;
import com.sap.cloud.security.ams.dcl.client.dcn.TestCase;
import com.sap.cloud.security.ams.dcl.client.dcn.TestInput;
import com.sap.cloud.security.ams.dcl.client.dcn.Use;
import com.sap.cloud.security.ams.dcl.client.el.AttributeName;
import com.sap.cloud.security.ams.dcl.client.el.Call;
import com.sap.cloud.security.ams.dcl.client.el.IQualifiedName;
import com.sap.cloud.security.ams.dcl.client.el.QualifiedName;
import com.sap.cloud.security.ams.dcl.client.language.DataControlLanguageTools;
import com.sap.cloud.security.ams.dcl.client.language.TokenFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Beta
public class DcnToDclSerializer {
    private static final String COMMA_SEPARATOR = ", ";
    private final StringBuilder sb = new StringBuilder();
    private static final String[] INDENTS = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         ", "          ", "           ", "            ", "             ", "              ", "               ", "                ", "                 ", "                  ", "                   "};
    private static final String MAX_INDENT = INDENTS[INDENTS.length - 1];
    private static final int MAX_INDENT_LEN = MAX_INDENT.length();
    private int indent;
    private boolean skipBracket = false;
    private static final String[] ESCAPED = new String[93];

    protected void indent() {
        this.indent(this.indent);
    }

    protected void indent(int i) {
        this.addSpaces(i * 2);
    }

    protected void open() {
        ++this.indent;
    }

    protected void close() {
        --this.indent;
    }

    protected void addSpaces(int count) {
        if (count <= 0) {
            return;
        }
        while (count >= MAX_INDENT_LEN) {
            this.sb.append(MAX_INDENT);
            count -= MAX_INDENT_LEN;
        }
        this.sb.append(INDENTS[count]);
    }

    public void clear() {
        this.sb.setLength(0);
        this.indent = 0;
    }

    public String toString() {
        return this.sb.toString();
    }

    private void appendIdentifier(String name) {
        if (TokenFormat.DCL_IDENTIFIER.isToken(name)) {
            this.sb.append(name);
        } else {
            DataControlLanguageTools.appendQuotedString(this.sb, name);
        }
    }

    private void appendLastSegment(QualifiedName qName) {
        this.appendIdentifier(qName.getLastSegment());
    }

    private void appendQualifiedName(QualifiedName target, QualifiedName context) {
        if (context != null && target.startsWith(context)) {
            this.appendIdentifier(target.getLastSegment());
        } else {
            int end = target.size() - 1;
            for (int i = 0; i <= end; ++i) {
                if (i != 0) {
                    this.append('.');
                }
                this.appendIdentifier(target.getSegment(i));
            }
        }
    }

    private void appendAttributeName(IQualifiedName<?> qName) {
        boolean second = false;
        int end = qName.size() - 1;
        for (int i = 0; i <= end; ++i) {
            String segment = qName.getSegment(i);
            if (second) {
                this.append('.');
            } else {
                if (i == 0 && ("$app".equals(segment) || "$env".equals(segment))) continue;
                second = true;
            }
            this.appendIdentifier(segment);
        }
    }

    private boolean hasContent(Map<?, ?> map) {
        return map != null && !map.isEmpty();
    }

    private static boolean isEmpty(Collection<?> col) {
        return col == null || col.isEmpty();
    }

    private static boolean hasContent(String value) {
        return value != null && !value.isEmpty();
    }

    private static boolean hasContent(Collection<?> col) {
        return col != null && !col.isEmpty();
    }

    private static <T> List<T> emptify(List<T> coll) {
        return DcnToDclSerializer.isEmpty(coll) ? Collections.emptyList() : coll;
    }

    private void serializeAnnotations(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Object> annotations : map.entrySet()) {
            this.indent();
            this.append('@');
            this.append(annotations.getKey());
            this.append(':');
            this.space();
            this.serializeExpression(annotations.getValue());
            this.nl();
        }
    }

    public void serialize(Function it) {
        this.indent();
        this.append("FUNCTION");
        this.space();
        this.append(it.returnType().getText());
        this.space();
        this.appendLastSegment(it.qualifiedName());
        this.append("()");
        this.append("{");
        this.nl();
        this.open();
        this.indent();
        this.serializeExpression("RETURN", it.result());
        this.append(";");
        this.nl();
        this.close();
        this.append("}");
    }

    public void serialize(Policy it) {
        this.serializeAnnotations(it.annotations());
        this.indent();
        if (it.internal()) {
            this.append("INTERNAL ");
        }
        if (it.defaultPolicy()) {
            this.append("DEFAULT ");
        }
        this.append("POLICY");
        this.space();
        this.appendLastSegment(it.qualifiedName());
        this.space();
        this.append('{');
        this.nl();
        this.open();
        QualifiedName context = (QualifiedName)it.qualifiedName().subName(0, it.qualifiedName().size() - 1);
        for (Rule rule : DcnToDclSerializer.emptify(it.rules())) {
            this.serialize(rule, context);
        }
        for (Use use : DcnToDclSerializer.emptify(it.uses())) {
            this.serialize(use, it.qualifiedName());
        }
        this.close();
        this.append('}');
    }

    private void serialize(Rule it, QualifiedName context) {
        this.indent();
        this.append(it.effect().toString());
        this.space();
        this.serializeStarList(it.actions());
        this.space();
        this.append("ON");
        this.space();
        this.serializeStarList(it.resources());
        this.serializeExpression("WHERE", it.condition());
        this.append(';');
        this.nl();
    }

    private void serialize(Use it, QualifiedName context) {
        this.indent();
        this.append("USE");
        this.space();
        this.appendQualifiedName(it.qualifiedPolicyName(), context);
        boolean second = false;
        for (List<Call> restrict : DcnToDclSerializer.emptify(it.restrictions())) {
            if (second) {
                this.nl();
                this.indent();
            } else {
                second = true;
            }
            this.serializeRestrict(restrict);
        }
        this.append(';');
        this.nl();
    }

    public void serialize(Schema it) {
        this.serializeAnnotations(it.annotations());
        if (DcnToDclSerializer.hasContent(it.tenant())) {
            this.append("TENANT");
            this.space();
            this.append("SCHEMA");
            this.space();
            this.appendStringConstant(it.tenant());
        } else {
            this.append("SCHEMA");
        }
        this.space();
        SchemaAttribute schemaAtt = it.definition();
        if (schemaAtt != null) {
            this.append('{');
            this.open();
            if (this.hasContent(schemaAtt.nested())) {
                boolean first = true;
                for (Map.Entry<String, SchemaAttribute> entry : schemaAtt.nested().entrySet()) {
                    if ("$dcl".equals(entry.getKey())) continue;
                    first = this.serializeNested(entry.getValue(), first);
                }
            }
            this.grantNl();
            this.close();
            this.indent();
            this.append('}');
        }
    }

    private boolean serializeNested(SchemaAttribute schemaAtt, boolean first) {
        if (this.hasContent(schemaAtt.nested())) {
            for (Map.Entry<String, SchemaAttribute> entry : schemaAtt.nested().entrySet()) {
                if (first) {
                    first = false;
                } else {
                    this.append(',');
                }
                this.serialize(entry.getValue());
            }
        }
        return first;
    }

    private void serialize(SchemaAttribute it) {
        this.grantNl();
        this.serializeAnnotations(it.annotations());
        this.indent();
        this.appendIdentifier(it.getName());
        this.append(" : ");
        if (it.type() == DataType.Structure) {
            this.append('{');
            this.open();
            this.serializeNested(it, true);
            this.grantNl();
            this.close();
            this.indent();
            this.append('}');
        } else {
            this.append(it.type().getText());
        }
    }

    public DcnToDclSerializer serialize(DcnContainer container) {
        if (container.schemas() != null) {
            for (Schema schema : container.schemas()) {
                this.serialize(schema);
                this.nl();
            }
        }
        if (container.functions() != null) {
            for (Function function : container.functions()) {
                this.serialize(function);
                this.nl();
            }
        }
        if (container.policies() != null) {
            for (Policy policy : container.policies()) {
                this.serialize(policy);
                this.nl();
            }
        }
        if (container.testCases() != null) {
            for (TestCase testCase : container.testCases()) {
                this.serialize(testCase);
                this.nl();
            }
        }
        return this;
    }

    public void serialize(TestCase it) {
        this.serializeAnnotations(it.annotations());
        this.indent();
        this.append("TEST");
        this.space();
        this.appendLastSegment(it.qualifiedName());
        this.space();
        this.append('{');
        this.nl();
        this.open();
        if (it.testAssertions() != null) {
            QualifiedName context = (QualifiedName)it.qualifiedName().subName(0, it.qualifiedName().size() - 1);
            for (TestAssertion assertion : it.testAssertions()) {
                this.serialize(assertion, context);
            }
        }
        this.close();
        this.append('}');
    }

    private void serialize(TestAssertion it, QualifiedName context) {
        this.indent();
        Object expect = it.expect();
        if (Objects.equals(expect, Boolean.TRUE)) {
            this.append("GRANT");
            this.space();
            this.serializeStarList(it.actions());
        } else if (Objects.equals(expect, Boolean.FALSE)) {
            this.append("DENY");
            this.space();
            this.serializeStarList(it.actions());
        } else {
            this.append("EXPECT");
            this.space();
            this.serializeExpression(expect);
            this.space();
            this.append("FOR");
            this.space();
            this.serializeStarList(it.actions());
        }
        this.space();
        this.append("ON");
        this.space();
        this.serializeStarList(it.resources());
        this.appendQualifiedNames("POLICY", it.policies(), context);
        this.appendQualifiedNames("SCOPEFILTER", it.scopeFilter(), context);
        if (DcnToDclSerializer.hasContent(it.testInputs())) {
            this.space();
            this.append("INPUT");
            boolean first = true;
            for (TestInput input : it.testInputs()) {
                if (first) {
                    first = false;
                } else {
                    this.append(COMMA_SEPARATOR);
                }
                this.serialize(input);
            }
        }
        this.append(';');
        this.nl();
    }

    private void serialize(Object value, AttributeName current, TestInput input, boolean brackets) {
        if (value instanceof Map) {
            if (brackets) {
                this.append('{');
            }
            boolean first = true;
            first = this.appendSpecials(current, input.ignores(), first, "IGNORE");
            first = this.appendSpecials(current, input.unknowns(), first, "UNKNOWN");
            Map o = (Map)value;
            for (Map.Entry entry : o.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    this.append(COMMA_SEPARATOR);
                }
                this.appendIdentifier((String)entry.getKey());
                this.append(": ");
                AttributeName fqn = (AttributeName)current.append((String)entry.getKey());
                this.serialize(entry.getValue(), fqn, input, true);
            }
            if (brackets) {
                this.append('}');
            }
        } else if (value instanceof String || value instanceof Boolean || value instanceof Number || value instanceof List || value instanceof Object[]) {
            this.serializeExpression(value);
        } else {
            throw new IllegalStateException("Not supported JMap Entry: " + value);
        }
    }

    private boolean appendSpecials(AttributeName start, List<AttributeName> attributes, boolean first, String specialValue) {
        if (DcnToDclSerializer.hasContent(attributes)) {
            for (AttributeName an : attributes) {
                if (an.size() != start.size() + 1 || !an.startsWith(start)) continue;
                if (first) {
                    first = false;
                } else {
                    this.append(COMMA_SEPARATOR);
                }
                this.appendIdentifier(an.getLastSegment());
                this.append(": ");
                this.append(specialValue);
            }
        }
        return first;
    }

    private void serialize(TestInput input) {
        this.append('{');
        if (this.hasContent(input.content())) {
            boolean first = true;
            for (Map.Entry<String, Object> e1 : input.content().entrySet()) {
                String section = e1.getKey();
                if (!"$app".equals(section) && !"$env".equals(section)) continue;
                if (first) {
                    first = false;
                } else {
                    this.append(COMMA_SEPARATOR);
                }
                if (!(e1.getValue() instanceof Map)) {
                    throw new IllegalStateException("Not supported JMap Entry: " + e1.getValue());
                }
                this.serialize(e1.getValue(), AttributeName.create(section), input, false);
            }
        }
        this.append('}');
    }

    private void appendQualifiedNames(String section, List<QualifiedName> qns, QualifiedName context) {
        if (DcnToDclSerializer.hasContent(qns)) {
            this.space();
            this.append(section);
            this.space();
            boolean first = true;
            for (QualifiedName qn : qns) {
                if (first) {
                    first = false;
                } else {
                    this.append(COMMA_SEPARATOR);
                }
                this.appendQualifiedName(qn, context);
            }
        }
    }

    private void serializeRestrict(List<Call> restrict) {
        if (DcnToDclSerializer.hasContent(restrict)) {
            this.space();
            this.append("RESTRICT ");
            boolean second = false;
            for (Call condition : restrict) {
                if (second) {
                    this.append(COMMA_SEPARATOR);
                } else {
                    second = true;
                }
                this.skipBracket = true;
                this.serializeExpression(condition);
                this.skipBracket = false;
            }
        }
    }

    private void serializeExpression(String prefix, Object condition) {
        if (condition != null) {
            this.space();
            this.append(prefix);
            this.append(' ');
            this.serializeExpression(condition);
        }
    }

    private void serializeExpression(Object value) {
        if (value instanceof Call) {
            Call c = (Call)value;
            QualifiedName qName = c.getQualifiedName();
            if (qName.size() > 1 && c.getArgumentCount() == 0) {
                this.appendQualifiedName(qName, null);
                this.append("()");
                return;
            }
            switch (c.getName()) {
                case "lt": {
                    this.serializeCall(c, 2, "<");
                    return;
                }
                case "le": {
                    this.serializeCall(c, 2, "<=");
                    return;
                }
                case "eq": {
                    this.serializeCall(c, 2, "=");
                    return;
                }
                case "ge": {
                    this.serializeCall(c, 2, ">=");
                    return;
                }
                case "gt": {
                    this.serializeCall(c, 2, ">");
                    return;
                }
                case "ne": {
                    this.serializeCall(c, 2, "<>");
                    return;
                }
                case "and": {
                    this.serializeCall(c, -1, "AND");
                    return;
                }
                case "or": {
                    this.serializeCall(c, -1, "OR");
                    return;
                }
                case "is_null": {
                    this.serializeCall(c, 1, "IS NULL");
                    return;
                }
                case "is_not_null": {
                    this.serializeCall(c, 1, "IS NOT NULL");
                    return;
                }
                case "in": {
                    this.serializeCall(c, 2, "IN");
                    return;
                }
                case "not_in": {
                    this.serializeCall(c, 2, "NOT IN");
                    return;
                }
                case "restricted": {
                    this.serializeCall(c, 1, "IS RESTRICTED");
                    return;
                }
                case "not_restricted": {
                    this.serializeCall(c, 1, "IS NOT RESTRICTED");
                    return;
                }
                case "like": {
                    if (c.getArgumentCount() == 2) {
                        this.serializeCall(c, 2, "LIKE");
                        return;
                    }
                    if (c.getArgumentCount() != 3) break;
                    this.serializeCall3(c, "LIKE", "ESCAPE");
                    return;
                }
                case "not_like": {
                    if (c.getArgumentCount() == 2) {
                        this.serializeCall(c, 2, "NOT LIKE");
                        return;
                    }
                    if (c.getArgumentCount() != 3) break;
                    this.serializeCall3(c, "NOT LIKE", "ESCAPE");
                    return;
                }
                case "between": {
                    this.serializeCall3(c, "BETWEEN", "AND");
                    return;
                }
                case "not_between": {
                    this.serializeCall3(c, "NOT BETWEEN", "AND");
                    return;
                }
            }
        } else {
            if (value instanceof AttributeName) {
                AttributeName an = (AttributeName)value;
                this.appendAttributeName(an);
                return;
            }
            if (value instanceof Boolean) {
                Boolean boolValue = (Boolean)value;
                this.append(boolValue != false ? "TRUE" : "FALSE");
                return;
            }
            if (value instanceof String) {
                String string = (String)value;
                this.appendStringConstant(string);
                return;
            }
            if (value instanceof Number) {
                Number number = (Number)value;
                this.append(number.toString());
                return;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                this.append("[");
                boolean second = false;
                for (Object condition : collection) {
                    if (second) {
                        this.append(COMMA_SEPARATOR);
                    } else {
                        second = true;
                    }
                    this.serializeExpression(condition);
                }
                this.append("]");
                return;
            }
        }
        throw new IllegalArgumentException("Not supported expression:" + value);
    }

    private void serializeCall(Call c, int count, String op) {
        if (count > 0 && c.getArgumentCount() != count) {
            throw new IllegalArgumentException();
        }
        boolean skip = this.skipBracket;
        this.skipBracket = false;
        if (!skip) {
            this.append('(');
        }
        int end = c.getArgumentCount();
        for (int i = 0; i < end; ++i) {
            if (i != 0) {
                this.append(' ');
                this.append(op);
                this.append(' ');
            }
            this.serializeExpression(c.getArgument(i));
        }
        if (count == 1) {
            this.append(' ');
            this.append(op);
        }
        if (!skip) {
            this.append(")");
        }
    }

    private void serializeCall3(Call c, String op1, String op2) {
        if (c.getArgumentCount() != 3) {
            throw new IllegalArgumentException();
        }
        boolean skip = this.skipBracket;
        this.skipBracket = false;
        if (!skip) {
            this.append('(');
        }
        this.serializeExpression(c.getArgument(0));
        this.append(' ');
        this.append(op1);
        this.append(' ');
        this.serializeExpression(c.getArgument(1));
        this.append(' ');
        this.append(op2);
        this.append(' ');
        this.serializeExpression(c.getArgument(2));
        if (!skip) {
            this.append(")");
        }
    }

    private void serializeStarList(List<String> elements) {
        if (elements == null || elements.isEmpty()) {
            this.append("*");
        } else {
            boolean second = false;
            for (String el : elements) {
                if (second) {
                    this.append(COMMA_SEPARATOR);
                } else {
                    second = true;
                }
                this.appendIdentifier(el);
            }
        }
    }

    private void grantNl() {
        int last = this.sb.length();
        if (last > 0 && this.sb.charAt(last - 1) != '\n') {
            this.nl();
        }
    }

    private void nl() {
        this.sb.append('\n');
    }

    private void append(char ch) {
        this.sb.append(ch);
    }

    private void append(String data) {
        this.sb.append(data);
    }

    private void space() {
        this.sb.append(' ');
    }

    private void appendStringConstant(String data) {
        int length = data.length();
        if (length == 0) {
            this.sb.append("''");
            return;
        }
        String[] arr = ESCAPED;
        this.sb.append('\'');
        for (int i = 0; i < length; ++i) {
            char ch = data.charAt(i);
            if (!DcnToDclSerializer.doEscape(ch)) {
                int start = i;
                while (++i < length && !DcnToDclSerializer.doEscape(ch = data.charAt(i))) {
                }
                this.sb.append(data, start, i);
                if (i == length) break;
            }
            if (ch < arr.length) {
                this.sb.append(arr[ch]);
                continue;
            }
            DcnToDclSerializer.appendUnicode(this.sb, ch);
        }
        this.sb.append('\'');
    }

    private static boolean doEscape(char ch) {
        return ch < ' ' || ch == '\"' || ch == '\'' || ch == '\\';
    }

    private static void appendUnicode(StringBuilder sb, char ch) {
        sb.append("\\u");
        for (int i = 12; i >= 0; i -= 4) {
            int val = ch >> i & 0xF;
            sb.append((char)(val <= 10 ? 48 + val : 55 + val));
        }
    }

    static {
        DcnToDclSerializer.ESCAPED[8] = "\\b";
        DcnToDclSerializer.ESCAPED[9] = "\\t";
        DcnToDclSerializer.ESCAPED[10] = "\\n";
        DcnToDclSerializer.ESCAPED[12] = "\\f";
        DcnToDclSerializer.ESCAPED[13] = "\\r";
        DcnToDclSerializer.ESCAPED[34] = "\\\"";
        DcnToDclSerializer.ESCAPED[39] = "\\'";
        DcnToDclSerializer.ESCAPED[92] = "\\\\";
        StringBuilder sb = new StringBuilder();
        for (char ch = '\u0000'; ch < ESCAPED.length; ch = (char)((char)(ch + 1))) {
            if (ESCAPED[ch] != null || ch >= ' ') continue;
            DcnToDclSerializer.appendUnicode(sb, ch);
            DcnToDclSerializer.ESCAPED[ch] = sb.toString();
            sb.setLength(0);
        }
        for (int i = 0; i < ESCAPED.length; ++i) {
            if (ESCAPED[i] != null == DcnToDclSerializer.doEscape((char)i)) continue;
            throw new IllegalStateException("doEscape does not match cache");
        }
    }
}

