/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.support.validation;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.sap.cloud.security.ams.dcl.support.validation.ValidationCache;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.validation.ResourceValidatorImpl;

public class CachingResourceValidatorImpl
extends ResourceValidatorImpl {
    @Inject
    private Injector injector;

    @Override
    protected void validate(Resource resource, CheckMode mode, CancelIndicator monitor, IAcceptor<Issue> acceptor) {
        ResourceSet resourceSet = resource.getResourceSet();
        boolean remove = ValidationCache.grantValidationCache(resourceSet, this.injector);
        try {
            super.validate(resource, mode, monitor, acceptor);
        }
        finally {
            if (remove) {
                ValidationCache.removeValidationCache(resourceSet);
            }
        }
    }
}

